/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.util;

import afu.org.apache.commons.bcel6.classfile.ClassParser;
import afu.org.apache.commons.bcel6.classfile.JavaClass;
import afu.org.apache.commons.bcel6.util.ClassPath;
import afu.org.apache.commons.bcel6.util.Repository;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.KeyForBottom;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.Nullable;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.SignatureBottom;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class ClassLoaderRepository
implements Repository {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassLoader loader;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass> loadedClasses = new HashMap<String, JavaClass>();

    public ClassLoaderRepository(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public void storeClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass clazz) {
        this.loadedClasses.put(clazz.getClassName(), clazz);
        clazz.setRepository(this);
    }

    @Override
    public void removeClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass clazz) {
        this.loadedClasses.remove(clazz.getClassName());
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass findClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String className) {
        return this.loadedClasses.containsKey(className) ? this.loadedClasses.get(className) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass loadClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String className) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassNotFoundException {
        JavaClass javaClass;
        String classFile = className.replace('.', '/');
        JavaClass RC = this.findClass(className);
        if (RC != null) {
            return RC;
        }
        InputStream is = this.loader.getResourceAsStream(classFile + ".class");
        if (is == null) {
            throw new ClassNotFoundException(className + " not found.");
        }
        try {
            ClassParser parser = new ClassParser(is, className);
            RC = parser.parse();
            this.storeClass(RC);
            javaClass = RC;
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ClassNotFoundException(className + " not found: " + e, e);
            }
        }
        is.close();
        return javaClass;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass loadClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Class<@UnknownInterned @Interned @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized @UnannotatedString @SignatureBottom ?> clazz) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassNotFoundException {
        return this.loadClass(clazz.getName());
    }

    @Override
    public void clear() {
        this.loadedClasses.clear();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassPath getClassPath() {
        return null;
    }
}

