/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.util;

import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.Pure;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPath {
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassPath SYSTEM_CLASS_PATH = new ClassPath(ClassPath.getClassPath());
    private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FilenameFilter ARCHIVE_FILTER = new FilenameFilter(){

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString File dir, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name) {
            return (name = name.toLowerCase(Locale.ENGLISH)).endsWith(".zip") || name.endsWith(".jar");
        }
    };
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString PathEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] paths;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String class_path;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassPath parent;

    public ClassPath(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassPath parent, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String class_path) {
        this(class_path);
        this.parent = parent;
    }

    public ClassPath(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String class_path) {
        this.class_path = class_path;
        ArrayList<PathEntry> vec = new ArrayList<PathEntry>();
        StringTokenizer tok = new StringTokenizer(class_path, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            String path = tok.nextToken();
            if (path.equals("")) continue;
            File file = new File(path);
            try {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    vec.add(new Dir(path));
                    continue;
                }
                vec.add(new Zip(new ZipFile(file)));
            }
            catch (IOException e) {
                if (!path.endsWith(".zip") && !path.endsWith(".jar")) continue;
                System.err.println("CLASSPATH component " + file + ": " + e);
            }
        }
        this.paths = new PathEntry[vec.size()];
        vec.toArray(this.paths);
    }

    @Deprecated
    public ClassPath() {
        this(ClassPath.getClassPath());
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        if (this.parent != null) {
            return this.parent + File.pathSeparator + this.class_path;
        }
        return this.class_path;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int hashCode() {
        if (this.parent != null) {
            return this.class_path.hashCode() + this.parent.hashCode();
        }
        return this.class_path.hashCode();
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object o) {
        if (o instanceof ClassPath) {
            ClassPath cp = (ClassPath)o;
            return this.class_path.equals(cp.toString());
        }
        return false;
    }

    private static void getPathComponents(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String path, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String> list) {
        if (path != null) {
            StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                String name = tok.nextToken();
                File file = new File(name);
                if (!file.exists()) continue;
                list.add(name);
            }
        }
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getClassPath() {
        String class_path = System.getProperty("java.class.path");
        String boot_path = System.getProperty("sun.boot.class.path");
        String ext_path = System.getProperty("java.ext.dirs");
        ArrayList<String> list = new ArrayList<String>();
        ClassPath.getPathComponents(class_path, list);
        ClassPath.getPathComponents(boot_path, list);
        ArrayList<String> dirs = new ArrayList<String>();
        ClassPath.getPathComponents(ext_path, dirs);
        for (String d : dirs) {
            File ext_dir = new File(d);
            String[] extensions = ext_dir.list(ARCHIVE_FILTER);
            if (extensions == null) continue;
            for (String extension : extensions) {
                list.add(ext_dir.getPath() + File.separatorChar + extension);
            }
        }
        StringBuilder buf = new StringBuilder();
        String separator = "";
        for (String path : list) {
            buf.append(separator);
            separator = File.pathSeparator;
            buf.append(path);
        }
        return buf.toString().intern();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InputStream getInputStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        return this.getInputStream(name.replace('.', '/'), ".class");
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InputStream getInputStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResourceAsStream(name + suffix);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (is != null) {
            return is;
        }
        return this.getClassFile(name, suffix).getInputStream();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InputStream getResourceAsStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name) {
        for (PathEntry path : this.paths) {
            InputStream is = path.getResourceAsStream(name);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString URL getResource(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name) {
        for (PathEntry path : this.paths) {
            URL url = path.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Enumeration<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString URL> getResources(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name) {
        Vector<URL> results = new Vector<URL>();
        for (PathEntry path : this.paths) {
            URL url = path.getResource(name);
            if (url == null) continue;
            results.add(url);
        }
        return results.elements();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassFile getClassFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        ClassFile cf = null;
        if (this.parent != null) {
            cf = this.parent.getClassFileInternal(name, suffix);
        }
        if (cf == null) {
            cf = this.getClassFileInternal(name, suffix);
        }
        if (cf != null) {
            return cf;
        }
        throw new IOException("Couldn't find: " + name + suffix);
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassFile getClassFileInternal(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        for (PathEntry path : this.paths) {
            ClassFile cf = path.getClassFile(name, suffix);
            if (cf == null) continue;
            return cf;
        }
        return null;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassFile getClassFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        return this.getClassFile(name, ".class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getBytes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        try (FilterInputStream dis = null;){
            InputStream is = this.getInputStream(name, suffix);
            if (is == null) {
                throw new IOException("Couldn't find: " + name + suffix);
            }
            dis = new DataInputStream(is);
            byte[] bytes = new byte[is.available()];
            ((DataInputStream)dis).readFully(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getBytes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        return this.getBytes(name, ".class");
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getPath(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        int index = name.lastIndexOf(46);
        String suffix = "";
        if (index > 0) {
            suffix = name.substring(index);
            name = name.substring(0, index);
        }
        return this.getPath(name, suffix);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getPath(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        return this.getClassFile(name, suffix).getPath();
    }

    private static class Zip
    extends PathEntry {
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ZipFile zip;

        Zip(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ZipFile z) {
            this.zip = z;
        }

        @Override
        @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString URL getResource(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name) {
            ZipEntry entry = this.zip.getEntry(name);
            try {
                return entry != null ? new URL("jar:file:" + this.zip.getName() + "!/" + name) : null;
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        @Override
        @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InputStream getResourceAsStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name) {
            ZipEntry entry = this.zip.getEntry(name);
            try {
                return entry != null ? this.zip.getInputStream(entry) : null;
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassFile getClassFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
            final ZipEntry entry = this.zip.getEntry(name.replace('.', '/') + suffix);
            if (entry == null) {
                return null;
            }
            return new ClassFile(){

                @Override
                public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InputStream getInputStream() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
                    return Zip.this.zip.getInputStream(entry);
                }

                @Override
                public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getPath() {
                    return entry.toString();
                }

                @Override
                public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString long getTime() {
                    return entry.getTime();
                }

                @Override
                public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString long getSize() {
                    return entry.getSize();
                }

                @Override
                public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getBase() {
                    return Zip.this.zip.getName();
                }
            };
        }
    }

    private static class Dir
    extends PathEntry {
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String dir;

        Dir(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String d) {
            this.dir = d;
        }

        @Override
        @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString URL getResource(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name) {
            File file = new File(this.dir + File.separatorChar + name.replace('/', File.separatorChar));
            try {
                return file.exists() ? file.toURI().toURL() : null;
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        @Override
        @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InputStream getResourceAsStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name) {
            File file = new File(this.dir + File.separatorChar + name.replace('/', File.separatorChar));
            try {
                return file.exists() ? new FileInputStream(file) : null;
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassFile getClassFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String suffix) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
            final File file = new File(this.dir + File.separatorChar + name.replace('.', File.separatorChar) + suffix);
            return file.exists() ? new ClassFile(){

                @Override
                public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InputStream getInputStream() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
                    return new FileInputStream(file);
                }

                @Override
                public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getPath() {
                    try {
                        return file.getCanonicalPath();
                    }
                    catch (IOException e) {
                        return null;
                    }
                }

                @Override
                public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString long getTime() {
                    return file.lastModified();
                }

                @Override
                public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString long getSize() {
                    return file.length();
                }

                @Override
                public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getBase() {
                    return Dir.this.dir;
                }
            } : null;
        }

        @SideEffectFree
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
            return this.dir;
        }
    }

    public static interface ClassFile {
        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InputStream getInputStream() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException;

        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getPath();

        public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getBase();

        public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString long getTime();

        public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString long getSize();
    }

    private static abstract class PathEntry {
        private PathEntry() {
        }

        abstract @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassFile getClassFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String var1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String var2) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException;

        abstract @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString URL getResource(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String var1);

        abstract @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InputStream getResourceAsStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String var1);
    }
}

