/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tigris.subversion.javahl;

import afu.org.apache.subversion.javahl.ConflictDescriptor;
import afu.org.apache.subversion.javahl.types.Checksum;
import afu.org.apache.subversion.javahl.types.Info;
import afu.org.tigris.subversion.javahl.ConflictDescriptor;
import afu.org.tigris.subversion.javahl.Depth;
import afu.org.tigris.subversion.javahl.Lock;
import afu.org.tigris.subversion.javahl.NodeKind;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Info2
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String path;
    private String url;
    private long rev;
    private int kind;
    private String reposRootUrl;
    private String reposUUID;
    private long lastChangedRev;
    private long lastChangedDate;
    private String lastChangedAuthor;
    private Lock lock;
    private boolean hasWcInfo;
    private int schedule;
    private String copyFromUrl;
    private long copyFromRev;
    private long textTime;
    private long propTime;
    private String checksum;
    private String conflictOld;
    private String conflictNew;
    private String conflictWrk;
    private String prejfile;
    private String changelistName;
    private long workingSize;
    private long reposSize;
    private int depth;
    private ConflictDescriptor treeConflict;

    Info2(String path, String url, long rev, int kind, String reposRootUrl, String reposUUID, long lastChangedRev, long lastChangedDate, String lastChangedAuthor, Lock lock, boolean hasWcInfo, int schedule, String copyFromUrl, long copyFromRev, long textTime, long propTime, String checksum, String conflictOld, String conflictNew, String conflictWrk, String prejfile, String changelistName, long workingSize, long reposSize, int depth, ConflictDescriptor treeConflict) {
        this.path = path;
        this.url = url;
        this.rev = rev;
        this.kind = kind;
        this.reposRootUrl = reposRootUrl;
        this.reposUUID = reposUUID;
        this.lastChangedRev = lastChangedRev;
        this.lastChangedDate = lastChangedDate;
        this.lastChangedAuthor = lastChangedAuthor;
        this.lock = lock;
        this.hasWcInfo = hasWcInfo;
        this.schedule = schedule;
        this.copyFromUrl = copyFromUrl;
        this.copyFromRev = copyFromRev;
        this.textTime = textTime;
        this.propTime = propTime;
        this.checksum = checksum;
        this.conflictOld = conflictOld;
        this.conflictNew = conflictNew;
        this.conflictWrk = conflictWrk;
        this.prejfile = prejfile;
        this.changelistName = changelistName;
        this.workingSize = workingSize;
        this.reposSize = reposSize;
        this.depth = depth;
        this.treeConflict = treeConflict;
    }

    private static String getConflictOld(Set<afu.org.apache.subversion.javahl.ConflictDescriptor> conflicts) {
        if (conflicts == null) {
            return null;
        }
        for (afu.org.apache.subversion.javahl.ConflictDescriptor conflict : conflicts) {
            if (conflict.getKind() != ConflictDescriptor.Kind.text) continue;
            return conflict.getBasePath();
        }
        return null;
    }

    private static String getConflictNew(Set<afu.org.apache.subversion.javahl.ConflictDescriptor> conflicts) {
        if (conflicts == null) {
            return null;
        }
        for (afu.org.apache.subversion.javahl.ConflictDescriptor conflict : conflicts) {
            if (conflict.getKind() != ConflictDescriptor.Kind.text) continue;
            return conflict.getTheirPath();
        }
        return null;
    }

    private static String getConflictWrk(Set<afu.org.apache.subversion.javahl.ConflictDescriptor> conflicts) {
        if (conflicts == null) {
            return null;
        }
        for (afu.org.apache.subversion.javahl.ConflictDescriptor conflict : conflicts) {
            if (conflict.getKind() != ConflictDescriptor.Kind.text) continue;
            return conflict.getMyPath();
        }
        return null;
    }

    private static String getPrejfile(Set<afu.org.apache.subversion.javahl.ConflictDescriptor> conflicts) {
        if (conflicts == null) {
            return null;
        }
        for (afu.org.apache.subversion.javahl.ConflictDescriptor conflict : conflicts) {
            if (conflict.getKind() != ConflictDescriptor.Kind.property) continue;
            return conflict.getTheirPath();
        }
        return null;
    }

    private static ConflictDescriptor getTreeConflict(Set<afu.org.apache.subversion.javahl.ConflictDescriptor> conflicts) {
        if (conflicts == null) {
            return null;
        }
        for (afu.org.apache.subversion.javahl.ConflictDescriptor conflict : conflicts) {
            if (conflict.getKind() != ConflictDescriptor.Kind.tree) continue;
            return new ConflictDescriptor(conflict);
        }
        return null;
    }

    private static String getChecksumDigest(Checksum checksum) {
        if (checksum == null) {
            return null;
        }
        if (checksum.getKind() != Checksum.Kind.MD5) {
            return null;
        }
        StringBuffer hexDigest = new StringBuffer();
        for (byte b : checksum.getDigest()) {
            hexDigest.append(Integer.toHexString(0xFF & b));
        }
        return hexDigest.toString();
    }

    public Info2(Info aInfo) {
        this(aInfo.getPath(), aInfo.getUrl(), aInfo.getRev(), NodeKind.fromApache(aInfo.getKind()), aInfo.getReposRootUrl(), aInfo.getReposUUID(), aInfo.getLastChangedRev(), aInfo.getLastChangedDate() == null ? 0L : aInfo.getLastChangedDate().getTime() * 1000L, aInfo.getLastChangedAuthor(), aInfo.getLock() == null ? null : new Lock(aInfo.getLock()), aInfo.isHasWcInfo(), aInfo.getSchedule() == null ? 0 : aInfo.getSchedule().ordinal(), aInfo.getCopyFromUrl(), aInfo.getCopyFromRev(), aInfo.getTextTime() == null ? 0L : aInfo.getTextTime().getTime() * 1000L, 0L, Info2.getChecksumDigest(aInfo.getChecksum()), Info2.getConflictOld(aInfo.getConflicts()), Info2.getConflictNew(aInfo.getConflicts()), Info2.getConflictWrk(aInfo.getConflicts()), Info2.getPrejfile(aInfo.getConflicts()), aInfo.getChangelistName(), aInfo.getWorkingSize(), aInfo.getReposSize(), Depth.fromADepth(aInfo.getDepth()), Info2.getTreeConflict(aInfo.getConflicts()));
    }

    public String getPath() {
        return this.path;
    }

    public String getUrl() {
        return this.url;
    }

    public long getRev() {
        return this.rev;
    }

    public int getKind() {
        return this.kind;
    }

    public String getReposRootUrl() {
        return this.reposRootUrl;
    }

    public String getReposUUID() {
        return this.reposUUID;
    }

    public long getLastChangedRev() {
        return this.lastChangedRev;
    }

    public Date getLastChangedDate() {
        if (this.lastChangedDate == 0L) {
            return null;
        }
        return new Date(this.lastChangedDate / 1000L);
    }

    public String getLastChangedAuthor() {
        return this.lastChangedAuthor;
    }

    public Lock getLock() {
        return this.lock;
    }

    public boolean isHasWcInfo() {
        return this.hasWcInfo;
    }

    public int getSchedule() {
        return this.schedule;
    }

    public String getCopyFromUrl() {
        return this.copyFromUrl;
    }

    public long getCopyFromRev() {
        return this.copyFromRev;
    }

    public Date getTextTime() {
        if (this.textTime == 0L) {
            return null;
        }
        return new Date(this.textTime / 1000L);
    }

    public Date getPropTime() {
        if (this.propTime == 0L) {
            return null;
        }
        return new Date(this.propTime / 1000L);
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String getConflictOld() {
        return this.conflictOld;
    }

    public String getConflictNew() {
        return this.conflictNew;
    }

    public String getConflictWrk() {
        return this.conflictWrk;
    }

    public String getPrejfile() {
        return this.prejfile;
    }

    public String getChangelistName() {
        return this.changelistName;
    }

    public long getWorkingSize() {
        return this.workingSize;
    }

    public long getReposSize() {
        return this.reposSize;
    }

    public int getDepth() {
        return this.depth;
    }

    public ConflictDescriptor getConflictDescriptor() {
        return this.treeConflict;
    }

    public String toString() {
        return this.getUrl();
    }
}

