/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svnlook;

import afu.org.tmatesoft.svn.cli.svnlook.SVNLookCommand;
import afu.org.tmatesoft.svn.cli.svnlook.SVNLookOption;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNProperties;
import afu.org.tmatesoft.svn.core.SVNPropertyValue;
import afu.org.tmatesoft.svn.core.internal.util.SVNDate;
import java.util.Collection;
import java.util.LinkedList;

public class SVNLookDateCommand
extends SVNLookCommand {
    protected SVNLookDateCommand() {
        super("date", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNLookOption> options = new LinkedList<SVNLookOption>();
        options.add(SVNLookOption.REVISION);
        options.add(SVNLookOption.TRANSACTION);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNProperties props = this.getProperties();
        SVNPropertyValue value = props.getSVNPropertyValue("svn:date");
        if (value != null && value.getString() != null) {
            SVNDate date = SVNDate.parseDate(value.getString());
            this.getEnvironment().getOut().print(SVNDate.formatHumanDate(date, null));
        }
        this.getEnvironment().getOut().println();
    }
}

