/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svnlook;

import afu.org.tmatesoft.svn.cli.svnlook.SVNLookCommand;
import afu.org.tmatesoft.svn.cli.svnlook.SVNLookCommandEnvironment;
import afu.org.tmatesoft.svn.cli.svnlook.SVNLookOption;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.wc.admin.ISVNChangedDirectoriesHandler;
import afu.org.tmatesoft.svn.core.wc.admin.SVNLookClient;
import java.util.Collection;
import java.util.LinkedList;

public class SVNLookDirsChangedCommand
extends SVNLookCommand
implements ISVNChangedDirectoriesHandler {
    public SVNLookDirsChangedCommand() {
        super("dirs-changed", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNLookOption> options = new LinkedList<SVNLookOption>();
        options.add(SVNLookOption.REVISION);
        options.add(SVNLookOption.TRANSACTION);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNLookCommandEnvironment environment = this.getSVNLookEnvironment();
        SVNLookClient client = environment.getClientManager().getLookClient();
        if (environment.isRevision()) {
            client.doGetChangedDirectories(environment.getRepositoryFile(), this.getRevisionObject(), (ISVNChangedDirectoriesHandler)this);
        } else {
            client.doGetChangedDirectories(environment.getRepositoryFile(), environment.getTransaction(), (ISVNChangedDirectoriesHandler)this);
        }
    }

    @Override
    public void handleDir(String path) throws SVNException {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        this.getSVNLookEnvironment().getOut().println(path);
    }
}

