/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svnlook;

import afu.org.tmatesoft.svn.cli.svnlook.SVNLookCommand;
import afu.org.tmatesoft.svn.cli.svnlook.SVNLookCommandEnvironment;
import afu.org.tmatesoft.svn.cli.svnlook.SVNLookOption;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.wc.admin.ISVNHistoryHandler;
import afu.org.tmatesoft.svn.core.wc.admin.SVNAdminPath;
import afu.org.tmatesoft.svn.core.wc.admin.SVNLookClient;
import java.util.Collection;
import java.util.LinkedList;

public class SVNLookHistoryCommand
extends SVNLookCommand
implements ISVNHistoryHandler {
    public SVNLookHistoryCommand() {
        super("history", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNLookOption> options = new LinkedList<SVNLookOption>();
        options.add(SVNLookOption.REVISION);
        options.add(SVNLookOption.SHOW_IDS);
        options.add(SVNLookOption.LIMIT);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNLookCommandEnvironment environment = this.getSVNLookEnvironment();
        if (environment.isShowIDs()) {
            environment.getOut().println("REVISION   PATH <ID>");
            environment.getOut().println("--------   ---------");
        } else {
            environment.getOut().println("REVISION   PATH");
            environment.getOut().println("--------   ----");
        }
        SVNLookClient client = environment.getClientManager().getLookClient();
        client.doGetHistory(environment.getRepositoryFile(), environment.getFirstArgument(), this.getRevisionObject(), environment.isShowIDs(), environment.getLimit(), this);
    }

    @Override
    public void handlePath(SVNAdminPath path) throws SVNException {
        if (path != null) {
            SVNLookCommandEnvironment environment = this.getSVNLookEnvironment();
            if (environment.isShowIDs()) {
                environment.getOut().println(path.getRevision() + "   " + path.getPath() + " <" + path.getNodeID() + ">");
            } else {
                environment.getOut().println(path.getRevision() + "   " + path.getPath());
            }
        }
    }
}

