/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svnsync;

import afu.org.tmatesoft.svn.cli.svnsync.SVNSyncCommand;
import afu.org.tmatesoft.svn.cli.svnsync.SVNSyncOption;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNPath;
import afu.org.tmatesoft.svn.core.wc.SVNRevision;
import afu.org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import afu.org.tmatesoft.svn.core.wc.admin.SVNSyncInfo;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class SVNSyncInfoCommand
extends SVNSyncCommand {
    public SVNSyncInfoCommand() {
        super("info", null, 1);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNSyncOption> options = new LinkedList<SVNSyncOption>();
        options.add(SVNSyncOption.NON_INTERACTIVE);
        options.add(SVNSyncOption.NO_AUTH_CACHE);
        options.add(SVNSyncOption.USERNAME);
        options.add(SVNSyncOption.PASSWORD);
        options.add(SVNSyncOption.TRUST_SERVER_CERT);
        options.add(SVNSyncOption.SOURCE_USERNAME);
        options.add(SVNSyncOption.SOURCE_PASSWORD);
        options.add(SVNSyncOption.SYNC_USERNAME);
        options.add(SVNSyncOption.SYNC_PASSWORD);
        options.add(SVNSyncOption.CONFIG_DIR);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNPath toURL;
        SVNErrorMessage err;
        List<String> targets = this.getEnvironment().combineTargets(null, false);
        if (targets.size() < 1) {
            err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS);
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        if (targets.size() > 1) {
            err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR);
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        if (!(toURL = new SVNPath(targets.get(0))).isURL()) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Path ''{0}'' is not a URL", (Object)toURL.getTarget());
            SVNErrorManager.error(err2, SVNLogType.CLIENT);
        }
        SVNAdminClient client = this.getEnvironment().getClientManager().getAdminClient();
        SVNSyncInfo info = client.doInfo(toURL.getURL());
        this.getSVNSyncEnvironment().getOut().println("Source URL: " + info.getSrcURL());
        if (info.getSourceRepositoryUUID() != null) {
            this.getSVNSyncEnvironment().getOut().println("Source Repository UUID: " + info.getSourceRepositoryUUID());
        }
        if (SVNRevision.isValidRevisionNumber(info.getLastMergedRevision())) {
            this.getSVNSyncEnvironment().getOut().println("Last Merged Revision: " + info.getLastMergedRevision());
        }
    }
}

