/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.db;

import afu.org.tmatesoft.sqljet.core.SqlJetException;
import afu.org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import afu.org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.db.ISVNSqlJetTrigger;
import afu.org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import afu.org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import afu.org.tmatesoft.svn.core.internal.wc17.db.SvnNodesPristineTrigger;
import afu.org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;

public class SVNSqlJetDeleteStatement
extends SVNSqlJetSelectStatement {
    public SVNSqlJetDeleteStatement(SVNSqlJetDb sDb, Enum<?> fromTable) throws SVNException {
        super(sDb, fromTable);
        this.transactionMode = SqlJetTransactionMode.WRITE;
        if (SVNWCDbSchema.NODES == fromTable) {
            SvnNodesPristineTrigger trigger = new SvnNodesPristineTrigger();
            this.addTrigger(trigger);
        }
    }

    protected void beforeDelete(ISqlJetCursor cursor) {
        for (ISVNSqlJetTrigger trigger : this.getTriggers()) {
            try {
                trigger.beforeDelete(cursor);
            }
            catch (SqlJetException e) {}
        }
    }

    @Override
    public long exec() throws SVNException {
        long n = 0L;
        this.statementStarted();
        while (!this.eof()) {
            try {
                this.beforeDelete(this.getCursor());
                this.getCursor().delete();
            }
            catch (SqlJetException e) {
                this.statementCompleted(e);
                SVNSqlJetDb.createSqlJetError(e);
                return n;
            }
            ++n;
        }
        this.statementCompleted(null);
        return n;
    }
}

