/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.dav.handlers;

import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import afu.org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import afu.org.tmatesoft.svn.core.internal.util.SVNDate;
import afu.org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.util.SVNLogType;
import afu.org.xml.sax.Attributes;
import java.util.Date;

public class DAVDateRevisionHandler
extends BasicDAVHandler {
    private long myRevisionNumber;

    public static StringBuffer generateDateRevisionRequest(StringBuffer xmlBuffer, Date date) {
        xmlBuffer = xmlBuffer == null ? new StringBuffer() : xmlBuffer;
        SVNXMLUtil.addXMLHeader(xmlBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("S", "dated-rev-report", SVN_DAV_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, xmlBuffer);
        SVNXMLUtil.openCDataTag("D", "creationdate", SVNDate.formatDate(date), xmlBuffer);
        SVNXMLUtil.addXMLFooter("S", "dated-rev-report", xmlBuffer);
        return xmlBuffer;
    }

    public DAVDateRevisionHandler() {
        this.init();
        this.myRevisionNumber = -1L;
    }

    public long getRevisionNumber() {
        return this.myRevisionNumber;
    }

    @Override
    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        if (element == DAVElement.VERSION_NAME && cdata != null) {
            try {
                this.myRevisionNumber = Long.parseLong(cdata.toString());
            }
            catch (NumberFormatException nfe) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
            }
        }
    }

    @Override
    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) {
    }
}

