/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.dav.handlers;

import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import afu.org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import afu.org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.util.SVNLogType;
import afu.org.xml.sax.Attributes;

public class DAVDeletedRevisionHandler
extends BasicDAVHandler {
    private long myRevision;

    public static StringBuffer generateGetDeletedRevisionRequest(StringBuffer xmlBuffer, String path, long pegRevision, long endRevision) {
        xmlBuffer = xmlBuffer == null ? new StringBuffer() : xmlBuffer;
        SVNXMLUtil.addXMLHeader(xmlBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("S", "get-deleted-rev-report", SVN_DAV_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, xmlBuffer);
        SVNXMLUtil.openCDataTag("S", "path", path, xmlBuffer);
        SVNXMLUtil.openCDataTag("S", "peg-revision", String.valueOf(pegRevision), xmlBuffer);
        SVNXMLUtil.openCDataTag("S", "end-revision", String.valueOf(endRevision), xmlBuffer);
        SVNXMLUtil.addXMLFooter("S", "get-deleted-rev-report", xmlBuffer);
        return xmlBuffer;
    }

    public DAVDeletedRevisionHandler() {
        this.init();
        this.myRevision = -1L;
    }

    @Override
    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        if (element == DAVElement.VERSION_NAME && cdata != null) {
            try {
                this.myRevision = Long.parseLong(cdata.toString());
            }
            catch (NumberFormatException nfe) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
            }
        }
    }

    @Override
    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
    }

    public long getRevision() {
        return this.myRevision;
    }
}

