/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.fs;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends FilterOutputStream {
    private long myPosition;

    public CountingOutputStream(OutputStream stream, long offset) {
        super(stream);
        this.myPosition = offset >= 0L ? offset : 0L;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.myPosition += (long)len;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.myPosition;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.myPosition += (long)b.length;
    }

    public long getPosition() {
        return this.myPosition;
    }
}

