/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.fs;

import afu.org.tmatesoft.svn.core.ISVNCanceller;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSFS;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import afu.org.tmatesoft.svn.core.internal.io.fs.FSWriteLock;
import afu.org.tmatesoft.svn.core.internal.io.fs.revprop.SVNFSFSPackedRevProps;
import afu.org.tmatesoft.svn.core.internal.io.fs.revprop.SVNFSFSPackedRevPropsManifest;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import afu.org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import afu.org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FSPacker {
    private ISVNCanceller myCanceller;
    private ISVNAdminEventHandler myNotifyHandler;

    public FSPacker(ISVNAdminEventHandler notifyHandler) {
        this.myCanceller = notifyHandler == null ? ISVNCanceller.NULL : notifyHandler;
        this.myNotifyHandler = notifyHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pack(FSFS fsfs) throws SVNException {
        FSWriteLock writeLock;
        FSWriteLock fSWriteLock = writeLock = FSWriteLock.getWriteLockForDB(fsfs);
        synchronized (fSWriteLock) {
            try {
                writeLock.lock();
                this.packImpl(fsfs);
            }
            finally {
                writeLock.unlock();
                FSWriteLock.release(writeLock);
            }
        }
    }

    private void packImpl(FSFS fsfs) throws SVNException {
        boolean packRevisionProperties;
        long maxFilesPerDirectory;
        int format = fsfs.getDBFormat();
        if (format < 4) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_UNSUPPORTED_FORMAT, "FS format too old to pack, please upgrade.");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if ((maxFilesPerDirectory = fsfs.getMaxFilesPerDirectory()) <= 0L) {
            return;
        }
        long minUnpackedRev = fsfs.getMinUnpackedRev();
        long youngestRev = fsfs.getYoungestRevision();
        long completedShards = (youngestRev + 1L) / maxFilesPerDirectory;
        long minUnpackedRevProp = 0L;
        boolean bl = packRevisionProperties = fsfs.getDBFormat() >= 6;
        if (packRevisionProperties) {
            minUnpackedRevProp = fsfs.getMinUnpackedRevProp();
        }
        if (minUnpackedRev == completedShards * maxFilesPerDirectory && minUnpackedRevProp == completedShards * maxFilesPerDirectory) {
            return;
        }
        for (long i = minUnpackedRev / maxFilesPerDirectory; i < completedShards; ++i) {
            this.myCanceller.checkCancelled();
            this.packShard(fsfs, i, packRevisionProperties);
        }
    }

    private void packShard(FSFS fsfs, long shard, boolean packRevisionProperties) throws SVNException {
        File revShardPath = new File(fsfs.getDBRevsDir(), String.valueOf(shard));
        File revpropShardPath = new File(fsfs.getRevisionPropertiesRoot(), String.valueOf(shard));
        this.packRevShard(fsfs, shard, revShardPath);
        if (packRevisionProperties) {
            this.myCanceller.checkCancelled();
            this.packRevPropShard(fsfs, shard, revpropShardPath, (long)(0.9 * (double)fsfs.getRevPropPackSize()));
        }
        File finalPath = fsfs.getMinUnpackedRevFile();
        File tmpFile = SVNFileUtil.createUniqueFile(fsfs.getDBRoot(), "tempfile", ".tmp", false);
        String line = String.valueOf((shard + 1L) * fsfs.getMaxFilesPerDirectory()) + '\n';
        SVNFileUtil.writeToFile(tmpFile, line, "UTF-8");
        SVNFileUtil.rename(tmpFile, finalPath);
        SVNFileUtil.deleteAll(revShardPath, true, this.myCanceller);
        if (packRevisionProperties) {
            this.deleteRevPropShard(revpropShardPath, shard, fsfs.getMaxFilesPerDirectory());
        }
        this.firePackEvent(shard, false);
    }

    private void deleteRevPropShard(File revpropShardPath, long shard, long maxFilesPerDirectory) throws SVNException {
        if (shard == 0L) {
            int i = 1;
            while ((long)i < maxFilesPerDirectory) {
                if (this.myCanceller != null) {
                    this.myCanceller.checkCancelled();
                }
                File path = new File(revpropShardPath, String.valueOf(i));
                SVNFileUtil.deleteFile(path);
                ++i;
            }
        } else {
            SVNFileUtil.deleteAll(revpropShardPath, true, this.myCanceller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packRevShard(FSFS fsfs, long shard, File shardPath) throws SVNException {
        File packDir = fsfs.getPackDir(shard);
        File packFile = fsfs.getPackFile(shard);
        File manifestFile = fsfs.getManifestFile(shard);
        this.firePackEvent(shard, true);
        SVNFileUtil.deleteAll(packDir, false, this.myCanceller);
        long startRev = shard * fsfs.getMaxFilesPerDirectory();
        long endRev = (shard + 1L) * fsfs.getMaxFilesPerDirectory() - 1L;
        long nextOffset = 0L;
        OutputStream packFileOS = null;
        OutputStream manifestFileOS = null;
        try {
            packFileOS = SVNFileUtil.openFileForWriting(packFile);
            manifestFileOS = SVNFileUtil.openFileForWriting(manifestFile);
            for (long rev = startRev; rev <= endRev; ++rev) {
                File path = new File(shardPath, String.valueOf(rev));
                String line = String.valueOf(nextOffset) + '\n';
                manifestFileOS.write(line.getBytes("UTF-8"));
                nextOffset += path.length();
                InputStream revIS = null;
                try {
                    revIS = SVNFileUtil.openFileForReading(path);
                    FSRepositoryUtil.copy(revIS, packFileOS, this.myCanceller);
                    continue;
                }
                finally {
                    SVNFileUtil.closeFile(revIS);
                }
            }
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
        }
        finally {
            SVNFileUtil.closeFile(packFileOS);
            SVNFileUtil.closeFile(manifestFileOS);
        }
    }

    private void firePackEvent(long shard, boolean start) throws SVNException {
        if (this.myNotifyHandler != null) {
            SVNAdminEvent event = new SVNAdminEvent(start ? SVNAdminEventAction.PACK_START : SVNAdminEventAction.PACK_END, shard);
            this.myNotifyHandler.handleAdminEvent(event, -1.0);
        }
    }

    private void packRevPropShard(FSFS fsfs, long shard, File shardPath, long maxPackSize) throws SVNException {
        File packPath = new File(fsfs.getRevisionPropertiesRoot(), String.valueOf(shard) + ".pack");
        this.firePackEvent(shard, true);
        long startRev = shard * fsfs.getMaxFilesPerDirectory();
        long endRev = (shard + 1L) * fsfs.getMaxFilesPerDirectory() - 1L;
        if (startRev == 0L) {
            ++startRev;
        }
        long totalSize = 42L;
        boolean packIsEmpty = true;
        String packName = null;
        SVNFSFSPackedRevPropsManifest.Builder manifestBuilder = new SVNFSFSPackedRevPropsManifest.Builder();
        for (long rev = startRev; rev <= endRev; ++rev) {
            File path = new File(shardPath, String.valueOf(rev));
            long size = path.length();
            if (!packIsEmpty && totalSize + 21L + size > maxPackSize) {
                this.copyRevProps(packName, packPath, shardPath, startRev, rev - 1L, fsfs.isCompressPackedRevprops());
                totalSize = 42L;
                startRev = rev;
                packIsEmpty = true;
            }
            if (packIsEmpty) {
                packName = rev + ".0";
            }
            manifestBuilder.addPackName(packName);
            packIsEmpty = false;
            totalSize += 21L + size;
        }
        if (!packIsEmpty) {
            this.copyRevProps(packName, packPath, shardPath, startRev, endRev, fsfs.isCompressPackedRevprops());
        }
        SVNFSFSPackedRevPropsManifest manifest = manifestBuilder.build();
        SVNFileUtil.writeToFile(new File(packPath, "manifest"), manifest.asString(), "UTF-8");
    }

    private void copyRevProps(String packName, File packPath, File shardPath, long startRev, long endRev, boolean compressPackedRevprops) throws SVNException {
        SVNFSFSPackedRevProps.Builder packedRevPropsBuilder = new SVNFSFSPackedRevProps.Builder();
        packedRevPropsBuilder.setFirstRevision(startRev);
        for (long rev = startRev; rev <= endRev; ++rev) {
            File revPropFile = new File(shardPath, String.valueOf(rev));
            byte[] content = SVNFileUtil.readFully(revPropFile);
            packedRevPropsBuilder.addByteArrayEntry(content);
        }
        SVNFSFSPackedRevProps packedRevProps = packedRevPropsBuilder.build();
        File packFile = new File(packPath, packName);
        packedRevProps.writeToFile(packFile, compressPackedRevprops);
    }
}

