/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.svn.sasl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.security.sasl.SaslClient;

public class SaslOutputStream
extends OutputStream {
    private OutputStream myOut;
    private SaslClient myClient;
    private byte[] myLengthBuffer = new byte[4];
    private ByteBuffer myBuffer;

    public SaslOutputStream(SaslClient client, int bufferSize, OutputStream out) {
        this.myOut = out;
        this.myClient = client;
        this.myBuffer = ByteBuffer.allocate(bufferSize);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)(b & 0xFF)});
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int toPut = Math.min(this.myBuffer.remaining(), len);
            this.myBuffer.put(b, off, toPut);
            off += toPut;
            len -= toPut;
            if (this.myBuffer.remaining() != 0) continue;
            this.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.myOut.close();
    }

    @Override
    public void flush() throws IOException {
        byte[] bytes = this.myBuffer.array();
        int off = this.myBuffer.arrayOffset();
        int len = this.myBuffer.position();
        if (len == 0) {
            return;
        }
        byte[] encoded = this.myClient.wrap(bytes, off, len);
        this.myLengthBuffer[0] = (byte)((encoded.length & 0xFF000000) >> 24);
        this.myLengthBuffer[1] = (byte)((encoded.length & 0xFF0000) >> 16);
        this.myLengthBuffer[2] = (byte)((encoded.length & 0xFF00) >> 8);
        this.myLengthBuffer[3] = (byte)(encoded.length & 0xFF);
        this.myOut.write(this.myLengthBuffer, 0, this.myLengthBuffer.length);
        this.myOut.write(encoded, 0, encoded.length);
        this.myOut.flush();
        this.myBuffer.clear();
    }
}

