/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.util.jna;

import afu.com.sun.jna.Pointer;
import afu.com.sun.jna.ptr.IntByReference;
import afu.com.sun.jna.ptr.PointerByReference;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import afu.org.tmatesoft.svn.core.internal.util.jna.ISVNMacOsCFLibrary;
import afu.org.tmatesoft.svn.core.internal.util.jna.ISVNMacOsSecurityLibrary;
import afu.org.tmatesoft.svn.core.internal.util.jna.JNALibraryLoader;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.UnsupportedEncodingException;

class SVNMacOsKeychain {
    private static final int ERR_SEC_ITEM_NOT_FOUND = -25300;

    SVNMacOsKeychain() {
    }

    public static boolean isEnabled() {
        boolean enabled = Boolean.valueOf(System.getProperty("svnkit.library.osxkeychain.enabled", "true"));
        return enabled && SVNFileUtil.isOSX && JNALibraryLoader.getMacOsSecurityLibrary() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean setPassword(String realm, String userName, char[] password, boolean nonInteractive) throws SVNException {
        block16: {
            boolean bl;
            byte[] rawPassword;
            block15: {
                ISVNMacOsSecurityLibrary library = JNALibraryLoader.getMacOsSecurityLibrary();
                if (library == null) {
                    return false;
                }
                if (realm == null) {
                    return false;
                }
                if (nonInteractive) {
                    library.SecKeychainSetUserInteractionAllowed(false);
                }
                rawPassword = null;
                try {
                    byte[] rawRealm = realm.getBytes("UTF-8");
                    byte[] rawUserName = userName == null ? null : userName.getBytes("UTF-8");
                    int rawUserNameLength = userName == null ? 0 : rawUserName.length;
                    rawPassword = SVNEncodingUtil.getBytes(password, "UTF-8");
                    PointerByReference itemHolder = new PointerByReference();
                    int status = library.SecKeychainFindGenericPassword(null, rawRealm.length, rawRealm, rawUserNameLength, rawUserName, null, null, itemHolder);
                    if (status == -25300) {
                        status = library.SecKeychainAddGenericPassword(null, rawRealm.length, rawRealm, rawUserNameLength, rawUserName, rawPassword.length, rawPassword, null);
                    } else {
                        Pointer item = itemHolder.getValue();
                        try {
                            status = library.SecKeychainItemModifyAttributesAndData(item, null, rawPassword.length, rawPassword);
                        }
                        finally {
                            SVNMacOsKeychain.release(item);
                        }
                    }
                    boolean bl2 = bl = status == 0;
                    if (!nonInteractive) break block15;
                    library.SecKeychainSetUserInteractionAllowed(true);
                }
                catch (UnsupportedEncodingException e) {
                    SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                    SVNErrorManager.error(error, e, SVNLogType.DEFAULT);
                    break block16;
                }
                finally {
                    if (nonInteractive) {
                        library.SecKeychainSetUserInteractionAllowed(true);
                    }
                    SVNEncodingUtil.clearArray(rawPassword);
                }
            }
            SVNEncodingUtil.clearArray(rawPassword);
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized char[] getPassword(String realm, String userName, boolean nonInteractive) throws SVNException {
        ISVNMacOsSecurityLibrary library = JNALibraryLoader.getMacOsSecurityLibrary();
        if (library == null) {
            return null;
        }
        if (realm == null) {
            return null;
        }
        if (nonInteractive) {
            library.SecKeychainSetUserInteractionAllowed(false);
        }
        try {
            char[] password;
            byte[] rawRealm = realm.getBytes("UTF-8");
            byte[] rawUserName = userName == null ? null : userName.getBytes("UTF-8");
            int rawUserNameLength = userName == null ? 0 : rawUserName.length;
            IntByReference passwordLengthHolder = new IntByReference();
            PointerByReference passwordHolder = new PointerByReference();
            int status = library.SecKeychainFindGenericPassword(null, rawRealm.length, rawRealm, rawUserNameLength, rawUserName, passwordLengthHolder, passwordHolder, null);
            if (status != 0) {
                char[] cArray = null;
                return cArray;
            }
            Pointer passwordPointer = passwordHolder.getValue();
            if (passwordPointer == null) {
                char[] cArray = null;
                return cArray;
            }
            int passwordLength = passwordLengthHolder.getValue();
            byte[] rawPassword = passwordPointer.getByteArray(0L, passwordLength);
            try {
                password = SVNEncodingUtil.getChars(rawPassword, "UTF-8");
            }
            finally {
                library.SecKeychainItemFreeContent(null, passwordPointer);
                SVNEncodingUtil.clearArray(rawPassword);
            }
            char[] cArray = password;
            return cArray;
        }
        catch (UnsupportedEncodingException e) {
            SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(error, e, SVNLogType.DEFAULT);
            char[] cArray = null;
            return cArray;
        }
        finally {
            if (nonInteractive) {
                library.SecKeychainSetUserInteractionAllowed(true);
            }
        }
    }

    private static void release(Pointer pointer) {
        ISVNMacOsCFLibrary library;
        if (pointer != null && (library = JNALibraryLoader.getMacOsCFLibrary()) != null) {
            library.CFRelease(pointer);
        }
    }
}

