/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc;

import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNNodeKind;
import afu.org.tmatesoft.svn.core.SVNProperties;
import afu.org.tmatesoft.svn.core.SVNPropertyValue;
import afu.org.tmatesoft.svn.core.internal.util.SVNHashMap;
import afu.org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import afu.org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import afu.org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import afu.org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import afu.org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import afu.org.tmatesoft.svn.core.wc.SVNCommitItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class SVNCommitMediator
implements ISVNWorkspaceMediator {
    private Collection myTmpFiles = new ArrayList();
    private Map myWCPropsMap = new SVNHashMap();
    private Map myCommitItems;

    public SVNCommitMediator(Map commitItems) {
        this.myCommitItems = commitItems;
    }

    public SVNProperties getWCProperties(SVNCommitItem item) {
        return (SVNProperties)this.myWCPropsMap.get(item);
    }

    public Collection getTmpFiles() {
        return this.myTmpFiles;
    }

    @Override
    public SVNPropertyValue getWorkspaceProperty(String path, String name) throws SVNException {
        String target;
        SVNAdminArea dir;
        SVNCommitItem item = (SVNCommitItem)this.myCommitItems.get(path);
        if (item == null) {
            return null;
        }
        SVNWCAccess wcAccess = item.getWCAccess();
        if (item.getKind() == SVNNodeKind.DIR) {
            dir = wcAccess.retrieve(item.getFile());
            target = "";
        } else {
            dir = wcAccess.retrieve(item.getFile().getParentFile());
            target = SVNPathUtil.tail(item.getPath());
        }
        SVNVersionedProperties wcProps = dir.getWCProperties(target);
        if (wcProps != null) {
            return wcProps.getPropertyValue(name);
        }
        return null;
    }

    @Override
    public void setWorkspaceProperty(String path, String name, SVNPropertyValue value) throws SVNException {
        if (name == null) {
            return;
        }
        SVNCommitItem item = (SVNCommitItem)this.myCommitItems.get(path);
        if (!this.myWCPropsMap.containsKey(item)) {
            this.myWCPropsMap.put(item, new SVNProperties());
        }
        ((SVNProperties)this.myWCPropsMap.get(item)).put(name, value);
    }
}

