/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc;

import afu.org.tmatesoft.svn.core.internal.wc.SVNConfigFile;
import java.util.Map;

public class SVNCompositeConfigFile {
    private SVNConfigFile myUserFile;
    private SVNConfigFile mySystemFile;
    private Map myGroupsToOptions;

    public SVNCompositeConfigFile(SVNConfigFile systemFile, SVNConfigFile userFile) {
        this.mySystemFile = systemFile;
        this.myUserFile = userFile;
    }

    public Map getProperties(String groupName) {
        Map groupOptions;
        Map system = this.mySystemFile.getProperties(groupName);
        Map user = this.myUserFile.getProperties(groupName);
        system.putAll(user);
        if (this.myGroupsToOptions != null && (groupOptions = (Map)this.myGroupsToOptions.get(groupName)) != null) {
            system.putAll(groupOptions);
        }
        return system;
    }

    public void setGroupsToOptions(Map groupToOptions) {
        this.myGroupsToOptions = groupToOptions;
    }

    public String getPropertyValue(String groupName, String propertyName) {
        Map groupOptions;
        String value = null;
        if (this.myGroupsToOptions != null && (groupOptions = (Map)this.myGroupsToOptions.get(groupName)) != null) {
            value = (String)groupOptions.get(propertyName);
        }
        if (value == null) {
            value = this.myUserFile.getPropertyValue(groupName, propertyName);
        }
        if (value == null) {
            value = this.mySystemFile.getPropertyValue(groupName, propertyName);
        }
        return value;
    }

    public void setPropertyValue(String groupName, String propertyName, String propertyValue, boolean save) {
        this.myUserFile.setPropertyValue(groupName, propertyName, propertyValue, save);
    }

    public boolean isModfied() {
        return this.myUserFile.isModified();
    }

    public void save() {
        this.myUserFile.save();
    }
}

