/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc;

import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;

public class SVNSubstitutor {
    private static final byte[] ALL = new byte[]{36, 13, 10};
    private static final byte[] EOLS = new byte[]{13, 10};
    private static final byte[] KEYWORDS = new byte[]{36};
    private static final int KEYWORD_MAX_LENGTH = 255;
    private boolean myIsRepair;
    private boolean myIsExpand;
    private Map myKeywords;
    private byte[] myEOL;
    private byte[] myLastEOL;
    private byte[] myInteresting;
    private byte[] myEOLBuffer;
    private byte[] myKeywordBuffer;
    private int[] myLastEOLLength = new int[]{0};
    private int myKeywordBufferLength;
    private int myEOLBufferLength;

    public SVNSubstitutor(byte[] eol, boolean repair, Map keywords, boolean expand) {
        this.myEOL = eol;
        this.myKeywords = keywords;
        this.myIsExpand = expand;
        this.myIsRepair = repair;
        this.myInteresting = eol != null && keywords != null ? ALL : (eol != null ? EOLS : KEYWORDS);
        this.myEOLBuffer = new byte[2];
        this.myLastEOL = new byte[2];
        this.myKeywordBuffer = new byte[255];
        this.myEOLBufferLength = 0;
        this.myKeywordBufferLength = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ByteBuffer translateChunk(ByteBuffer src, ByteBuffer dst) throws SVNException {
        if (src == null) {
            if (this.myEOLBufferLength > 0) {
                dst = SVNSubstitutor.substituteEOL(dst, this.myEOL, this.myEOL.length, this.myLastEOL, this.myLastEOLLength, this.myEOLBuffer, this.myEOLBufferLength, this.myIsRepair);
                this.myEOLBufferLength = 0;
            }
            if (this.myKeywordBufferLength <= 0) return dst;
            dst = SVNSubstitutor.write(dst, this.myKeywordBuffer, 0, this.myKeywordBufferLength);
            this.myKeywordBufferLength = 0;
            return dst;
        }
        int nextSignOff = 0;
        block5: while (src.hasRemaining()) {
            byte p;
            block23: {
                p = src.get(src.position());
                if (this.myEOLBufferLength > 0) {
                    if (p == 10) {
                        this.myEOLBuffer[this.myEOLBufferLength++] = src.get();
                    }
                    dst = SVNSubstitutor.substituteEOL(dst, this.myEOL, this.myEOL.length, this.myLastEOL, this.myLastEOLLength, this.myEOLBuffer, this.myEOLBufferLength, this.myIsRepair);
                    this.myEOLBufferLength = 0;
                } else {
                    if (this.myKeywordBufferLength > 0 && p == 36) {
                        this.myKeywordBuffer[this.myKeywordBufferLength++] = src.get();
                        byte[] keywordName = this.matchKeyword(this.myKeywordBuffer, 0, this.myKeywordBufferLength);
                        if (keywordName == null) {
                            --this.myKeywordBufferLength;
                            SVNSubstitutor.unread(src, 1);
                        }
                        int newLength = -1;
                        if (keywordName == null || (newLength = this.translateKeyword(this.myKeywordBuffer, 0, this.myKeywordBufferLength, keywordName)) >= 0 || this.myKeywordBufferLength >= 255) {
                            if (newLength >= 0) {
                                this.myKeywordBufferLength = newLength;
                            }
                            dst = SVNSubstitutor.write(dst, this.myKeywordBuffer, 0, this.myKeywordBufferLength);
                            nextSignOff = 0;
                            this.myKeywordBufferLength = 0;
                            break block23;
                        } else {
                            if (nextSignOff != 0) continue;
                            nextSignOff = this.myKeywordBufferLength - 1;
                            continue;
                        }
                    }
                    if (this.myKeywordBufferLength == 254 || this.myKeywordBufferLength > 0 && (p == 13 || p == 10)) {
                        if (nextSignOff > 0) {
                            SVNSubstitutor.unread(src, this.myKeywordBufferLength - nextSignOff);
                            this.myKeywordBufferLength = nextSignOff;
                            nextSignOff = 0;
                        }
                        dst = SVNSubstitutor.write(dst, this.myKeywordBuffer, 0, this.myKeywordBufferLength);
                        this.myKeywordBufferLength = 0;
                    } else if (this.myKeywordBufferLength > 0) {
                        this.myKeywordBuffer[this.myKeywordBufferLength++] = src.get();
                        continue;
                    }
                }
            }
            int len = 0;
            while (src.position() + len < src.limit() && !this.isInteresting(src.get(src.position() + len))) {
                ++len;
            }
            if (len > 0) {
                dst = SVNSubstitutor.write(dst, src.array(), src.arrayOffset() + src.position(), len);
            }
            src.position(src.position() + len);
            if (!src.hasRemaining()) continue;
            p = src.get();
            switch (p) {
                case 36: {
                    this.myKeywordBuffer[this.myKeywordBufferLength++] = p;
                    break;
                }
                case 13: {
                    this.myEOLBuffer[this.myEOLBufferLength++] = p;
                    break;
                }
                case 10: {
                    this.myEOLBuffer[this.myEOLBufferLength++] = p;
                    dst = SVNSubstitutor.substituteEOL(dst, this.myEOL, this.myEOL.length, this.myLastEOL, this.myLastEOLLength, this.myEOLBuffer, this.myEOLBufferLength, this.myIsRepair);
                    this.myEOLBufferLength = 0;
                    continue block5;
                }
            }
        }
        return dst;
    }

    private boolean isInteresting(byte p) {
        for (int i = 0; i < this.myInteresting.length; ++i) {
            if (p != this.myInteresting[i]) continue;
            return true;
        }
        return false;
    }

    private byte[] matchKeyword(byte[] src, int offset, int length) {
        if (this.myKeywords == null) {
            return null;
        }
        String name = null;
        int len = 0;
        try {
            for (int i = 0; i < length - 2 && src[offset + i + 1] != 58; ++i) {
                ++len;
            }
            if (len == 0) {
                return null;
            }
            name = new String(src, offset + 1, len, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (name != null && this.myKeywords.containsKey(name)) {
            byte[] nameBytes = new byte[len];
            System.arraycopy(src, offset + 1, nameBytes, 0, len);
            return nameBytes;
        }
        return null;
    }

    private int translateKeyword(byte[] src, int offset, int length, byte[] name) {
        String nameStr;
        if (this.myKeywords == null) {
            return -1;
        }
        try {
            nameStr = new String(name, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            return -1;
        }
        byte[] value = (byte[])this.myKeywords.get(nameStr);
        if (this.myKeywords.containsKey(nameStr)) {
            if (!this.myIsExpand) {
                value = null;
            }
            return SVNSubstitutor.substituteKeyword(src, offset, length, name, value);
        }
        return -1;
    }

    private static void unread(ByteBuffer buffer, int length) {
        buffer.position(buffer.position() - length);
    }

    private static int substituteKeyword(byte[] src, int offset, int length, byte[] keyword, byte[] value) {
        int valueLength;
        if (length < keyword.length + 2) {
            return -1;
        }
        for (int i = 0; i < keyword.length; ++i) {
            if (keyword[i] == src[offset + 1 + i]) continue;
            return -1;
        }
        int pointer = offset + 1 + keyword.length;
        if (src[pointer] == 58 && src[pointer + 1] == 58 && src[pointer + 2] == 32 && (src[offset + length - 2] == 32 || src[offset + length - 2] == 35) && 6 + keyword.length < length) {
            if (value == null) {
                pointer += 2;
                while (src[pointer] != 36) {
                    src[pointer++] = 32;
                }
            } else {
                int maxValueLength = length - (6 + keyword.length);
                if (value.length <= maxValueLength) {
                    System.arraycopy(value, 0, src, pointer + 3, value.length);
                    pointer += 3 + value.length;
                    while (src[pointer] != 36) {
                        src[pointer++] = 32;
                    }
                } else {
                    System.arraycopy(value, 0, src, pointer + 3, maxValueLength);
                    src[offset + length - 2] = 35;
                    src[offset + length - 1] = 36;
                }
            }
            return length;
        }
        if (src[pointer] == 36 || src[pointer] == 58 && src[pointer + 1] == 36) {
            if (value != null) {
                src[pointer] = 58;
                src[pointer + 1] = 32;
                if (value.length > 0) {
                    valueLength = value.length;
                    if (valueLength > 250 - keyword.length) {
                        valueLength = 250 - keyword.length;
                    }
                    System.arraycopy(value, 0, src, pointer + 2, valueLength);
                    src[pointer + 2 + valueLength] = 32;
                    src[pointer + 3 + valueLength] = 36;
                    length = 5 + keyword.length + valueLength;
                } else {
                    src[pointer + 2] = 36;
                    length = 4 + keyword.length;
                }
            }
            return length;
        }
        if (length >= keyword.length + 4 && src[pointer] == 58 && src[pointer + 1] == 32 && src[offset + length - 2] == 32) {
            if (value == null) {
                src[pointer] = 36;
                length = 2 + keyword.length;
            } else {
                src[pointer] = 58;
                src[pointer + 1] = 32;
                if (value.length > 0) {
                    valueLength = value.length;
                    if (valueLength > 250 - keyword.length) {
                        valueLength = 250 - keyword.length;
                    }
                    System.arraycopy(value, 0, src, pointer + 2, valueLength);
                    src[pointer + 2 + valueLength] = 32;
                    src[pointer + 3 + valueLength] = 36;
                    length = 5 + keyword.length + valueLength;
                } else {
                    src[pointer + 2] = 36;
                    length = 4 + keyword.length;
                }
            }
            return length;
        }
        return -1;
    }

    private static ByteBuffer substituteEOL(ByteBuffer dst, byte[] eol, int eolLength, byte[] lastEOL, int[] lastEOLLength, byte[] nextEOL, int nextEOLLength, boolean repair) throws SVNException {
        if (lastEOLLength[0] > 0) {
            if (!(repair || lastEOLLength[0] == nextEOLLength && Arrays.equals(lastEOL, nextEOL))) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_INCONSISTENT_EOL);
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
        } else {
            lastEOLLength[0] = nextEOLLength;
            lastEOL[0] = nextEOL[0];
            lastEOL[1] = nextEOL[1];
        }
        return SVNSubstitutor.write(dst, eol, 0, eolLength);
    }

    private static ByteBuffer write(ByteBuffer dst, byte[] bytes, int offset, int length) {
        if (dst.remaining() < length) {
            ByteBuffer newDst = ByteBuffer.allocate((dst.position() + length) * 3 / 2);
            dst.flip();
            dst = newDst.put(dst);
        }
        return dst.put(bytes, offset, length);
    }
}

