/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc;

import afu.org.tmatesoft.svn.core.ISVNLogEntryHandler;
import afu.org.tmatesoft.svn.core.SVNCommitInfo;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNLogEntry;
import afu.org.tmatesoft.svn.core.SVNProperties;
import afu.org.tmatesoft.svn.core.SVNProperty;
import afu.org.tmatesoft.svn.core.SVNPropertyValue;
import afu.org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import afu.org.tmatesoft.svn.core.io.ISVNEditor;
import afu.org.tmatesoft.svn.core.io.SVNRepository;
import afu.org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import afu.org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import java.io.OutputStream;

public class SVNSynchronizeEditor
implements ISVNEditor {
    private ISVNEditor myWrappedEditor;
    private boolean myIsRootOpened;
    private long myBaseRevision;
    private SVNCommitInfo myCommitInfo;
    private ISVNLogEntryHandler myHandler;
    private SVNRepository myTargetRepository;
    private int myNormalizedNodePropsCounter;
    private SVNProperties myRevisionProperties;

    public SVNSynchronizeEditor(SVNRepository toRepository, ISVNLogEntryHandler handler, long baseRevision, SVNProperties revProps) {
        this.myTargetRepository = toRepository;
        this.myIsRootOpened = false;
        this.myBaseRevision = baseRevision;
        this.myHandler = handler;
        this.myNormalizedNodePropsCounter = 0;
        this.myRevisionProperties = revProps;
    }

    public void reset(long baseRevision, SVNProperties revProps) {
        this.myWrappedEditor = null;
        this.myCommitInfo = null;
        this.myIsRootOpened = false;
        this.myBaseRevision = baseRevision;
        this.myNormalizedNodePropsCounter = 0;
        this.myRevisionProperties = revProps;
    }

    @Override
    public void abortEdit() throws SVNException {
        this.getWrappedEditor().abortEdit();
    }

    private ISVNEditor getWrappedEditor() throws SVNException {
        if (this.myWrappedEditor == null) {
            this.myWrappedEditor = this.myTargetRepository.getCommitEditor(null, null, false, this.myRevisionProperties, null);
        }
        return this.myWrappedEditor;
    }

    @Override
    public void absentDir(String path) throws SVNException {
        this.getWrappedEditor().absentDir(path);
    }

    @Override
    public void absentFile(String path) throws SVNException {
        this.getWrappedEditor().absentFile(path);
    }

    @Override
    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.getWrappedEditor().addDir(path, copyFromPath, copyFromRevision);
    }

    @Override
    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.getWrappedEditor().addFile(path, copyFromPath, copyFromRevision);
    }

    @Override
    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (SVNProperty.isRegularProperty(name)) {
            String normalizedValue;
            if (SVNPropertiesManager.propNeedsTranslation(name) && (normalizedValue = SVNAdminClient.normalizeString(SVNPropertyValue.getPropertyAsString(value))) != null) {
                value = SVNPropertyValue.create(normalizedValue);
                ++this.myNormalizedNodePropsCounter;
            }
            this.getWrappedEditor().changeDirProperty(name, value);
        }
    }

    @Override
    public void changeFileProperty(String path, String name, SVNPropertyValue value) throws SVNException {
        if (SVNProperty.isRegularProperty(name)) {
            String normalizedVal;
            if (SVNPropertiesManager.propNeedsTranslation(name) && (normalizedVal = SVNAdminClient.normalizeString(SVNPropertyValue.getPropertyAsString(value))) != null) {
                value = SVNPropertyValue.create(normalizedVal);
                ++this.myNormalizedNodePropsCounter;
            }
            this.getWrappedEditor().changeFileProperty(path, name, value);
        }
    }

    @Override
    public void closeDir() throws SVNException {
        this.getWrappedEditor().closeDir();
    }

    @Override
    public SVNCommitInfo closeEdit() throws SVNException {
        ISVNEditor wrappedEditor = this.getWrappedEditor();
        if (!this.myIsRootOpened) {
            wrappedEditor.openRoot(this.myBaseRevision);
        }
        this.myCommitInfo = wrappedEditor.closeEdit();
        if (this.myHandler != null) {
            SVNLogEntry logEntry = new SVNLogEntry(null, this.myCommitInfo.getNewRevision(), this.myCommitInfo.getAuthor(), this.myCommitInfo.getDate(), null);
            this.myHandler.handleLogEntry(logEntry);
        }
        return this.myCommitInfo;
    }

    @Override
    public void closeFile(String path, String textChecksum) throws SVNException {
        this.getWrappedEditor().closeFile(path, textChecksum);
    }

    @Override
    public void deleteEntry(String path, long revision) throws SVNException {
        this.getWrappedEditor().deleteEntry(path, revision);
    }

    @Override
    public void openDir(String path, long revision) throws SVNException {
        this.getWrappedEditor().openDir(path, revision);
    }

    @Override
    public void openFile(String path, long revision) throws SVNException {
        this.getWrappedEditor().openFile(path, revision);
    }

    @Override
    public void openRoot(long revision) throws SVNException {
        this.getWrappedEditor().openRoot(revision);
        this.myIsRootOpened = true;
    }

    @Override
    public void targetRevision(long revision) throws SVNException {
        this.getWrappedEditor().targetRevision(revision);
    }

    @Override
    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        this.getWrappedEditor().applyTextDelta(path, baseChecksum);
    }

    @Override
    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        return this.getWrappedEditor().textDeltaChunk(path, diffWindow);
    }

    @Override
    public void textDeltaEnd(String path) throws SVNException {
        this.getWrappedEditor().textDeltaEnd(path);
    }

    public SVNCommitInfo getCommitInfo() {
        return this.myCommitInfo;
    }

    public int getNormalizedNodePropsCounter() {
        return this.myNormalizedNodePropsCounter;
    }
}

