/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc.admin;

import afu.org.tmatesoft.svn.core.SVNDepth;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNNodeKind;
import afu.org.tmatesoft.svn.core.SVNProperty;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.internal.util.SVNDate;
import afu.org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import afu.org.tmatesoft.svn.core.internal.util.SVNHashMap;
import afu.org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import afu.org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import afu.org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea14;
import afu.org.tmatesoft.svn.core.wc.SVNRevision;
import afu.org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import java.io.File;
import java.util.Arrays;
import java.util.Map;

public abstract class SVNEntry {
    private String myName;
    private String author;
    private String[] cachableProperties;
    private String changelistName;
    private String checksum;
    private SVNDate committedDate;
    private long committedRevision;
    private String conflictNew;
    private String conflictOld;
    private String conflictWorking;
    private long copyFromRevision;
    private String copyFromURL;
    private SVNDepth depth;
    private String externalFilePath;
    private SVNRevision externalFilePegRevision;
    private SVNRevision externalFileRevision;
    private SVNNodeKind kind;
    private String lockComment;
    private SVNDate lockCreationDate;
    private String lockOwner;
    private String lockToken;
    private String[] presentProperties;
    private String propRejectFile;
    private SVNDate propTime;
    private String repositoryRoot;
    private long revision;
    private String schedule;
    private SVNDate textTime;
    private String treeConflictData;
    private String url;
    private String uuid;
    private long workingSize;
    private boolean absent;
    private boolean copied;
    private boolean deleted;
    private boolean incomplete;
    private boolean keepLocal;
    private boolean hasProperties;
    private boolean hasPropertiesModifications;
    private String parentURL;

    public abstract boolean isThisDir();

    public abstract SVNAdminArea getAdminArea();

    public String getURL() {
        if (this.url == null && this.parentURL != null) {
            return SVNPathUtil.append(this.parentURL, SVNEncodingUtil.uriEncode(this.myName));
        }
        return this.url;
    }

    public SVNURL getSVNURL() throws SVNException {
        String url = this.getURL();
        if (url != null) {
            return SVNURL.parseURIEncoded(url);
        }
        return null;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isDirectory() {
        return this.kind == SVNNodeKind.DIR;
    }

    public long getRevision() {
        return this.revision;
    }

    public boolean isScheduledForAddition() {
        return "add".equals(this.schedule);
    }

    public boolean isScheduledForDeletion() {
        return "delete".equals(this.schedule);
    }

    public boolean isScheduledForReplacement() {
        return "replace".equals(this.schedule);
    }

    public boolean isHidden() {
        return this.isDeleted() && !this.isScheduledForAddition() && !this.isScheduledForReplacement() || this.isAbsent() || this.getDepth() == SVNDepth.EXCLUDE;
    }

    public boolean isFile() {
        return this.kind == SVNNodeKind.FILE;
    }

    public String getLockToken() {
        return this.lockToken;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isAbsent() {
        return this.absent;
    }

    public String toString() {
        return this.myName;
    }

    public boolean setRevision(long revision) {
        boolean changed = revision != this.revision;
        this.revision = revision;
        return changed;
    }

    public boolean setCommittedRevision(long cmtRevision) {
        boolean changed = cmtRevision != this.committedRevision;
        this.committedRevision = cmtRevision;
        return changed;
    }

    public boolean setAuthor(String cmtAuthor) {
        boolean changed = cmtAuthor != null ? !cmtAuthor.equals(this.author) : cmtAuthor != this.author;
        this.author = cmtAuthor;
        return changed;
    }

    public boolean setChangelistName(String changelistName) {
        boolean changed = changelistName != null ? !changelistName.equals(this.changelistName) : changelistName != this.changelistName;
        this.changelistName = changelistName;
        return changed;
    }

    public String getChangelistName() {
        return this.changelistName;
    }

    public boolean setWorkingSize(long size) {
        boolean changed = this.workingSize != size;
        this.workingSize = size;
        return changed;
    }

    public long getWorkingSize() {
        return this.workingSize;
    }

    public SVNDepth getDepth() {
        return this.depth;
    }

    public void setDepth(SVNDepth depth) {
        if (depth == null) {
            depth = SVNDepth.INFINITY;
        }
        this.depth = depth;
    }

    public boolean setURL(String url) {
        boolean changed = url != null ? !url.equals(this.url) : url != this.url;
        this.url = url;
        return changed;
    }

    public void setIncomplete(boolean incomplete) {
        this.incomplete = incomplete;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public String getConflictOld() {
        return this.conflictOld;
    }

    public void setConflictOld(String name) {
        this.conflictOld = name;
    }

    public String getConflictNew() {
        return this.conflictNew;
    }

    public void setConflictNew(String name) {
        this.conflictNew = name;
    }

    public String getConflictWorking() {
        return this.conflictWorking;
    }

    public void setConflictWorking(String name) {
        this.conflictWorking = name;
    }

    public String getPropRejectFile() {
        return this.propRejectFile;
    }

    public void setPropRejectFile(String name) {
        this.propRejectFile = name;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setCommittedDate(String date) {
        this.committedDate = date != null ? SVNDate.parseDate(date) : null;
    }

    public String getCommittedDate() {
        return this.committedDate != null ? this.committedDate.format() : null;
    }

    public long getCommittedRevision() {
        return this.committedRevision;
    }

    public void setTextTime(String time) {
        this.textTime = time != null ? SVNDate.parseDate(time) : null;
    }

    public void setKind(SVNNodeKind kind) {
        this.kind = kind;
    }

    public void setAbsent(boolean absent) {
        this.absent = absent;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public SVNNodeKind getKind() {
        return this.kind;
    }

    public String getTextTime() {
        return this.textTime != null ? this.textTime.format() : null;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public void setLockComment(String comment) {
        this.lockComment = comment;
    }

    public void setLockOwner(String owner) {
        this.lockOwner = owner;
    }

    public void setLockCreationDate(String date) {
        this.lockCreationDate = date != null ? SVNDate.parseDate(date) : null;
    }

    public void setLockToken(String token) {
        this.lockToken = token;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public void unschedule() {
        this.schedule = null;
    }

    public void scheduleForAddition() {
        this.schedule = "add";
    }

    public void scheduleForDeletion() {
        this.schedule = "delete";
    }

    public void scheduleForReplacement() {
        this.schedule = "replace";
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public void setCopyFromRevision(long revision) {
        this.copyFromRevision = revision;
    }

    public boolean setCopyFromURL(String url) {
        boolean changed = url != null ? !url.equals(this.copyFromURL) : url != this.copyFromURL;
        this.copyFromURL = url;
        return changed;
    }

    public void setCopied(boolean copied) {
        this.copied = copied;
    }

    public String getCopyFromURL() {
        return this.copyFromURL;
    }

    public SVNURL getCopyFromSVNURL() throws SVNException {
        String url = this.getCopyFromURL();
        if (url != null) {
            return SVNURL.parseURIEncoded(url);
        }
        return null;
    }

    public long getCopyFromRevision() {
        return this.copyFromRevision;
    }

    public String getPropTime() {
        return this.propTime != null ? this.propTime.format() : null;
    }

    public void setPropTime(String time) {
        this.propTime = time != null ? SVNDate.parseDate(time) : null;
    }

    public boolean isCopied() {
        return this.copied;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public SVNURL getRepositoryRootURL() throws SVNException {
        String url = this.getRepositoryRoot();
        if (url != null) {
            return SVNURL.parseURIEncoded(url);
        }
        return null;
    }

    public boolean setRepositoryRoot(String url) {
        boolean changed = url != null ? !url.equals(this.repositoryRoot) : url != this.repositoryRoot;
        this.repositoryRoot = url;
        return changed;
    }

    public boolean setRepositoryRootURL(SVNURL url) {
        return this.setRepositoryRoot(url == null ? null : url.toString());
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public String getLockComment() {
        return this.lockComment;
    }

    public String getLockCreationDate() {
        return this.lockCreationDate != null ? this.lockCreationDate.format() : null;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public void setCachableProperties(String[] cachableProps) {
        this.cachableProperties = cachableProps;
    }

    public void setPresentProperties(String[] properties) {
        this.presentProperties = properties;
    }

    public void setKeepLocal(boolean keepLocal) {
        this.keepLocal = keepLocal;
    }

    public boolean isKeepLocal() {
        return this.keepLocal;
    }

    public String[] getCachableProperties() {
        return this.cachableProperties;
    }

    public String[] getPresentProperties() {
        return this.presentProperties;
    }

    public String getExternalFilePath() {
        return this.externalFilePath;
    }

    public SVNRevision getExternalFileRevision() {
        return this.externalFileRevision;
    }

    public SVNRevision getExternalFilePegRevision() {
        return this.externalFilePegRevision;
    }

    public void setExternalFilePath(String path) {
        this.externalFilePath = path;
    }

    public void setExternalFileRevision(SVNRevision rev) {
        this.externalFileRevision = rev;
    }

    public void setExternalFilePegRevision(SVNRevision pegRev) {
        this.externalFilePegRevision = pegRev;
    }

    public String getTreeConflictData() {
        return this.treeConflictData;
    }

    public abstract Map<File, SVNTreeConflictDescription> getTreeConflicts() throws SVNException;

    public void setTreeConflictData(String conflictData) {
        this.treeConflictData = conflictData;
    }

    public void setTreeConflicts(Map treeConflicts) throws SVNException {
        String conflictData = SVNTreeConflictUtil.getTreeConflictData(treeConflicts);
        this.setTreeConflictData(conflictData);
    }

    public void setHasProperties(boolean hasProps) {
        this.hasProperties = hasProps;
    }

    public void setHasPropertiesModifications(boolean hasPropsMods) {
        this.hasPropertiesModifications = hasPropsMods;
    }

    public boolean hasPropertiesModifications() {
        return this.hasPropertiesModifications;
    }

    public boolean hasProperties() {
        return this.hasProperties;
    }

    public void setParentURL(String url) {
        this.parentURL = url;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public void applyChanges(Map attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        for (String name : attributes.keySet()) {
            this.setAttribute(name, attributes.get(name));
        }
    }

    private void setAttribute(String name, Object value) {
        if ("svn:entry:absent".equals(name)) {
            this.setAbsent(SVNProperty.booleanValue((String)value));
        } else if ("svn:entry:cachable-props".equals(name)) {
            if (value instanceof String) {
                value = SVNAdminArea.fromString((String)value, " ");
            }
            if (Arrays.equals(value, SVNAdminArea14.getCachableProperties())) {
                value = SVNAdminArea14.getCachableProperties();
            }
            this.setCachableProperties(value);
        } else if ("svn:entry:changelist".equals(name)) {
            this.setChangelistName((String)value);
        } else if ("svn:entry:checksum".equals(name)) {
            this.setChecksum((String)value);
        } else if ("svn:entry:committed-date".equals(name)) {
            this.setCommittedDate((String)value);
        } else if ("svn:entry:committed-rev".equals(name)) {
            this.setCommittedRevision(SVNProperty.longValue((String)value));
        } else if ("svn:entry:conflict-new".equals(name)) {
            this.setConflictNew((String)value);
        } else if ("svn:entry:conflict-old".equals(name)) {
            this.setConflictOld((String)value);
        } else if ("svn:entry:conflict-wrk".equals(name)) {
            this.setConflictWorking((String)value);
        } else if ("svn:entry:copied".equals(name)) {
            this.setCopied(SVNProperty.booleanValue((String)value));
        } else if ("svn:entry:copyfrom-rev".equals(name)) {
            this.setCopyFromRevision(SVNProperty.longValue((String)value));
        } else if ("svn:entry:copyfrom-url".equals(name)) {
            this.setCopyFromURL((String)value);
        } else if ("svn:entry:deleted".equals(name)) {
            this.setDeleted(SVNProperty.booleanValue((String)value));
        } else if ("svn:entry:depth".equals(name)) {
            SVNDepth depth = null;
            if (value instanceof String) {
                depth = SVNDepth.fromString((String)value);
            }
            if (depth == null) {
                depth = SVNDepth.INFINITY;
            }
            this.setDepth(depth);
        } else if ("svn:entry:file-external-path".equals(name)) {
            this.setExternalFilePath((String)value);
        } else if ("svn:entry:file-external-peg-revision".equals(name)) {
            this.setExternalFilePegRevision((SVNRevision)value);
        } else if ("svn:entry:file-external-revision".equals(name)) {
            this.setExternalFileRevision((SVNRevision)value);
        } else if ("svn:entry:has-prop-mods".equals(name)) {
            this.setHasPropertiesModifications(SVNProperty.booleanValue((String)value));
        } else if ("svn:entry:has-props".equals(name)) {
            this.setHasProperties(SVNProperty.booleanValue((String)value));
        } else if ("svn:entry:incomplete".equals(name)) {
            this.setIncomplete(SVNProperty.booleanValue((String)value));
        } else if ("svn:entry:keep-local".equals(name)) {
            this.setKeepLocal(SVNProperty.booleanValue((String)value));
        } else if ("svn:entry:kind".equals(name)) {
            SVNNodeKind kind = null;
            if (value instanceof String) {
                kind = SVNNodeKind.parseKind((String)value);
            }
            this.setKind(kind);
        } else if ("svn:entry:last-author".equals(name)) {
            this.setAuthor((String)value);
        } else if ("svn:entry:lock-comment".equals(name)) {
            this.setLockComment((String)value);
        } else if ("svn:entry:lock-creation-date".equals(name)) {
            this.setLockCreationDate((String)value);
        } else if ("svn:entry:lock-owner".equals(name)) {
            this.setLockOwner((String)value);
        } else if ("svn:entry:lock-token".equals(name)) {
            this.setLockToken((String)value);
        } else if ("svn:entry:name".equals(name)) {
            this.myName = (String)value;
        } else if ("svn:entry:present-props".equals(name)) {
            if (value instanceof String) {
                value = SVNAdminArea.fromString((String)value, " ");
            }
            this.setPresentProperties(value);
        } else if ("svn:entry:prop-reject-file".equals(name)) {
            this.setPropRejectFile((String)value);
        } else if ("svn:entry:prop-time".equals(name)) {
            this.setPropTime((String)value);
        } else if ("svn:entry:repos".equals(name)) {
            this.setRepositoryRoot((String)value);
        } else if ("svn:entry:revision".equals(name)) {
            this.setRevision(SVNProperty.longValue((String)value));
        } else if ("svn:entry:schedule".equals(name)) {
            this.setSchedule((String)value);
        } else if ("svn:entry:text-time".equals(name)) {
            this.setTextTime((String)value);
        } else if ("svn:entry:tree-conflicts".equals(name)) {
            this.setTreeConflictData((String)value);
        } else if ("svn:entry:url".equals(name)) {
            this.setURL((String)value);
        } else if ("svn:entry:uuid".equals(name)) {
            this.setUUID((String)value);
        } else if ("svn:entry:working-size".equals(name)) {
            this.setWorkingSize(SVNProperty.longValue((String)value));
        }
    }

    public Map asMap() {
        SVNHashMap map = new SVNHashMap();
        if (this.isAbsent()) {
            map.put("svn:entry:absent", Boolean.TRUE.toString());
        }
        if (this.getCachableProperties() != null) {
            map.put("svn:entry:cachable-props", this.getCachableProperties());
        }
        if (this.getChangelistName() != null) {
            map.put("svn:entry:changelist", this.getChangelistName());
        }
        if (this.getChecksum() != null) {
            map.put("svn:entry:checksum", this.getChecksum());
        }
        if (this.getCommittedDate() != null) {
            map.put("svn:entry:committed-date", this.getCommittedDate());
        }
        if (this.getCommittedRevision() >= 0L) {
            map.put("svn:entry:committed-rev", Long.toString(this.getCommittedRevision()));
        }
        if (this.getConflictNew() != null) {
            map.put("svn:entry:conflict-new", this.getConflictNew());
        }
        if (this.getConflictOld() != null) {
            map.put("svn:entry:conflict-old", this.getConflictOld());
        }
        if (this.getConflictWorking() != null) {
            map.put("svn:entry:conflict-wrk", this.getConflictWorking());
        }
        if (this.isCopied()) {
            map.put("svn:entry:copied", Boolean.TRUE.toString());
        }
        if (this.getCopyFromRevision() >= 0L) {
            map.put("svn:entry:copyfrom-rev", Long.toString(this.getCopyFromRevision()));
        }
        if (this.getCopyFromURL() != null) {
            map.put("svn:entry:copyfrom-url", this.getCopyFromURL());
        }
        if (this.isDeleted()) {
            map.put("svn:entry:deleted", Boolean.TRUE.toString());
        }
        if (this.getDepth() != null) {
            map.put("svn:entry:depth", this.getDepth().toString());
        }
        if (this.getExternalFilePath() != null) {
            map.put("svn:entry:file-external-path", this.getExternalFilePath());
        }
        if (this.getExternalFileRevision() != null) {
            map.put("svn:entry:file-external-revision", this.getExternalFileRevision());
        }
        if (this.getExternalFilePegRevision() != null) {
            map.put("svn:entry:file-external-peg-revision", this.getExternalFilePegRevision());
        }
        if (this.hasProperties()) {
            map.put("svn:entry:has-props", Boolean.TRUE.toString());
        }
        if (this.hasPropertiesModifications()) {
            map.put("svn:entry:has-prop-mods", Boolean.TRUE.toString());
        }
        if (this.isIncomplete()) {
            map.put("svn:entry:incomplete", Boolean.TRUE.toString());
        }
        if (this.isKeepLocal()) {
            map.put("svn:entry:keep-local", Boolean.TRUE.toString());
        }
        if (this.getKind() != null) {
            map.put("svn:entry:kind", this.getKind().toString());
        }
        if (this.getAuthor() != null) {
            map.put("svn:entry:last-author", this.getAuthor());
        }
        if (this.getLockComment() != null) {
            map.put("svn:entry:lock-comment", this.getLockComment());
        }
        if (this.getLockCreationDate() != null) {
            map.put("svn:entry:lock-creation-date", this.getLockCreationDate());
        }
        if (this.getLockOwner() != null) {
            map.put("svn:entry:lock-owner", this.getLockOwner());
        }
        if (this.getLockToken() != null) {
            map.put("svn:entry:lock-token", this.getLockToken());
        }
        if (this.getName() != null) {
            map.put("svn:entry:name", this.getName());
        }
        if (this.getPresentProperties() != null) {
            map.put("svn:entry:present-props", this.getPresentProperties());
        }
        if (this.getPropRejectFile() != null) {
            map.put("svn:entry:prop-reject-file", this.getPropRejectFile());
        }
        if (this.getPropTime() != null) {
            map.put("svn:entry:prop-time", this.getPropTime());
        }
        if (this.getRepositoryRoot() != null) {
            map.put("svn:entry:repos", this.getRepositoryRoot());
        }
        if (this.getRevision() >= 0L) {
            map.put("svn:entry:revision", Long.toString(this.getRevision()));
        }
        if (this.getSchedule() != null) {
            map.put("svn:entry:schedule", this.getSchedule());
        }
        if (this.getTextTime() != null) {
            map.put("svn:entry:text-time", this.getTextTime());
        }
        if (this.getTreeConflictData() != null) {
            map.put("svn:entry:tree-conflicts", this.getTreeConflictData());
        }
        if (this.getURL() != null) {
            map.put("svn:entry:url", this.getURL());
        }
        if (this.getUUID() != null) {
            map.put("svn:entry:uuid", this.getUUID());
        }
        if (this.getWorkingSize() >= 0L) {
            map.put("svn:entry:working-size", Long.toString(this.getWorkingSize()));
        }
        return map;
    }
}

