/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc17.db;

import afu.org.tmatesoft.sqljet.core.SqlJetException;
import afu.org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import afu.org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import afu.org.tmatesoft.sqljet.core.table.ISqlJetTable;
import afu.org.tmatesoft.svn.core.SVNDepth;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNProperties;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import afu.org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.core.internal.wc16.SVNUpdateClient16;
import afu.org.tmatesoft.svn.core.internal.wc17.SVNExternalsStore;
import afu.org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import afu.org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import afu.org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import afu.org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbDir;
import afu.org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import afu.org.tmatesoft.svn.core.internal.wc17.db.Structure;
import afu.org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import afu.org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbProperties;
import afu.org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import afu.org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbCollectTargets;
import afu.org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import afu.org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import afu.org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import afu.org.tmatesoft.svn.core.wc2.SvnTarget;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class SvnWcDbShared {
    public static final byte[] EMPTY_PROPS_BLOB = new byte[]{40, 41};

    public static void begingReadTransaction(SVNWCDbRoot root) throws SVNException {
        root.getSDb().beginTransaction(SqlJetTransactionMode.READ_ONLY);
    }

    public static void begingWriteTransaction(SVNWCDbRoot root) throws SVNException {
        root.getSDb().beginTransaction(SqlJetTransactionMode.WRITE);
    }

    public static void commitTransaction(SVNWCDbRoot root) throws SVNException {
        root.getSDb().commit();
    }

    public static void rollbackTransaction(SVNWCDbRoot root) throws SVNException {
        root.getSDb().rollback();
    }

    protected static void nodeNotFound(File absolutePath) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)absolutePath);
        SVNErrorManager.error(err, SVNLogType.WC);
    }

    protected static void nodeIsNotInstallable(File absolutePath) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' is not installable.", (Object)absolutePath);
        SVNErrorManager.error(err, SVNLogType.WC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean doesNodeExists(SVNWCDbRoot wcDbRoot, File relpath) throws SVNException {
        SVNSqlJetStatement stmt = null;
        try {
            stmt = wcDbRoot.getSDb().getStatement(SVNWCDbStatements.DOES_NODE_EXIST);
            stmt.bindf("is", wcDbRoot.getWcId(), relpath);
            boolean bl = stmt.next();
            return bl;
        }
        finally {
            if (stmt != null) {
                stmt.reset();
            }
        }
    }

    protected static void nodeNotFound(SVNWCDbRoot root, File relPath) throws SVNException {
        SvnWcDbShared.nodeNotFound(root.getAbsPath(relPath));
    }

    protected static void sqliteError(SqlJetException e) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
        SVNErrorManager.error(err, SVNLogType.WC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Collection<Target> collectTargets(SVNWCDbRoot root, File relpath, SVNDepth depth, Collection<String> changelists) throws SVNException {
        SVNWCDbCollectTargets stmt = null;
        ArrayList<Target> targets = new ArrayList<Target>();
        try {
            String path;
            long wcId;
            stmt = new SVNWCDbCollectTargets(root.getSDb(), root.getWcId(), relpath, depth, changelists);
            while (((SVNSqlJetStatement)stmt).next()) {
                wcId = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.wc_id);
                path = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.local_relpath);
                targets.add(new Target(wcId, path));
            }
            if (depth == SVNDepth.FILES || depth == SVNDepth.IMMEDIATES) {
                SvnWcDbStatementUtil.reset(stmt);
                stmt = new SVNWCDbCollectTargets(root.getSDb(), root.getWcId(), relpath, SVNDepth.EMPTY, changelists);
                while (((SVNSqlJetStatement)stmt).next()) {
                    wcId = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.wc_id);
                    path = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.local_relpath);
                    targets.add(new Target(wcId, path));
                }
            }
        }
        catch (Throwable throwable) {
            SvnWcDbStatementUtil.reset(stmt);
            throw throwable;
        }
        SvnWcDbStatementUtil.reset(stmt);
        return targets;
    }

    public static Structure<StructureFields.AdditionInfo> scanAddition(SVNWCDb db, File localAbsPath) throws SVNException {
        SVNWCDb.ReposInfo reposInfo;
        SVNWCDb.DirParsedInfo parsed = db.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelpath = parsed.localRelPath;
        Structure<StructureFields.AdditionInfo> additionInfo = SvnWcDbShared.scanAddition(pdh.getWCRoot(), localRelpath, new StructureFields.AdditionInfo[0]);
        if (additionInfo.hasField(StructureFields.AdditionInfo.reposRootUrl)) {
            reposInfo = db.fetchReposInfo(pdh.getWCRoot().getSDb(), additionInfo.lng(StructureFields.AdditionInfo.reposId));
            additionInfo.set(StructureFields.AdditionInfo.reposRootUrl, SVNURL.parseURIEncoded(reposInfo.reposRootUrl));
            additionInfo.set(StructureFields.AdditionInfo.reposUuid, reposInfo.reposUuid);
        }
        if (additionInfo.hasField(StructureFields.AdditionInfo.originalRootUrl) && additionInfo.lng(StructureFields.AdditionInfo.originalReposId) >= 0L) {
            reposInfo = db.fetchReposInfo(pdh.getWCRoot().getSDb(), additionInfo.lng(StructureFields.AdditionInfo.originalReposId));
            additionInfo.set(StructureFields.AdditionInfo.originalRootUrl, SVNURL.parseURIEncoded(reposInfo.reposRootUrl));
            additionInfo.set(StructureFields.AdditionInfo.originalUuid, reposInfo.reposUuid);
        }
        return additionInfo;
    }

    public static Structure<StructureFields.MovedInfo> scanMoved(SVNWCDb db, File localAbsPath) throws SVNException {
        Object result = Structure.obtain(StructureFields.MovedInfo.class);
        SVNWCDb.DirParsedInfo parsed = db.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelpath = parsed.localRelPath;
        SVNWCDbRoot root = pdh.getWCRoot();
        Structure<StructureFields.AdditionInfo> additionInfo = SvnWcDbShared.scanAddition(pdh.getWCRoot(), localRelpath, StructureFields.AdditionInfo.values());
        if (additionInfo.get(StructureFields.AdditionInfo.status) != ISVNWCDb.SVNWCDbStatus.MovedHere || additionInfo.get(StructureFields.AdditionInfo.movedFromRelPath) == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Path ''{0}'' was not moved here", (Object)localAbsPath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        ((Structure)result).set((StructureFields.MovedInfo)StructureFields.MovedInfo.opRootAbsPath, additionInfo.get(StructureFields.AdditionInfo.opRootAbsPath));
        ((Structure)result).set((StructureFields.MovedInfo)StructureFields.MovedInfo.movedFromAbsPath, root.getAbsPath((File)additionInfo.get(StructureFields.AdditionInfo.movedFromRelPath)));
        ((Structure)result).set((StructureFields.MovedInfo)StructureFields.MovedInfo.movedFromOpRootAbsPath, root.getAbsPath((File)additionInfo.get(StructureFields.AdditionInfo.movedFromOpRootRelPath)));
        long movedFromOpDepth = additionInfo.lng(StructureFields.AdditionInfo.movedFromOpDepth);
        File tmp = (File)additionInfo.get(StructureFields.AdditionInfo.movedFromOpRootRelPath);
        while ((long)SVNWCUtils.relpathDepth(tmp) > movedFromOpDepth) {
            tmp = SVNFileUtil.getFileDir(tmp);
        }
        ((Structure)result).set((StructureFields.MovedInfo)StructureFields.MovedInfo.movedFromDeleteAbsPath, root.getAbsPath(tmp));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Structure<StructureFields.AdditionInfo> scanAddition(SVNWCDbRoot root, File localRelpath, StructureFields.AdditionInfo ... fields) throws SVNException {
        Object info = Structure.obtain(StructureFields.AdditionInfo.class, fields);
        ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.originalRevision, -1L);
        ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.originalReposId, -1L);
        ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.movedFromOpDepth, 0L);
        SvnWcDbShared.begingReadTransaction(root);
        File buildRelpath = SVNFileUtil.createFilePath("");
        File currentRelpath = localRelpath;
        SVNSqlJetStatement stmt = null;
        try {
            File reposPrefixPath = SVNFileUtil.createFilePath("");
            stmt = root.getSDb().getStatement(SVNWCDbStatements.SELECT_WORKING_NODE);
            stmt.bindf("is", root.getWcId(), localRelpath);
            if (!stmt.next()) {
                SvnWcDbStatementUtil.reset(stmt);
                SvnWcDbShared.nodeNotFound(root, localRelpath);
            }
            ISVNWCDb.SVNWCDbStatus presence = SvnWcDbStatementUtil.getColumnPresence(stmt);
            long opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
            if (opDepth == 0L || presence != ISVNWCDb.SVNWCDbStatus.Normal && presence != ISVNWCDb.SVNWCDbStatus.Incomplete) {
                SvnWcDbStatementUtil.reset(stmt);
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Expected node ''{0}'' to be added.", (Object)root.getAbsPath(localRelpath));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.originalRevision, SvnWcDbStatementUtil.getColumnRevNum(stmt, SVNWCDbSchema.NODES__Fields.revision));
            ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.status, (Object)ISVNWCDb.SVNWCDbStatus.Added);
            currentRelpath = localRelpath;
            int i = SVNWCUtils.relpathDepth(localRelpath);
            while ((long)i > opDepth) {
                reposPrefixPath = SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(SVNFileUtil.getFileName(currentRelpath)), reposPrefixPath);
                currentRelpath = SVNFileUtil.getFileDir(currentRelpath);
                --i;
            }
            ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.opRootRelPath, currentRelpath);
            ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.opRootAbsPath, root.getAbsPath(currentRelpath));
            if (((Structure)info).hasField(StructureFields.AdditionInfo.originalReposRelPath) || ((Structure)info).hasField(StructureFields.AdditionInfo.originalRootUrl) || ((Structure)info).hasField(StructureFields.AdditionInfo.originalUuid) || ((Structure)info).hasField(StructureFields.AdditionInfo.originalRevision) && ((Structure)info).lng((StructureFields.AdditionInfo)StructureFields.AdditionInfo.originalRevision) == -1L || ((Structure)info).hasField(StructureFields.AdditionInfo.status)) {
                if (!localRelpath.equals(currentRelpath)) {
                    SvnWcDbStatementUtil.reset(stmt);
                    stmt.bindf("is", root.getWcId(), currentRelpath);
                    if (!stmt.next()) {
                        SvnWcDbStatementUtil.reset(stmt);
                        SvnWcDbShared.nodeNotFound(root, currentRelpath);
                    }
                    if (((Structure)info).hasField(StructureFields.AdditionInfo.originalRevision) && ((Structure)info).lng((StructureFields.AdditionInfo)StructureFields.AdditionInfo.originalRevision) == -1L) {
                        ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.originalRevision, SvnWcDbStatementUtil.getColumnRevNum(stmt, SVNWCDbSchema.NODES__Fields.revision));
                    }
                }
                ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.originalReposRelPath, SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.repos_path));
                if (!SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.NODES__Fields.repos_id) && (((Structure)info).hasField(StructureFields.AdditionInfo.status) || ((Structure)info).hasField(StructureFields.AdditionInfo.originalReposId) || ((Structure)info).hasField(StructureFields.AdditionInfo.movedFromRelPath) || ((Structure)info).hasField(StructureFields.AdditionInfo.movedFromOpRootRelPath))) {
                    ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.originalReposId, SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.repos_id));
                    boolean movedHere = SvnWcDbStatementUtil.getColumnBoolean(stmt, SVNWCDbSchema.NODES__Fields.moved_here);
                    if (movedHere) {
                        ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.status, (Object)ISVNWCDb.SVNWCDbStatus.MovedHere);
                    } else {
                        ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.status, (Object)ISVNWCDb.SVNWCDbStatus.Copied);
                    }
                    if (movedHere && (((Structure)info).hasField(StructureFields.AdditionInfo.movedFromRelPath) || ((Structure)info).hasField(StructureFields.AdditionInfo.movedFromOpRootRelPath))) {
                        Structure<StructureFields.MovedFromInfo> movedFromInfo = SvnWcDbShared.getMovedFromInfo(root, currentRelpath, localRelpath);
                        if (movedFromInfo.hasValue(StructureFields.MovedFromInfo.opDepth)) {
                            ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.movedFromOpDepth, movedFromInfo.lng(StructureFields.MovedFromInfo.opDepth));
                        }
                        ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.movedFromOpRootRelPath, movedFromInfo.get(StructureFields.MovedFromInfo.movedFromOpRootRelPath));
                        ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.movedFromRelPath, movedFromInfo.get(StructureFields.MovedFromInfo.movedFromRelPath));
                    }
                }
            }
            block3: while (true) {
                SvnWcDbStatementUtil.reset(stmt);
                reposPrefixPath = SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(SVNFileUtil.getFileName(currentRelpath)), reposPrefixPath);
                currentRelpath = SVNFileUtil.getFileDir(currentRelpath);
                stmt.bindf("is", root.getWcId(), currentRelpath);
                if (!stmt.next()) break;
                opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
                i = SVNWCUtils.relpathDepth(currentRelpath);
                while (true) {
                    if ((long)i <= opDepth) continue block3;
                    reposPrefixPath = SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(SVNFileUtil.getFileName(currentRelpath)), reposPrefixPath);
                    currentRelpath = SVNFileUtil.getFileDir(currentRelpath);
                    --i;
                }
                break;
            }
            SvnWcDbStatementUtil.reset(stmt);
            buildRelpath = reposPrefixPath;
            if (((Structure)info).hasField(StructureFields.AdditionInfo.reposRelPath) || ((Structure)info).hasField(StructureFields.AdditionInfo.reposId)) {
                Structure<StructureFields.NodeInfo> baseInfo = SvnWcDbShared.getDepthInfo(root, currentRelpath, 0L, StructureFields.NodeInfo.reposRelPath, StructureFields.NodeInfo.reposId);
                ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.reposRelPath, SVNFileUtil.createFilePath((File)baseInfo.get(StructureFields.NodeInfo.reposRelPath), buildRelpath));
                ((Structure)info).set((StructureFields.AdditionInfo)StructureFields.AdditionInfo.reposId, baseInfo.lng(StructureFields.NodeInfo.reposId));
                baseInfo.release();
            }
        }
        catch (Throwable throwable) {
            SvnWcDbStatementUtil.reset(stmt);
            SvnWcDbShared.commitTransaction(root);
            throw throwable;
        }
        SvnWcDbStatementUtil.reset(stmt);
        SvnWcDbShared.commitTransaction(root);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Structure<StructureFields.MovedFromInfo> getMovedFromInfo(SVNWCDbRoot root, File movedToOpRootRelPath, File localRelPath) throws SVNException {
        SVNSqlJetStatement stmt;
        Object result;
        block5: {
            block4: {
                Object x;
                result = Structure.obtain(StructureFields.MovedFromInfo.class);
                stmt = null;
                try {
                    stmt = root.getSDb().getStatement(root.getFormat() == 29 ? SVNWCDbStatements.SELECT_MOVED_FROM_RELPATH_17 : SVNWCDbStatements.SELECT_MOVED_FROM_RELPATH);
                    stmt.bindf("is", root.getWcId(), movedToOpRootRelPath);
                    if (stmt.next()) break block4;
                    x = result;
                }
                catch (Throwable throwable) {
                    SvnWcDbStatementUtil.reset(stmt);
                    throw throwable;
                }
                SvnWcDbStatementUtil.reset(stmt);
                return x;
            }
            ((Structure)result).set((StructureFields.MovedFromInfo)StructureFields.MovedFromInfo.opDepth, SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth));
            File deleteOpRootReplpath = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.local_relpath);
            ((Structure)result).set((StructureFields.MovedFromInfo)StructureFields.MovedFromInfo.movedFromOpRootRelPath, deleteOpRootReplpath);
            if (movedToOpRootRelPath.equals(localRelPath)) {
                ((Structure)result).set((StructureFields.MovedFromInfo)StructureFields.MovedFromInfo.movedFromRelPath, deleteOpRootReplpath);
                break block5;
            }
            File childRelPath = SVNWCUtils.skipAncestor(movedToOpRootRelPath, localRelPath);
            ((Structure)result).set((StructureFields.MovedFromInfo)StructureFields.MovedFromInfo.movedFromRelPath, SVNFileUtil.createFilePath(deleteOpRootReplpath, childRelPath));
        }
        SvnWcDbStatementUtil.reset(stmt);
        return result;
    }

    public static Structure<StructureFields.DeletionInfo> scanDeletion(SVNWCDb db, File localAbsPath) throws SVNException {
        SVNWCDb.DirParsedInfo parsed = db.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelpath = parsed.localRelPath;
        return SvnWcDbShared.scanDeletion(pdh.getWCRoot(), localRelpath);
    }

    protected static Structure<StructureFields.DeletionInfo> scanDeletion(SVNWCDbRoot root, File localRelpath) throws SVNException {
        Object deletionInfoStructure = Structure.obtain(StructureFields.DeletionInfo.class);
        ISVNWCDb.WCDbDeletionInfo deletionInfo = root.getDb().scanDeletion(SVNFileUtil.createFilePath(root.getAbsPath(), localRelpath), ISVNWCDb.WCDbDeletionInfo.DeletionInfoField.values());
        ((Structure)deletionInfoStructure).set((StructureFields.DeletionInfo)StructureFields.DeletionInfo.baseDelRelPath, SVNFileUtil.skipAncestor(root.getAbsPath(), deletionInfo.baseDelAbsPath));
        ((Structure)deletionInfoStructure).set((StructureFields.DeletionInfo)StructureFields.DeletionInfo.movedToRelPath, SVNFileUtil.skipAncestor(root.getAbsPath(), deletionInfo.movedToAbsPath));
        ((Structure)deletionInfoStructure).set((StructureFields.DeletionInfo)StructureFields.DeletionInfo.movedToOpRootRelPath, SVNFileUtil.skipAncestor(root.getAbsPath(), deletionInfo.movedToOpRootAbsPath));
        ((Structure)deletionInfoStructure).set((StructureFields.DeletionInfo)StructureFields.DeletionInfo.workDelAbsPath, deletionInfo.workDelAbsPath);
        ((Structure)deletionInfoStructure).set((StructureFields.DeletionInfo)StructureFields.DeletionInfo.workDelRelPath, SVNFileUtil.skipAncestor(root.getAbsPath(), deletionInfo.baseDelAbsPath));
        return deletionInfoStructure;
    }

    public static Structure<StructureFields.NodeInfo> getBaseInfo(SVNWCDbRoot wcroot, File localRelPath, StructureFields.NodeInfo ... fields) throws SVNException {
        return SvnWcDbShared.getDepthInfo(wcroot, localRelPath, 0L, fields);
    }

    public static Structure<StructureFields.NodeInfo> getBaseInfo(SVNWCDb db, File localAbsPath, StructureFields.NodeInfo ... fields) throws SVNException {
        SVNWCDb.DirParsedInfo parsed = db.parseDir(localAbsPath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbDir pdh = parsed.wcDbDir;
        File localRelpath = parsed.localRelPath;
        return SvnWcDbShared.getDepthInfo(pdh.getWCRoot(), localRelpath, 0L, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Structure<StructureFields.NodeInfo> getDepthInfo(SVNWCDbRoot wcroot, File localRelPath, long opDepth, StructureFields.NodeInfo ... fields) throws SVNException {
        Object info;
        block32: {
            info = Structure.obtain(StructureFields.NodeInfo.class, fields);
            SVNSqlJetStatement stmt = wcroot.getSDb().getStatement(SVNWCDbStatements.SELECT_DEPTH_NODE);
            try {
                stmt.bindf("isi", wcroot.getWcId(), SVNFileUtil.getFilePath(localRelPath), opDepth);
                if (stmt.next()) {
                    ISVNWCDb.SVNWCDbKind node_kind = SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.NODES__Fields.kind);
                    if (((Structure)info).hasField(StructureFields.NodeInfo.kind)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.kind, (Object)node_kind);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.status)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.status, (Object)SvnWcDbStatementUtil.getColumnPresence(stmt));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.reposId)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.reposId, SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.repos_id));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.revision)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.revision, SvnWcDbStatementUtil.getColumnRevNum(stmt, SVNWCDbSchema.NODES__Fields.revision));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.reposRelPath)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.reposRelPath, SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.repos_path));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.reposRootUrl) || ((Structure)info).hasField(StructureFields.NodeInfo.reposUuid)) {
                        if (SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.NODES__Fields.repos_id)) {
                            if (((Structure)info).hasField(StructureFields.NodeInfo.reposRootUrl)) {
                                ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.reposRootUrl, null);
                            }
                            if (((Structure)info).hasField(StructureFields.NodeInfo.reposUuid)) {
                                ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.reposUuid, null);
                            }
                        } else {
                            Structure<StructureFields.RepositoryInfo> repositoryInfo = wcroot.getDb().fetchRepositoryInfo(wcroot.getSDb(), SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.repos_id));
                            repositoryInfo.from(new StructureFields.RepositoryInfo[]{StructureFields.RepositoryInfo.reposRootUrl, StructureFields.RepositoryInfo.reposUuid}).into((Structure)info, new StructureFields.NodeInfo[]{StructureFields.NodeInfo.reposRootUrl, StructureFields.NodeInfo.reposUuid});
                            repositoryInfo.release();
                        }
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.changedRev)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.changedRev, SvnWcDbStatementUtil.getColumnRevNum(stmt, SVNWCDbSchema.NODES__Fields.changed_revision));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.changedDate)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.changedDate, SvnWcDbStatementUtil.getColumnDate(stmt, SVNWCDbSchema.NODES__Fields.changed_date));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.changedAuthor)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.changedAuthor, SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.changed_author));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.depth)) {
                        if (node_kind != ISVNWCDb.SVNWCDbKind.Dir) {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.depth, SVNDepth.UNKNOWN);
                        } else {
                            String depth_str = SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.depth);
                            if (depth_str == null) {
                                ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.depth, SVNDepth.UNKNOWN);
                            } else {
                                ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.depth, SvnWcDbStatementUtil.parseDepth(depth_str));
                            }
                        }
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.checksum)) {
                        if (node_kind != ISVNWCDb.SVNWCDbKind.File) {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.checksum, null);
                        } else {
                            try {
                                ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.checksum, SvnWcDbStatementUtil.getColumnChecksum(stmt, SVNWCDbSchema.NODES__Fields.checksum));
                            }
                            catch (SVNException e) {
                                SVNErrorMessage err = SVNErrorMessage.create(e.getErrorMessage().getErrorCode(), "The node ''{0}'' has a corrupt checksum value.", (Object)wcroot.getAbsPath(localRelPath));
                                SVNErrorManager.error(err, SVNLogType.WC);
                            }
                        }
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.target)) {
                        if (node_kind != ISVNWCDb.SVNWCDbKind.Symlink) {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.target, null);
                        } else {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.target, SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.symlink_target));
                        }
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.updateRoot)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.updateRoot, SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.file_external) != null);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.hadProps)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.hadProps, SvnWcDbStatementUtil.hasColumnProperties(stmt, SVNWCDbSchema.NODES__Fields.properties));
                    }
                    break block32;
                }
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)wcroot.getAbsPath(localRelPath));
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            finally {
                stmt.reset();
            }
        }
        return info;
    }

    protected static Structure<StructureFields.NodeInfo> readInfo(SVNWCDbRoot wcRoot, File localRelPath, StructureFields.NodeInfo ... fields) throws SVNException {
        return SvnWcDbShared.readInfo(wcRoot, localRelPath, false, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Structure<StructureFields.NodeInfo> readInfo(SVNWCDbRoot wcRoot, File localRelPath, boolean isAdditionMode, StructureFields.NodeInfo ... fields) throws SVNException {
        Object info;
        block67: {
            info = Structure.obtain(StructureFields.NodeInfo.class, fields);
            SVNSqlJetStatement stmtInfo = null;
            SVNSqlJetStatement stmtActual = null;
            try {
                stmtInfo = wcRoot.getSDb().getStatement(((Structure)info).hasField(StructureFields.NodeInfo.lock) ? SVNWCDbStatements.SELECT_NODE_INFO_WITH_LOCK : SVNWCDbStatements.SELECT_NODE_INFO);
                stmtInfo.bindf("is", wcRoot.getWcId(), localRelPath);
                boolean haveInfo = stmtInfo.next();
                boolean haveActual = false;
                if (((Structure)info).hasField(StructureFields.NodeInfo.changelist) || ((Structure)info).hasField(StructureFields.NodeInfo.conflicted) || ((Structure)info).hasField(StructureFields.NodeInfo.propsMod)) {
                    stmtActual = wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_ACTUAL_NODE);
                    stmtActual.bindf("is", wcRoot.getWcId(), localRelPath);
                    haveActual = stmtActual.next();
                }
                if (haveInfo) {
                    long opDepth = SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.op_depth);
                    ISVNWCDb.SVNWCDbKind nodeKind = SvnWcDbStatementUtil.getColumnKind(stmtInfo, SVNWCDbSchema.NODES__Fields.kind);
                    if (((Structure)info).hasField(StructureFields.NodeInfo.status)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.status, (Object)SvnWcDbStatementUtil.getColumnPresence(stmtInfo));
                        if (opDepth != 0L) {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.status, (Object)SVNWCDb.getWorkingStatus((ISVNWCDb.SVNWCDbStatus)((Object)((Structure)info).get((StructureFields.NodeInfo)StructureFields.NodeInfo.status))));
                        }
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.kind)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.kind, (Object)nodeKind);
                    }
                    ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.reposId, opDepth != 0L ? -1L : SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.repos_id));
                    if (((Structure)info).hasField(StructureFields.NodeInfo.revision)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.revision, opDepth != 0L ? -1L : SvnWcDbStatementUtil.getColumnRevNum(stmtInfo, SVNWCDbSchema.NODES__Fields.revision));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.reposRelPath)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.reposRelPath, opDepth != 0L ? null : SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmtInfo, SVNWCDbSchema.NODES__Fields.repos_path)));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.changedDate)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.changedDate, SVNWCUtils.readDate(SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.changed_date)));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.changedRev)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.changedRev, SvnWcDbStatementUtil.getColumnRevNum(stmtInfo, SVNWCDbSchema.NODES__Fields.changed_revision));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.changedAuthor)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.changedAuthor, SvnWcDbStatementUtil.getColumnText(stmtInfo, SVNWCDbSchema.NODES__Fields.changed_author));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.recordedTime)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.recordedTime, SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.last_mod_time));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.depth)) {
                        if (nodeKind != ISVNWCDb.SVNWCDbKind.Dir) {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.depth, SVNDepth.UNKNOWN);
                        } else {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.depth, SvnWcDbStatementUtil.getColumnDepth(stmtInfo, SVNWCDbSchema.NODES__Fields.depth));
                        }
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.checksum)) {
                        if (nodeKind != ISVNWCDb.SVNWCDbKind.File) {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.checksum, null);
                        } else {
                            try {
                                ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.checksum, SvnWcDbStatementUtil.getColumnChecksum(stmtInfo, SVNWCDbSchema.NODES__Fields.checksum));
                            }
                            catch (SVNException e) {
                                SVNErrorMessage err = SVNErrorMessage.create(e.getErrorMessage().getErrorCode(), "The node ''{0}'' has a corrupt checksum value.", (Object)wcRoot.getAbsPath(localRelPath));
                                SVNErrorManager.error(err, SVNLogType.WC);
                            }
                        }
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.recordedSize)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.recordedSize, SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.translated_size));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.target)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.target, SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmtInfo, SVNWCDbSchema.NODES__Fields.symlink_target)));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.changelist) && haveActual) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.changelist, SvnWcDbStatementUtil.getColumnText(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.changelist));
                    }
                    ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.originalReposId, opDepth == 0L ? -1L : SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.repos_id));
                    if (((Structure)info).hasField(StructureFields.NodeInfo.originalRevision)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.originalRevision, opDepth == 0L ? -1L : SvnWcDbStatementUtil.getColumnRevNum(stmtInfo, SVNWCDbSchema.NODES__Fields.revision));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.originalReposRelpath)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.originalReposRelpath, opDepth == 0L ? null : SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmtInfo, SVNWCDbSchema.NODES__Fields.repos_path)));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.propsMod)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.propsMod, haveActual && !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.properties));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.hadProps)) {
                        byte[] props = SvnWcDbStatementUtil.getColumnBlob(stmtInfo, SVNWCDbSchema.NODES__Fields.properties);
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.hadProps, props != null && props.length > 2);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.conflicted)) {
                        if (haveActual) {
                            if (wcRoot.getFormat() == 29) {
                                ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.conflicted, !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data) || !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.prop_reject) || !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_old) || !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_new) || !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_working));
                            } else {
                                ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.conflicted, !SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_data));
                            }
                        } else {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.conflicted, false);
                        }
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.lock)) {
                        if (opDepth == 0L) {
                            SVNSqlJetStatement stmtBaseLock = stmtInfo.getJoinedStatement(SVNWCDbSchema.LOCK.toString());
                            ISVNWCDb.SVNWCDbLock lock = SvnWcDbStatementUtil.getLockFromColumns(stmtBaseLock, SVNWCDbSchema.LOCK__Fields.lock_token, SVNWCDbSchema.LOCK__Fields.lock_owner, SVNWCDbSchema.LOCK__Fields.lock_comment, SVNWCDbSchema.LOCK__Fields.lock_date);
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.lock, lock);
                        } else {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.lock, null);
                        }
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.haveWork)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.haveWork, opDepth != 0L);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.opRoot)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.opRoot, opDepth > 0L && opDepth == (long)SVNWCUtils.relpathDepth(localRelPath));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.haveBase) || ((Structure)info).hasField(StructureFields.NodeInfo.haveMoreWork)) {
                        if (((Structure)info).hasField(StructureFields.NodeInfo.haveMoreWork)) {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.haveMoreWork, false);
                        }
                        while (opDepth != 0L && (haveInfo = stmtInfo.next())) {
                            opDepth = SvnWcDbStatementUtil.getColumnInt64(stmtInfo, SVNWCDbSchema.NODES__Fields.op_depth);
                            if (!((Structure)info).hasField(StructureFields.NodeInfo.haveMoreWork)) continue;
                            if (opDepth > 0L) {
                                ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.haveMoreWork, true);
                            }
                            if (((Structure)info).hasField(StructureFields.NodeInfo.haveBase)) continue;
                        }
                        if (((Structure)info).hasField(StructureFields.NodeInfo.haveBase)) {
                            ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.haveBase, opDepth == 0L);
                        }
                    }
                    break block67;
                }
                if (haveActual) {
                    if (SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_data) && SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.tree_conflict_data) && SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.prop_reject) && SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_old) && SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_new) && SvnWcDbStatementUtil.isColumnNull(stmtActual, SVNWCDbSchema.ACTUAL_NODE__Fields.conflict_working)) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Corrupt data for ''{0}''", (Object)wcRoot.getAbsPath(localRelPath));
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.conflicted, true);
                    if (((Structure)info).hasField(StructureFields.NodeInfo.opRoot)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.opRoot, false);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.status)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.status, (Object)ISVNWCDb.SVNWCDbStatus.Normal);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.kind)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.kind, (Object)ISVNWCDb.SVNWCDbKind.Unknown);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.revision)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.revision, -1L);
                    }
                    ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.reposId, -1L);
                    if (((Structure)info).hasField(StructureFields.NodeInfo.changedRev)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.changedRev, -1L);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.depth)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.depth, SVNDepth.UNKNOWN);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.originalRevision)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.originalRevision, -1L);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.originalReposId)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.originalReposId, -1L);
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.changelist)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.changelist, stmtActual.getColumnString(SVNWCDbSchema.ACTUAL_NODE__Fields.changelist));
                    }
                    if (((Structure)info).hasField(StructureFields.NodeInfo.originalRevision)) {
                        ((Structure)info).set((StructureFields.NodeInfo)StructureFields.NodeInfo.originalRevision, -1L);
                    }
                } else {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found.", (Object)wcRoot.getAbsPath(localRelPath));
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
            finally {
                try {
                    if (stmtInfo != null) {
                        stmtInfo.reset();
                    }
                }
                catch (SVNException e) {}
                try {
                    if (stmtActual != null) {
                        stmtActual.reset();
                    }
                }
                catch (SVNException e) {}
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void canonicalizeURLs(SVNWCDbRoot wcRoot, boolean updateExternalProperties, final SVNExternalsStore store, final boolean omitDefaultPort) throws SVNException {
        HashMap<String, Object> values = new HashMap<String, Object>();
        try {
            SvnWcDbShared.begingWriteTransaction(wcRoot);
            ISqlJetTable repositoryTable = wcRoot.getSDb().getDb().getTable(SVNWCDbSchema.REPOSITORY.toString());
            ISqlJetCursor cursor = repositoryTable.open();
            while (!cursor.eof()) {
                String newUrl;
                String oldUrl = cursor.getString(SVNWCDbSchema.REPOSITORY__Fields.root.toString());
                SVNURL canonicalUrl = SVNUpdateClient16.canonicalizeURL(SVNURL.parseURIEncoded(oldUrl), omitDefaultPort);
                if (canonicalUrl != null && !oldUrl.equals(newUrl = canonicalUrl.toString())) {
                    values.put(SVNWCDbSchema.REPOSITORY__Fields.root.toString(), newUrl);
                    cursor.updateByFieldNames(values);
                }
                cursor.next();
            }
            cursor.close();
        }
        catch (SqlJetException e) {
            SvnWcDbShared.rollbackTransaction(wcRoot);
        }
        finally {
            SvnWcDbShared.commitTransaction(wcRoot);
        }
        if (updateExternalProperties) {
            final HashMap newPropertyValues = new HashMap();
            SvnWcDbProperties.readPropertiesRecursively(wcRoot, new File(""), SVNDepth.INFINITY, false, false, null, new ISvnObjectReceiver<SVNProperties>(){

                @Override
                public void receive(SvnTarget target, SVNProperties object) throws SVNException {
                    String externalsPropertyValue = object.getStringValue("svn:externals");
                    if (externalsPropertyValue != null) {
                        String newValue = SVNUpdateClient16.canonicalizeExtenrals(externalsPropertyValue, omitDefaultPort);
                        if (!externalsPropertyValue.equals(newValue)) {
                            object.put("svn:externals", newValue);
                            newPropertyValues.put(target.getFile(), object);
                        }
                        if (store != null) {
                            store.addExternal(target.getFile(), externalsPropertyValue, newValue);
                        }
                    }
                }
            });
            for (File path : newPropertyValues.keySet()) {
                wcRoot.getDb().opSetProps(path, (SVNProperties)newPropertyValues.get(path), null, false, null);
            }
        }
    }

    protected static class Target {
        public String relPath;
        public long wcId;

        public Target(long wcId, String relpath) {
            this.relPath = relpath;
            this.wcId = wcId;
        }
    }
}

