/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc2;

import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnOperationRunner;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import afu.org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRepositoryAccess;
import afu.org.tmatesoft.svn.core.internal.wc2.old.SvnOldRepositoryAccess;
import afu.org.tmatesoft.svn.core.wc.SVNRevision;
import afu.org.tmatesoft.svn.core.wc2.ISvnOperationOptionsProvider;
import afu.org.tmatesoft.svn.core.wc2.SvnOperation;

public abstract class SvnRemoteOperationRunner<V, T extends SvnOperation<V>>
extends SvnOperationRunner<V, T> {
    private SvnRepositoryAccess repositoryAccess;
    private SvnWcGeneration detectedWcGeneration;

    @Override
    public void reset(SvnWcGeneration wcGeneration) {
        super.reset(wcGeneration);
        this.repositoryAccess = null;
        this.detectedWcGeneration = wcGeneration;
    }

    @Override
    public boolean isApplicable(T operation, SvnWcGeneration wcGeneration) throws SVNException {
        return ((SvnOperation)operation).hasRemoteTargets() || !this.isRevisionLocalToWc(((SvnOperation)operation).getRevision());
    }

    protected SvnRepositoryAccess getRepositoryAccess() throws SVNException {
        if (this.repositoryAccess == null) {
            this.repositoryAccess = this.getDetectedWcGeneration() == SvnWcGeneration.V16 ? new SvnOldRepositoryAccess((ISvnOperationOptionsProvider)this.getOperation()) : new SvnNgRepositoryAccess((ISvnOperationOptionsProvider)this.getOperation(), this.getWcContext());
        }
        return this.repositoryAccess;
    }

    private SvnWcGeneration getDetectedWcGeneration() {
        return this.detectedWcGeneration;
    }

    protected boolean isRevisionLocalToWc(SVNRevision revision) {
        return revision == SVNRevision.BASE || revision == SVNRevision.WORKING || revision == SVNRevision.COMMITTED;
    }

    @Override
    public SvnWcGeneration getWcGeneration() {
        return SvnWcGeneration.NOT_DETECTED;
    }
}

