/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc2.ng;

import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNProperties;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback;
import afu.org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback2;
import afu.org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackResult;
import afu.org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffSource;
import java.io.File;

public class SvnDiffCallbackWrapper
implements ISvnDiffCallback2 {
    private final ISvnDiffCallback callback;
    private final boolean deleteDirs;
    private final File anchorAbsPath;

    public SvnDiffCallbackWrapper(ISvnDiffCallback callback, boolean deleteDirs, File anchorAbsPath) {
        this.callback = callback;
        this.deleteDirs = deleteDirs;
        this.anchorAbsPath = anchorAbsPath;
    }

    @Override
    public void fileOpened(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SvnDiffSource rightSource, SvnDiffSource copyFromSource, boolean createDirBaton, Object dirBaton) throws SVNException {
        if (leftSource != null) {
            this.callback.fileOpened(result, this.getAbsPath(relPath), rightSource != null ? rightSource.getRevision() : (leftSource != null ? leftSource.getRevision() : -1L));
        }
        result.newBaton = null;
    }

    @Override
    public void fileChanged(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SvnDiffSource rightSource, File leftFile, File rightFile, SVNProperties leftProps, SVNProperties rightProps, boolean fileModified, SVNProperties propChanges) throws SVNException {
        assert (leftSource != null && rightSource != null);
        this.callback.fileChanged(result, this.getAbsPath(relPath), fileModified ? leftFile : null, fileModified ? rightFile : null, leftSource.getRevision(), rightSource.getRevision(), leftProps == null ? null : leftProps.getStringValue("svn:mime-type"), rightProps == null ? null : rightProps.getStringValue("svn:mime-type"), propChanges, leftProps);
    }

    @Override
    public void fileAdded(SvnDiffCallbackResult result, File relPath, SvnDiffSource copyFromSource, SvnDiffSource rightSource, File copyFromFile, File rightFile, SVNProperties copyFromProps, SVNProperties rightProps) throws SVNException {
        if (copyFromProps == null) {
            copyFromProps = new SVNProperties();
        }
        SVNProperties propChanges = copyFromProps.compareTo(rightProps);
        this.callback.fileAdded(result, this.getAbsPath(relPath), copyFromSource != null ? copyFromFile : null, rightFile, 0L, rightSource.getRevision(), copyFromProps != null ? copyFromProps.getStringValue("svn:mime-type") : null, rightProps != null ? rightProps.getStringValue("svn:mime-type") : null, copyFromSource != null ? copyFromSource.getReposRelPath() : null, copyFromSource != null ? copyFromSource.getRevision() : -1L, propChanges, copyFromProps);
    }

    @Override
    public void fileDeleted(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, File leftFile, SVNProperties leftProps) throws SVNException {
        this.callback.fileDeleted(result, this.getAbsPath(relPath), leftFile, null, leftProps == null ? null : leftProps.getStringValue("svn:mime-type"), null, leftProps);
    }

    @Override
    public void fileClosed(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SvnDiffSource rightSource) throws SVNException {
    }

    @Override
    public void dirOpened(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SvnDiffSource rightSource, SvnDiffSource copyFromSource, Object dirBaton) throws SVNException {
        assert (leftSource != null || rightSource != null);
        assert (copyFromSource == null || rightSource != null);
        if (leftSource != null) {
            this.callback.dirOpened(result, this.getAbsPath(relPath), rightSource != null ? rightSource.getRevision() : (leftSource != null ? leftSource.getRevision() : -1L));
            if (rightSource == null && !this.deleteDirs) {
                result.skipChildren = true;
            }
        } else {
            this.callback.dirAdded(result, this.getAbsPath(relPath), rightSource.getRevision(), copyFromSource != null ? SVNFileUtil.getFilePath(copyFromSource.getReposRelPath()) : null, copyFromSource != null ? copyFromSource.getRevision() : -1L);
        }
        result.newBaton = null;
    }

    @Override
    public void dirChanged(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SvnDiffSource rightSource, SVNProperties leftProps, SVNProperties rightProps, SVNProperties propChanges, Object dirBaton) throws SVNException {
        assert (leftSource != null && rightSource != null);
        this.callback.dirPropsChanged(result, this.getAbsPath(relPath), false, propChanges, leftProps);
        this.dirClosed(result, this.getAbsPath(relPath), leftSource, rightSource, dirBaton);
    }

    @Override
    public void dirDeleted(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SVNProperties leftProps, Object dirBaton) throws SVNException {
        this.callback.dirDeleted(result, this.getAbsPath(relPath));
    }

    @Override
    public void dirAdded(SvnDiffCallbackResult result, File relPath, SvnDiffSource copyFromSource, SvnDiffSource rightSource, SVNProperties copyFromProps, SVNProperties rightProps, Object dirBaton) throws SVNException {
        SVNProperties pristineProps = copyFromProps;
        if (rightProps != null && rightProps.size() > 0) {
            if (pristineProps == null) {
                pristineProps = new SVNProperties();
            }
            SVNProperties propChanges = pristineProps.compareTo(rightProps);
            this.callback.dirPropsChanged(result, this.getAbsPath(relPath), true, propChanges, pristineProps);
        }
        this.callback.dirClosed(result, this.getAbsPath(relPath), true);
    }

    @Override
    public void dirClosed(SvnDiffCallbackResult result, File relPath, SvnDiffSource leftSource, SvnDiffSource rightSource, Object dirBaton) throws SVNException {
        this.callback.dirClosed(result, this.getAbsPath(relPath), false);
    }

    @Override
    public void nodeAbsent(SvnDiffCallbackResult result, File relPath, Object dirBaton) throws SVNException {
    }

    private File getAbsPath(File relPath) {
        return SVNFileUtil.createFilePath(this.anchorAbsPath, relPath);
    }
}

