/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc2.ng;

import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNNodeKind;
import afu.org.tmatesoft.svn.core.SVNProperties;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.internal.util.SVNDate;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import afu.org.tmatesoft.svn.core.internal.wc.admin.SVNTranslatorInputStream;
import afu.org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import afu.org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import afu.org.tmatesoft.svn.core.internal.wc17.db.Structure;
import afu.org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import afu.org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import afu.org.tmatesoft.svn.core.wc.SVNRevision;
import afu.org.tmatesoft.svn.core.wc.SVNStatusType;
import afu.org.tmatesoft.svn.core.wc2.SvnCat;
import afu.org.tmatesoft.svn.core.wc2.SvnStatus;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;

public class SvnNgCat
extends SvnNgOperationRunner<Void, SvnCat> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void run(SVNWCContext context) throws SVNException {
        InputStream source;
        block14: {
            SVNErrorMessage err;
            SVNURL reposRootUrl = null;
            SVNNodeKind kind = context.readKind(this.getFirstTarget(), false);
            if (kind == SVNNodeKind.UNKNOWN || kind == SVNNodeKind.NONE) {
                err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", (Object)this.getFirstTarget().getAbsolutePath());
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (kind != SVNNodeKind.FILE) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_IS_DIRECTORY, "''{0}'' refers to a directory", (Object)this.getFirstTarget().getAbsolutePath());
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            SVNRevision revision = ((SvnCat)this.getOperation()).getRevision();
            source = null;
            boolean localModifications = false;
            try {
                SVNProperties properties;
                if (revision != SVNRevision.WORKING) {
                    SVNWCContext.PristineContentsInfo info = context.getPristineContents(this.getFirstTarget(), true, false);
                    source = info.stream;
                    properties = context.getPristineProps(this.getFirstTarget());
                } else {
                    source = SVNFileUtil.openFileForReading(this.getFirstTarget());
                    properties = context.getDb().readProperties(this.getFirstTarget());
                    SvnStatus status = SVNStatusEditor17.internalStatus(context, this.getFirstTarget());
                    boolean bl = localModifications = status.getTextStatus() != SVNStatusType.STATUS_NORMAL;
                }
                if (properties == null) {
                    properties = new SVNProperties();
                }
                String eolStyle = properties.getStringValue("svn:eol-style");
                String keywords = properties.getStringValue("svn:keywords");
                boolean special = properties.getStringValue("svn:special") != null;
                long lastModified = 0L;
                if (localModifications && !special) {
                    lastModified = SVNFileUtil.getFileLastModified(this.getFirstTarget());
                } else {
                    Structure<StructureFields.NodeInfo> info = context.getDb().readInfo(this.getFirstTarget(), StructureFields.NodeInfo.recordedTime, StructureFields.NodeInfo.reposRootUrl);
                    reposRootUrl = (SVNURL)info.get(StructureFields.NodeInfo.reposRootUrl);
                    lastModified = info.lng(StructureFields.NodeInfo.recordedTime) / 1000L;
                    info.release();
                }
                Map<String, byte[]> keywordsMap = null;
                if (keywords != null && ((SvnCat)this.getOperation()).isExpandKeywords()) {
                    Structure<StructureFields.NodeInfo> info = context.getDb().readInfo(this.getFirstTarget(), StructureFields.NodeInfo.changedRev, StructureFields.NodeInfo.changedAuthor, StructureFields.NodeInfo.reposRootUrl);
                    SVNURL url = context.getNodeUrl(this.getFirstTarget());
                    String rev = Long.toString(info.lng(StructureFields.NodeInfo.changedRev));
                    String author = (String)info.get(StructureFields.NodeInfo.changedAuthor);
                    reposRootUrl = (SVNURL)info.get(StructureFields.NodeInfo.reposRootUrl);
                    info.release();
                    if (localModifications) {
                        rev = rev + "M";
                        author = "(local)";
                    }
                    String date = SVNDate.formatDate(new Date(lastModified));
                    keywordsMap = SVNTranslator.computeKeywords(keywords, url.toString(), reposRootUrl == null ? null : reposRootUrl.toString(), author, date, rev, ((SvnCat)this.getOperation()).getOptions());
                }
                if (keywordsMap != null || eolStyle != null) {
                    source = new SVNTranslatorInputStream(source, SVNTranslator.getEOL(eolStyle, ((SvnCat)this.getOperation()).getOptions()), false, keywordsMap, true);
                }
                if (source == null || ((SvnCat)this.getOperation()).getOutput() == null) break block14;
                try {
                    SVNTranslator.copy(source, ((SvnCat)this.getOperation()).getOutput());
                }
                catch (IOException e) {
                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                    SVNErrorManager.error(err2, SVNLogType.WC);
                }
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(source);
                throw throwable;
            }
        }
        SVNFileUtil.closeFile(source);
        return null;
    }
}

