/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc2.remote;

import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNLock;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import afu.org.tmatesoft.svn.core.internal.util.SVNHashMap;
import afu.org.tmatesoft.svn.core.internal.util.SVNHashSet;
import afu.org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnRemoteOperationRunner;
import afu.org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import afu.org.tmatesoft.svn.core.io.ISVNLockHandler;
import afu.org.tmatesoft.svn.core.io.SVNRepository;
import afu.org.tmatesoft.svn.core.wc.SVNEventAction;
import afu.org.tmatesoft.svn.core.wc2.SvnTarget;
import afu.org.tmatesoft.svn.core.wc2.SvnUnlock;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;
import java.util.Map;

public class SvnRemoteUnlock
extends SvnRemoteOperationRunner<SVNLock, SvnUnlock>
implements ISVNLockHandler {
    @Override
    public boolean isApplicable(SvnUnlock operation, SvnWcGeneration wcGeneration) throws SVNException {
        return operation.hasRemoteTargets();
    }

    @Override
    protected SVNLock run() throws SVNException {
        int i = 0;
        SVNURL[] urls = new SVNURL[((SvnUnlock)this.getOperation()).getTargets().size()];
        for (SvnTarget target : ((SvnUnlock)this.getOperation()).getTargets()) {
            urls[i++] = target.getURL();
        }
        SVNHashSet paths = new SVNHashSet();
        SVNURL topURL = SVNURLUtil.condenceURLs(urls, paths, false);
        if (paths.isEmpty()) {
            paths.add("");
        }
        Map pathsToTokens = new SVNHashMap();
        for (String path : paths) {
            path = SVNEncodingUtil.uriDecode(path);
            pathsToTokens.put(path, null);
        }
        this.checkCancelled();
        SVNRepository repository = this.getRepositoryAccess().createRepository(topURL, null, true);
        if (!((SvnUnlock)this.getOperation()).isBreakLock()) {
            pathsToTokens = this.fetchLockTokens(repository, pathsToTokens);
        }
        repository.unlock(pathsToTokens, ((SvnUnlock)this.getOperation()).isBreakLock(), this);
        return (SVNLock)((SvnUnlock)this.getOperation()).first();
    }

    private Map<String, String> fetchLockTokens(SVNRepository repository, Map<String, String> pathsTokensMap) throws SVNException {
        SVNHashMap tokens = new SVNHashMap();
        for (String path : pathsTokensMap.keySet()) {
            SVNLock lock = repository.getLock(path);
            if (lock == null || lock.getID() == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_MISSING_LOCK_TOKEN, "''{0}'' is not locked", (Object)path);
                SVNErrorManager.error(err, SVNLogType.WC);
                continue;
            }
            tokens.put(path, lock.getID());
        }
        return tokens;
    }

    @Override
    public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
    }

    @Override
    public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
        if (error != null) {
            this.handleEvent(SVNEventFactory.createLockEvent(new File(path), SVNEventAction.UNLOCK_FAILED, null, error), -1.0);
        } else {
            this.handleEvent(SVNEventFactory.createLockEvent(new File(path), SVNEventAction.UNLOCKED, null, null), -1.0);
        }
    }
}

