/*
 * Decompiled with CFR 0.152.
 */
package afu.plume;

import afu.plume.ArraysMDE;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class ClassFileVersion {
    static double minversion = 0.0;

    private ClassFileVersion() {
        throw new Error("do not instantiate");
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("Supplied no arguments.");
            System.out.println("Usage: java ClassFileVersion [-min JDKVER] <.class or .jar files>");
            System.exit(1);
        }
        if (args.length >= 2 && args[0].equals("-min")) {
            minversion = Double.parseDouble(args[1]);
            if (minversion == 1.6) {
                minversion = 6.0;
            } else if (minversion == 1.7) {
                minversion = 7.0;
            }
            args = ArraysMDE.subarray(args, 2, args.length - 2);
        }
        for (String filename : args) {
            if (!new File(filename).exists()) {
                System.out.println(filename + " does not exist!");
                continue;
            }
            if (filename.endsWith(".class")) {
                try (FileInputStream fis = new FileInputStream(filename);){
                    ClassFileVersion.processClassFile(filename, fis);
                    continue;
                }
            }
            if (filename.endsWith(".jar")) {
                JarFile jarFile = new JarFile(filename);
                Enumeration<JarEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.endsWith(".class")) continue;
                    InputStream is = jarFile.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        ClassFileVersion.processClassFile(filename + ":" + entryName, is);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                continue;
            }
            System.out.println(filename + " is neither a .class nor a .jar file");
        }
    }

    public static void processClassFile(String filename, InputStream is) {
        double[] versions = ClassFileVersion.versionNumbers(is);
        if (versions == null) {
            System.out.println(filename + " is not a .class file (or IOException)");
        } else {
            double major = versions[0];
            double minor = versions[1];
            double jdkVersion = versions[2];
            if (jdkVersion >= minversion) {
                System.out.println(filename + " class file version is " + (int)major + "." + (int)minor + ", requires JDK " + (jdkVersion == (double)((int)jdkVersion) ? Integer.toString((int)jdkVersion) : Double.toString(jdkVersion)) + " or later");
            }
        }
    }

    public static double[] versionNumbers(InputStream is) {
        try {
            DataInputStream dis = new DataInputStream(is);
            int magic = dis.readInt();
            if (magic != -889275714) {
                return null;
            }
            double minor = dis.readShort();
            double major = dis.readShort();
            double jdkVersion = major < 48.0 ? 1.3 : (major == 48.0 ? 1.4 : (major == 49.0 ? 1.5 : (major == 50.0 ? 6.0 : 7.0)));
            return new double[]{major, minor, jdkVersion};
        }
        catch (IOException e) {
            return null;
        }
    }
}

