/*
 * Decompiled with CFR 0.152.
 */
package afu.plume;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;

public class FileIOException
extends IOException {
    static final long serialVersionUID = 20050923L;
    public final String fileName;
    public final int lineNumber;

    public FileIOException() {
        this.fileName = null;
        this.lineNumber = -1;
    }

    public FileIOException(Throwable cause) {
        this.initCause(cause);
        this.fileName = null;
        this.lineNumber = -1;
    }

    public FileIOException(String s2) {
        super(s2);
        this.fileName = null;
        this.lineNumber = -1;
    }

    public FileIOException(String s2, Throwable cause) {
        super(s2);
        this.initCause(cause);
        this.fileName = null;
        this.lineNumber = -1;
    }

    public FileIOException(String s2, String fileName, int lineNumber) {
        super(s2);
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public FileIOException(String s2, Throwable cause, String fileName, int lineNumber) {
        super(s2);
        this.initCause(cause);
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public FileIOException(LineNumberReader reader, Throwable cause) {
        this(reader, (String)null, cause);
    }

    public FileIOException(String s2, LineNumberReader reader) {
        this(s2, reader, (String)null);
    }

    public FileIOException(String s2, LineNumberReader reader, Throwable cause) {
        this(s2, reader, (String)null, cause);
    }

    public FileIOException(String s2, LineNumberReader reader, String fileName) {
        super(s2);
        this.fileName = fileName;
        this.lineNumber = FileIOException.getLineNumber(reader);
    }

    public FileIOException(LineNumberReader reader, String fileName, Throwable cause) {
        this.initCause(cause);
        this.fileName = fileName;
        this.lineNumber = FileIOException.getLineNumber(reader);
    }

    public FileIOException(String s2, LineNumberReader reader, String fileName, Throwable cause) {
        super(s2);
        this.initCause(cause);
        this.fileName = fileName;
        this.lineNumber = FileIOException.getLineNumber(reader);
    }

    public FileIOException(String s2, LineNumberReader reader, File file) {
        this(s2, reader, file.getName());
    }

    public FileIOException(String s2, LineNumberReader reader, File file, Throwable cause) {
        this(s2, reader, file.getName(), cause);
    }

    public FileIOException(LineNumberReader reader, File file, Throwable cause) {
        this.initCause(cause);
        this.fileName = file.getName();
        this.lineNumber = FileIOException.getLineNumber(reader);
    }

    @Override
    public String toString() {
        String result = super.toString();
        if (this.fileName != null) {
            result = result + " in file " + this.fileName;
        }
        if (this.lineNumber != -1) {
            result = result + " at line " + this.lineNumber;
        }
        return result;
    }

    private static int getLineNumber(LineNumberReader reader) {
        if (reader != null) {
            return reader.getLineNumber();
        }
        return -1;
    }
}

