/*
 * Decompiled with CFR 0.152.
 */
package afu.plume;

import afu.plume.ArraysMDE;
import java.io.Serializable;
import java.util.List;

public class LimitedSizeIntSet
implements Serializable,
Cloneable {
    static final long serialVersionUID = 20031021L;
    protected int[] values;
    int num_values;

    public LimitedSizeIntSet(int max_values) {
        assert (max_values > 0);
        this.values = new int[max_values];
        this.num_values = 0;
    }

    public void add(int elt) {
        if (this.values == null) {
            return;
        }
        if (this.contains(elt)) {
            return;
        }
        if (this.num_values == this.values.length) {
            this.values = null;
            ++this.num_values;
            return;
        }
        this.values[this.num_values] = elt;
        ++this.num_values;
    }

    public void addAll(LimitedSizeIntSet s2) {
        boolean sameObject;
        boolean bl = sameObject = this == s2;
        if (sameObject) {
            return;
        }
        if (this.repNulled()) {
            return;
        }
        if (s2.repNulled()) {
            int values_length = this.values.length;
            if (s2.size() > values_length) {
                this.num_values = values_length + 1;
                this.values = null;
                return;
            }
            throw new Error("Arg is rep-nulled, so we don't know its values and can't add them to this.");
        }
        for (int i = 0; i < s2.size(); ++i) {
            assert (s2.values != null) : "@AssumeAssertion(nullness): no relevant side effect:  add's side effects do not affect s.values";
            this.add(s2.values[i]);
            if (!this.repNulled()) continue;
            return;
        }
    }

    public boolean contains(int elt) {
        if (this.values == null) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < this.num_values; ++i) {
            if (this.values[i] != elt) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.num_values;
    }

    public int max_size() {
        if (this.values == null) {
            return this.num_values;
        }
        return this.values.length + 1;
    }

    public boolean repNulled() {
        return this.values == null;
    }

    public LimitedSizeIntSet clone() {
        LimitedSizeIntSet result;
        try {
            result = (LimitedSizeIntSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error();
        }
        if (this.values != null) {
            result.values = (int[])this.values.clone();
        }
        return result;
    }

    public static LimitedSizeIntSet merge(int max_values, List<LimitedSizeIntSet> slist) {
        LimitedSizeIntSet result = new LimitedSizeIntSet(max_values);
        for (LimitedSizeIntSet s2 : slist) {
            result.addAll(s2);
        }
        return result;
    }

    public String toString() {
        return "[size=" + this.size() + "; " + (this.values == null ? "null" : ArraysMDE.toString(this.values)) + "]";
    }
}

