/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotations.el.LocalLocation;
import annotator.find.Criterion;
import annotator.scanner.LocalVariableScanner;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.util.Pair;
import java.util.List;

public class LocalVariableCriterion
implements Criterion {
    private final String fullMethodName;
    private final LocalLocation loc;

    public LocalVariableCriterion(String methodName, LocalLocation loc) {
        this.fullMethodName = methodName.substring(0, methodName.indexOf(")") + 1);
        this.loc = loc;
    }

    @Override
    public boolean isSatisfiedBy(TreePath path, Tree leaf) {
        assert (path == null || path.getLeaf() == leaf);
        return this.isSatisfiedBy(path);
    }

    @Override
    public boolean isSatisfiedBy(TreePath path) {
        Tree parent;
        if (path == null) {
            return false;
        }
        TreePath parentPath = path.getParentPath();
        if (parentPath != null && (parent = parentPath.getLeaf()) != null) {
            if (parent instanceof VariableTree && !(parentPath.getParentPath().getLeaf() instanceof MethodTree)) {
                VariableTree vtt = (VariableTree)parent;
                String varName = vtt.getName().toString();
                if (this.loc.varName != null && this.loc.varName.equals(varName)) {
                    int varIndex = LocalVariableScanner.indexOfVarTree(path, vtt, varName);
                    return this.loc.varIndex == varIndex;
                }
                Pair<String, Pair<Integer, Integer>> key = Pair.of(this.fullMethodName, Pair.of(this.loc.index, this.loc.scopeStart));
                String potentialVarName = LocalVariableScanner.getFromMethodNameIndexMap(key);
                if (potentialVarName != null && varName.equals(potentialVarName)) {
                    List<Integer> allOffsetsWithThisName = LocalVariableScanner.getFromMethodNameCounter(this.fullMethodName, potentialVarName);
                    Integer thisVariablesOffset = allOffsetsWithThisName.indexOf(this.loc.scopeStart);
                    int i = LocalVariableScanner.indexOfVarTree(path, parent, potentialVarName);
                    if (i == thisVariablesOffset) {
                        return true;
                    }
                }
            } else {
                return this.isSatisfiedBy(parentPath);
            }
        }
        return false;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.LOCAL_VARIABLE;
    }

    public String toString() {
        return "LocalVariableCriterion: in: " + this.fullMethodName + " loc: " + this.loc;
    }
}

