/*
 * Decompiled with CFR 0.152.
 */
package annotator.scanner;

import annotator.scanner.CommonScanner;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.tree.JCTree;

public class InitBlockScanner
extends TreePathScanner<Void, Boolean> {
    private int index = -1;
    private boolean done = false;
    private final Tree tree;

    public static int indexOfInitTree(TreePath path, boolean isStatic) {
        Tree tree = CommonScanner.findEnclosingInitBlock(path, isStatic).getLeaf();
        path = CommonScanner.findEnclosingClass(path);
        if (tree == null || path == null) {
            return -1;
        }
        InitBlockScanner bts = new InitBlockScanner(tree);
        bts.scan(path, Boolean.valueOf(isStatic));
        return bts.index;
    }

    private InitBlockScanner(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Void visitBlock(BlockTree node, Boolean isStatic) {
        if (!this.done && isStatic.booleanValue() == node.isStatic() && ((JCTree.JCBlock)node).endpos >= 0) {
            ++this.index;
        }
        if (this.tree == node) {
            this.done = true;
        }
        return (Void)super.visitBlock(node, isStatic);
    }
}

