/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.glacier;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import edu.cmu.cs.glacier.GlacierTypeHierarchy;
import edu.cmu.cs.glacier.qual.GlacierBottom;
import edu.cmu.cs.glacier.qual.Immutable;
import edu.cmu.cs.glacier.qual.MaybeMutable;
import edu.cmu.cs.glacier.qual.ReadOnly;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.ElementAnnotationApplier;
import org.checkerframework.framework.type.SyntheticArrays;
import org.checkerframework.framework.type.TypeHierarchy;
import org.checkerframework.framework.type.visitor.AnnotatedTypeScanner;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;

public class GlacierAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    protected final AnnotationMirror MAYBE_MUTABLE;
    protected final AnnotationMirror IMMUTABLE;
    protected final AnnotationMirror GLACIER_BOTTOM;
    protected final AnnotationMirror READ_ONLY;

    public GlacierAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker, false);
        this.MAYBE_MUTABLE = AnnotationUtils.fromClass((Elements)this.elements, MaybeMutable.class);
        this.IMMUTABLE = AnnotationUtils.fromClass((Elements)this.elements, Immutable.class);
        this.GLACIER_BOTTOM = AnnotationUtils.fromClass((Elements)this.elements, GlacierBottom.class);
        this.READ_ONLY = AnnotationUtils.fromClass((Elements)this.elements, ReadOnly.class);
        this.postInit();
    }

    public AnnotatedTypeMirror.AnnotatedDeclaredType getSelfType(Tree tree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType selfType = super.getSelfType(tree);
        TreePath path = this.getPath(tree);
        ClassTree enclosingClass = TreeUtils.enclosingClass((TreePath)path);
        if (enclosingClass == null) {
            enclosingClass = this.getCurrentClassTree(tree);
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType enclosingClassType = this.getAnnotatedType(enclosingClass);
        if (!selfType.isAnnotatedInHierarchy(this.READ_ONLY)) {
            if (enclosingClassType.isAnnotatedInHierarchy(this.READ_ONLY)) {
                this.annotateInheritedFromClass((AnnotatedTypeMirror)selfType, enclosingClassType.getAnnotations());
            } else {
                selfType.addAnnotation(this.MAYBE_MUTABLE);
            }
        }
        return selfType;
    }

    private static boolean isWhitelistedImmutableClass(Element element) {
        return element.asType().toString().equals("java.lang.String") || element.asType().toString().equals("java.lang.Number");
    }

    private static boolean isAutoboxedImmutableClass(Types types, AnnotatedTypeMirror type) {
        try {
            types.unboxedType(type.getUnderlyingType());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public void postAsMemberOf(AnnotatedTypeMirror type, AnnotatedTypeMirror owner, Element element) {
        super.postAsMemberOf(type, owner, element);
        if (SyntheticArrays.isArrayClone((AnnotatedTypeMirror)owner, (Element)element)) {
            AnnotatedTypeMirror.AnnotatedExecutableType executableType = (AnnotatedTypeMirror.AnnotatedExecutableType)type;
            AnnotatedTypeMirror.AnnotatedDeclaredType receiverType = executableType.getReceiverType();
            receiverType.removeAnnotationInHierarchy(this.READ_ONLY);
            receiverType.addAnnotation(this.READ_ONLY);
            AnnotatedTypeMirror.AnnotatedArrayType arrayReturnType = (AnnotatedTypeMirror.AnnotatedArrayType)executableType.getReturnType();
            arrayReturnType.removeAnnotationInHierarchy(this.READ_ONLY);
            arrayReturnType.addAnnotation(this.GLACIER_BOTTOM);
        }
    }

    protected void annotateInheritedFromClass(AnnotatedTypeMirror type) {
        GlacierInheritedFromClassAnnotator.INSTANCE.visit(type, (Object)this);
    }

    protected void annotateInheritedFromClass(AnnotatedTypeMirror type, Set<AnnotationMirror> fromClass) {
        type.addMissingAnnotations(fromClass);
    }

    protected TypeHierarchy createTypeHierarchy() {
        return new GlacierTypeHierarchy(this.checker, this.getQualifierHierarchy(), this.checker.hasOption("ignoreRawTypeArguments"), this.checker.hasOption("invariantArrays"));
    }

    protected static class GlacierInheritedFromClassAnnotator
    extends AnnotatedTypeScanner<Void, GlacierAnnotatedTypeFactory> {
        public static final GlacierInheritedFromClassAnnotator INSTANCE = new GlacierInheritedFromClassAnnotator();
        private final Map<TypeParameterElement, AnnotatedTypeMirror.AnnotatedTypeVariable> visited = new HashMap<TypeParameterElement, AnnotatedTypeMirror.AnnotatedTypeVariable>();

        private GlacierInheritedFromClassAnnotator() {
        }

        public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type, GlacierAnnotatedTypeFactory p) {
            this.scanAndReduce((AnnotatedTypeMirror)type.getReceiverType(), (Object)p, null);
            this.scan(type.getReturnType(), (Object)p);
            this.scanAndReduce(type.getParameterTypes(), (Object)p, null);
            this.scanAndReduce(type.getThrownTypes(), (Object)p, null);
            this.scanAndReduce(type.getTypeVariables(), (Object)p, null);
            return null;
        }

        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, GlacierAnnotatedTypeFactory p) {
            Element classElt = type.getUnderlyingType().asElement();
            if (classElt != null) {
                boolean isHardCodedImmutable;
                boolean bl = isHardCodedImmutable = GlacierAnnotatedTypeFactory.isAutoboxedImmutableClass(p.types, (AnnotatedTypeMirror)type) || GlacierAnnotatedTypeFactory.isWhitelistedImmutableClass(classElt);
                if (isHardCodedImmutable && !type.isAnnotatedInHierarchy(p.READ_ONLY)) {
                    type.addAnnotation(Immutable.class);
                } else {
                    AnnotatedTypeMirror classType = p.fromElement(classElt);
                    assert (classType != null) : "Unexpected null type for class element: " + classElt;
                    if (!classType.isAnnotatedInHierarchy(p.READ_ONLY) && !type.isAnnotatedInHierarchy(p.READ_ONLY)) {
                        type.addAnnotation(MaybeMutable.class);
                    } else {
                        p.annotateInheritedFromClass((AnnotatedTypeMirror)type, classType.getAnnotations());
                    }
                }
            }
            return (Void)super.visitDeclared(type, (Object)p);
        }

        public Void visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, GlacierAnnotatedTypeFactory p) {
            TypeParameterElement tpelt = (TypeParameterElement)type.getUnderlyingType().asElement();
            if (!this.visited.containsKey(tpelt)) {
                this.visited.put(tpelt, type);
                if (type.getAnnotations().isEmpty() && type.getUpperBound().getAnnotations().isEmpty() && tpelt.getEnclosingElement().getKind() != ElementKind.TYPE_PARAMETER) {
                    ElementAnnotationApplier.apply((AnnotatedTypeMirror)type, (Element)tpelt, (AnnotatedTypeFactory)p);
                }
                super.visitTypeVariable(type, (Object)p);
                this.visited.remove(tpelt);
            }
            return null;
        }

        public void reset() {
            this.visited.clear();
            super.reset();
        }

        public Void visitIntersection(AnnotatedTypeMirror.AnnotatedIntersectionType type, GlacierAnnotatedTypeFactory p) {
            if (this.visitedNodes.containsKey(type)) {
                return (Void)this.visitedNodes.get(type);
            }
            this.visitedNodes.put(type, null);
            Void r = (Void)this.scan(type.directSuperTypes(), (Object)p);
            return r;
        }

        public Void visitUnion(AnnotatedTypeMirror.AnnotatedUnionType type, GlacierAnnotatedTypeFactory p) {
            if (this.visitedNodes.containsKey(type)) {
                return (Void)this.visitedNodes.get(type);
            }
            this.visitedNodes.put(type, null);
            Void r = (Void)this.scan(type.getAlternatives(), (Object)p);
            return r;
        }

        public Void visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, GlacierAnnotatedTypeFactory p) {
            if (!type.isAnnotatedInHierarchy(p.READ_ONLY)) {
                type.addAnnotation(MaybeMutable.class);
            }
            Void r = (Void)this.scan(type.getComponentType(), (Object)p);
            return r;
        }

        public Void visitNoType(AnnotatedTypeMirror.AnnotatedNoType type, GlacierAnnotatedTypeFactory p) {
            return null;
        }

        public Void visitNull(AnnotatedTypeMirror.AnnotatedNullType type, GlacierAnnotatedTypeFactory p) {
            return null;
        }

        public Void visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type, GlacierAnnotatedTypeFactory p) {
            if (!type.isAnnotatedInHierarchy(p.READ_ONLY)) {
                type.addAnnotation(Immutable.class);
            }
            return null;
        }

        public Void visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, GlacierAnnotatedTypeFactory p) {
            if (this.visitedNodes.containsKey(type)) {
                return (Void)this.visitedNodes.get(type);
            }
            this.visitedNodes.put(type, null);
            Void r = (Void)this.scan(type.getExtendsBound(), (Object)p);
            this.visitedNodes.put(type, r);
            r = (Void)this.scanAndReduce(type.getSuperBound(), (Object)p, r);
            this.visitedNodes.put(type, r);
            return r;
        }
    }
}

