/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.glacier;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import edu.cmu.cs.glacier.GlacierAnnotatedTypeFactory;
import edu.cmu.cs.glacier.GlacierTypeValidator;
import edu.cmu.cs.glacier.qual.GlacierBottom;
import edu.cmu.cs.glacier.qual.Immutable;
import edu.cmu.cs.glacier.qual.ReadOnly;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeValidator;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.util.PurityUtils;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.AnnotatedTypeParameterBounds;
import org.checkerframework.framework.type.GenericAnnotatedTypeFactory;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.TypeHierarchy;
import org.checkerframework.framework.util.BaseContext;
import org.checkerframework.framework.util.ContractsUtils;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class GlacierVisitor
extends BaseTypeVisitor<GlacierAnnotatedTypeFactory> {
    public GlacierVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    protected BaseTypeValidator createTypeValidator() {
        return new GlacierTypeValidator(this.checker, this, (AnnotatedTypeFactory)this.atypeFactory);
    }

    private static boolean modifiersIncludeModifier(ModifiersTree modifiers, Class<? extends Annotation> modifier) {
        boolean foundImmutable = false;
        List<? extends AnnotationTree> annotations = modifiers.getAnnotations();
        for (AnnotationMirror a : InternalUtils.annotationsFromTypeAnnotationTrees(annotations)) {
            if (!AnnotationUtils.areSameByClass((AnnotationMirror)a, modifier)) continue;
            foundImmutable = true;
        }
        return foundImmutable;
    }

    private boolean typeIsImmutable(AnnotatedTypeMirror type) {
        TypeMirror underlyingType = type.getUnderlyingType();
        boolean fieldIsImmutable = type.hasAnnotation(Immutable.class);
        if (!fieldIsImmutable) {
            TypeElement classElement;
            AnnotatedTypeMirror.AnnotatedDeclaredType classTypeMirror;
            TypeVariable typeVariable;
            TypeParameterElement typeVariableElement;
            Element elementEnclosingTypeVariable;
            boolean typeIsPrimitive = underlyingType instanceof PrimitiveType;
            boolean typeIsImmutableClassTypeParameter = false;
            if (underlyingType.getKind() == TypeKind.TYPEVAR && ((elementEnclosingTypeVariable = (typeVariableElement = (TypeParameterElement)(typeVariable = (TypeVariable)underlyingType).asElement()).getGenericElement()).getKind() == ElementKind.CLASS || elementEnclosingTypeVariable.getKind() == ElementKind.ENUM) && (classTypeMirror = ((GlacierAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(classElement = (TypeElement)elementEnclosingTypeVariable)).hasAnnotation(Immutable.class)) {
                typeIsImmutableClassTypeParameter = true;
            }
            if (!typeIsPrimitive && !typeIsImmutableClassTypeParameter) {
                return false;
            }
        }
        if (underlyingType.getKind() == TypeKind.ARRAY) {
            AnnotatedTypeMirror.AnnotatedArrayType arrayType = (AnnotatedTypeMirror.AnnotatedArrayType)type;
            AnnotatedTypeMirror componentType = arrayType.getComponentType();
            return this.typeIsImmutable(componentType);
        }
        return true;
    }

    private void checkFieldIsImmutable(ClassTree deepestClassTree, Tree containingTree, TypeElement immediateContainingElement, Element element, boolean alsoCheckFinal) {
        AnnotatedTypeMirror fieldType = ((GlacierAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(element);
        if (!this.typeIsImmutable(fieldType)) {
            if (alsoCheckFinal) {
                this.checker.report(Result.failure((String)"glacier.mutablemember", (Object[])new Object[]{deepestClassTree.getSimpleName(), immediateContainingElement, element}), (Object)deepestClassTree);
            } else if (fieldType.getUnderlyingType().getKind() == TypeKind.ARRAY) {
                AnnotatedTypeMirror.AnnotatedArrayType arrayType = (AnnotatedTypeMirror.AnnotatedArrayType)fieldType;
                if (!arrayType.hasAnnotation(Immutable.class)) {
                    this.checker.report(Result.failure((String)"glacier.mutable.wholearray.invalid", (Object[])new Object[0]), (Object)element);
                } else {
                    this.checker.report(Result.failure((String)"glacier.mutable.array.invalid", (Object[])new Object[0]), (Object)element);
                }
            } else {
                this.checker.report(Result.failure((String)"glacier.mutable.invalid", (Object[])new Object[0]), (Object)element);
            }
        }
        if (alsoCheckFinal && !ElementUtils.isFinal((Element)element)) {
            this.checker.report(Result.failure((String)"glacier.nonfinalmember", (Object[])new Object[]{deepestClassTree.getSimpleName(), immediateContainingElement, element}), (Object)deepestClassTree);
        }
    }

    private void checkElementMembersAreImmutable(ClassTree outermostTree, Tree containingTree, Element elem, boolean alsoCheckFinal) {
        if (elem.getKind() == ElementKind.CLASS || elem.getKind() == ElementKind.ENUM) {
            TypeElement typeElement = (TypeElement)elem;
            List<? extends Element> elements = typeElement.getEnclosedElements();
            for (Element element : elements) {
                if (element.getKind() != ElementKind.FIELD) continue;
                this.checkFieldIsImmutable(outermostTree, containingTree, typeElement, element, alsoCheckFinal);
            }
            TypeMirror superclassType = typeElement.getSuperclass();
            if (superclassType != null && superclassType.getKind() == TypeKind.DECLARED) {
                DeclaredType declaredType = (DeclaredType)superclassType;
                Element superclassElement = declaredType.asElement();
                this.checkElementMembersAreImmutable(outermostTree, containingTree, superclassElement, alsoCheckFinal);
            }
        }
    }

    private void checkAllClassMembersAreImmutable(ClassTree outermostTree, Tree containingTree, boolean alsoCheckFinal) {
        if (containingTree instanceof ExpressionTree) {
            Element elem = TreeUtils.elementFromUse((ExpressionTree)((ExpressionTree)containingTree));
            this.checkElementMembersAreImmutable(outermostTree, containingTree, elem, alsoCheckFinal);
        }
    }

    private void checkImmediateMembersAreImmutable(ClassTree classTree, boolean alsoCheckFinal) {
        TypeElement classTreeAsElement = TreeUtils.elementFromDeclaration((ClassTree)classTree);
        List<? extends Tree> members = classTree.getMembers();
        for (Tree tree : members) {
            if (tree.getKind() != Tree.Kind.VARIABLE) continue;
            this.checkFieldIsImmutable(classTree, classTree, classTreeAsElement, TreeUtils.elementFromDeclaration((VariableTree)((VariableTree)tree)), false);
        }
    }

    public Void visitClass(ClassTree node, Void p) {
        Tree superclass;
        super.visitClass(node, p);
        boolean classIsImmutable = GlacierVisitor.modifiersIncludeModifier(node.getModifiers(), Immutable.class);
        boolean classIsReadonly = GlacierVisitor.modifiersIncludeModifier(node.getModifiers(), ReadOnly.class);
        if (classIsReadonly) {
            this.checker.report(Result.failure((String)"glacier.readonly.class", (Object[])new Object[0]), (Object)node);
        }
        if (classIsImmutable) {
            this.checkImmediateMembersAreImmutable(node, false);
        }
        if ((superclass = node.getExtendsClause()) != null) {
            AnnotatedTypeMirror superclassType = ((GlacierAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(superclass);
            if (superclassType.hasAnnotation(Immutable.class) && !classIsImmutable) {
                this.checker.report(Result.failure((String)"glacier.subclass.mutable", (Object[])new Object[]{node.getSimpleName(), superclass.toString()}), (Object)node);
            } else if (classIsImmutable && !superclassType.hasAnnotation(Immutable.class)) {
                this.checkAllClassMembersAreImmutable(node, superclass, true);
            }
        }
        List<? extends Tree> interfaces = node.getImplementsClause();
        for (Tree tree : interfaces) {
            AnnotatedTypeMirror interfaceType = ((GlacierAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(tree);
            if (!interfaceType.hasAnnotation(Immutable.class)) continue;
            if (classIsImmutable) break;
            this.checker.report(Result.failure((String)"glacier.interface.immutable", (Object[])new Object[]{node.getSimpleName(), tree}), (Object)node);
            break;
        }
        return null;
    }

    public Void visitAssignment(AssignmentTree node, Void p) {
        super.visitAssignment(node, p);
        ExpressionTree variable = node.getVariable();
        if (TreeUtils.isFieldAccess((Tree)variable)) {
            AnnotatedTypeMirror.AnnotatedDeclaredType ownerType = null;
            if (variable.getKind().equals((Object)Tree.Kind.MEMBER_SELECT)) {
                MemberSelectTree memberSelect = (MemberSelectTree)variable;
                ownerType = ((GlacierAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(memberSelect.getExpression());
            } else if (variable.getKind().equals((Object)Tree.Kind.IDENTIFIER)) {
                ownerType = this.visitorState.getClassType();
            }
            MethodTree methodTree = this.visitorState.getMethodTree();
            if (methodTree != null) {
                boolean methodIsConstructor = TreeUtils.isConstructor((MethodTree)methodTree);
                AnnotatedTypeMirror.AnnotatedDeclaredType classType = this.visitorState.getClassType();
                boolean classOwnsAssignedField = ownerType.getUnderlyingType().equals(classType.getUnderlyingType());
                AnnotationMirror ownerAnnotationMirror = ownerType.getAnnotationInHierarchy(((GlacierAnnotatedTypeFactory)this.atypeFactory).READ_ONLY);
                Element fieldElement = TreeUtils.elementFromUse((ExpressionTree)variable);
                boolean fieldIsStatic = ElementUtils.isStatic((Element)fieldElement);
                if (!(methodIsConstructor && classOwnsAssignedField && !fieldIsStatic || ((GlacierAnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(ownerAnnotationMirror, ((GlacierAnnotatedTypeFactory)this.atypeFactory).MAYBE_MUTABLE))) {
                    this.checker.report(Result.failure((String)"glacier.assignment", (Object[])new Object[0]), (Object)node);
                }
            }
        } else if (variable.getKind() == Tree.Kind.ARRAY_ACCESS) {
            ArrayAccessTree arrayAccessTree = (ArrayAccessTree)variable;
            AnnotatedTypeMirror arrayType = ((GlacierAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(arrayAccessTree.getExpression());
            AnnotationMirror arrayTypeAnnotation = arrayType.getAnnotationInHierarchy(((GlacierAnnotatedTypeFactory)this.atypeFactory).READ_ONLY);
            if (!((GlacierAnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().isSubtype(arrayTypeAnnotation, ((GlacierAnnotatedTypeFactory)this.atypeFactory).MAYBE_MUTABLE)) {
                this.checker.report(Result.failure((String)"glacier.assignment.array", (Object[])new Object[0]), (Object)node);
            }
        }
        return null;
    }

    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedDeclaredType declarationType, AnnotatedTypeMirror.AnnotatedDeclaredType useType, Tree tree) {
        if (useType.hasAnnotation(GlacierBottom.class)) {
            return false;
        }
        if (TypesUtils.isObject((TypeMirror)declarationType.getUnderlyingType())) {
            return true;
        }
        AnnotationMirror immutableAnnotation = AnnotationUtils.fromClass((Elements)this.elements, Immutable.class);
        AnnotationMirror useAnnotation = useType.getAnnotationInHierarchy(immutableAnnotation);
        if (useAnnotation != null) {
            return declarationType.hasAnnotation(useAnnotation);
        }
        return !declarationType.hasAnnotation(useAnnotation);
    }

    protected Set<? extends AnnotationMirror> getExceptionParameterLowerBoundAnnotations() {
        HashSet<AnnotationMirror> h = new HashSet<AnnotationMirror>(2);
        h.add(AnnotationUtils.fromClass((Elements)this.elements, GlacierBottom.class));
        return h;
    }

    protected Set<? extends AnnotationMirror> getThrowUpperBoundAnnotations() {
        return ((GlacierAnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy().getTopAnnotations();
    }

    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, AnnotatedTypeMirror valueType, Tree valueTree, String errorKey) {
        if (!TypesUtils.isObject((TypeMirror)varType.getUnderlyingType())) {
            super.commonAssignmentCheck(varType, valueType, valueTree, errorKey);
        }
    }

    protected void checkTypecastSafety(TypeCastTree node, Void p) {
    }

    protected void checkTypeArguments(Tree toptree, List<? extends AnnotatedTypeParameterBounds> paramBounds, List<? extends AnnotatedTypeMirror> typeargs, List<? extends Tree> typeargTrees) {
        super.checkTypeArguments(toptree, paramBounds, typeargs, typeargTrees);
        AnnotatedTypeMirror toptreeType = ((GlacierAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(toptree);
        if (toptreeType.hasAnnotation(Immutable.class) && (toptree.getKind() == Tree.Kind.CLASS || toptree.getKind() == Tree.Kind.PARAMETERIZED_TYPE)) {
            for (AnnotatedTypeMirror annotatedTypeMirror : typeargs) {
                if (annotatedTypeMirror.getKind() == TypeKind.TYPEVAR || annotatedTypeMirror.hasAnnotation(Immutable.class)) continue;
                boolean reportError = false;
                if (annotatedTypeMirror.getKind() == TypeKind.WILDCARD) {
                    AnnotatedTypeMirror.AnnotatedWildcardType annotatedWildcardType = (AnnotatedTypeMirror.AnnotatedWildcardType)annotatedTypeMirror;
                    AnnotatedTypeMirror extendsBound = annotatedWildcardType.getExtendsBound();
                    if (extendsBound.getKind() != TypeKind.TYPEVAR && !extendsBound.hasAnnotation(Immutable.class)) {
                        reportError = true;
                    }
                } else {
                    reportError = true;
                }
                if (!reportError) continue;
                this.checker.report(Result.failure((String)"glacier.typeparameter.mutable", (Object[])new Object[]{toptree, annotatedTypeMirror}), (Object)toptree);
            }
        }
    }

    protected boolean skipReceiverSubtypeCheck(MethodInvocationTree node, AnnotatedTypeMirror methodDefinitionReceiver, AnnotatedTypeMirror methodCallReceiver) {
        TypeMirror definitionType = methodDefinitionReceiver.getUnderlyingType();
        if (TypesUtils.isObject((TypeMirror)definitionType)) {
            return true;
        }
        if (definitionType instanceof DeclaredType) {
            DeclaredType declaredDefinitionType = (DeclaredType)definitionType;
            return TypesUtils.getQualifiedName((DeclaredType)declaredDefinitionType).contentEquals("java.lang.Enum");
        }
        return false;
    }

    protected boolean checkOverride(MethodTree overriderTree, AnnotatedTypeMirror.AnnotatedDeclaredType overridingType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType, Void p) {
        AnnotatedTypeMirror.AnnotatedExecutableType overrider = ((GlacierAnnotatedTypeFactory)this.atypeFactory).getAnnotatedType(overriderTree);
        if (overrider.getTypeVariables().isEmpty() && !overridden.getTypeVariables().isEmpty()) {
            overridden = overridden.getErased();
        }
        GlacierOverrideChecker overrideChecker = new GlacierOverrideChecker(overriderTree, overrider, (AnnotatedTypeMirror)overridingType, overrider.getReturnType(), overridden, overriddenType, overridden.getReturnType());
        return overrideChecker.checkOverride();
    }

    private Set<ContractsUtils.PreOrPostcondition> filterConditionalPostconditions(Set<ContractsUtils.ConditionalPostcondition> conditionalPostconditions, boolean b) {
        LinkedHashSet<ContractsUtils.PreOrPostcondition> result = new LinkedHashSet<ContractsUtils.PreOrPostcondition>();
        for (ContractsUtils.ConditionalPostcondition p : conditionalPostconditions) {
            if (p.annoResult != b) continue;
            result.add(new ContractsUtils.PreOrPostcondition(p.expression, p.annotationString));
        }
        return result;
    }

    private void checkContractsSubset(String overriderMeth, String overriderTyp, String overriddenMeth, String overriddenTyp, Set<Pair<FlowExpressions.Receiver, AnnotationMirror>> mustSubset, Set<Pair<FlowExpressions.Receiver, AnnotationMirror>> set, String messageKey) {
        for (Pair<FlowExpressions.Receiver, AnnotationMirror> a : mustSubset) {
            boolean found = false;
            for (Pair<FlowExpressions.Receiver, AnnotationMirror> b : set) {
                QualifierHierarchy qualifierHierarchy;
                if (!((FlowExpressions.Receiver)a.first).equals(b.first) || !(qualifierHierarchy = ((GlacierAnnotatedTypeFactory)this.atypeFactory).getQualifierHierarchy()).isSubtype((AnnotationMirror)a.second, (AnnotationMirror)b.second)) continue;
                found = true;
                break;
            }
            if (found) continue;
            MethodTree method = this.visitorState.getMethodTree();
            this.checker.report(Result.failure((String)messageKey, (Object[])new Object[]{overriderMeth, overriderTyp, overriddenMeth, overriddenTyp, a.second, a.first}), (Object)method);
        }
    }

    private Set<Pair<FlowExpressions.Receiver, AnnotationMirror>> resolveContracts(Set<ContractsUtils.PreOrPostcondition> contractSet, AnnotatedTypeMirror.AnnotatedExecutableType method) {
        HashSet<Pair<FlowExpressions.Receiver, AnnotationMirror>> result = new HashSet<Pair<FlowExpressions.Receiver, AnnotationMirror>>();
        MethodTree methodTree = this.visitorState.getMethodTree();
        TreePath path = ((GlacierAnnotatedTypeFactory)this.atypeFactory).getPath(methodTree);
        FlowExpressionParseUtil.FlowExpressionContext flowExprContext = null;
        for (ContractsUtils.PreOrPostcondition p : contractSet) {
            String expression = p.expression;
            AnnotationMirror annotation = AnnotationUtils.fromName((Elements)((GlacierAnnotatedTypeFactory)this.atypeFactory).getElementUtils(), (CharSequence)p.annotationString);
            if (!((GlacierAnnotatedTypeFactory)this.atypeFactory).isSupportedQualifier(annotation)) continue;
            if (flowExprContext == null) {
                flowExprContext = FlowExpressionParseUtil.FlowExpressionContext.buildContextForMethodDeclaration((MethodTree)methodTree, (TypeMirror)method.getReceiverType().getUnderlyingType(), (BaseContext)this.checker.getContext());
            }
            try {
                FlowExpressions.Receiver expr = FlowExpressionParseUtil.parse((String)expression, flowExprContext, (TreePath)path, (boolean)false);
                result.add((Pair<FlowExpressions.Receiver, AnnotationMirror>)Pair.of((Object)expr, (Object)annotation));
            }
            catch (FlowExpressionParseUtil.FlowExpressionParseException flowExpressionParseException) {}
        }
        return result;
    }

    private class GlacierOverrideChecker {
        private final String overriderMeth;
        private final String overriderTyp;
        private final String overriddenMeth;
        private final String overriddenTyp;
        private final Tree overriderTree;
        private final Boolean methodReference;
        private final AnnotatedTypeMirror.AnnotatedExecutableType overrider;
        private final AnnotatedTypeMirror overridingType;
        private final AnnotatedTypeMirror.AnnotatedExecutableType overridden;
        private final AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType;
        private final AnnotatedTypeMirror overriddenReturnType;
        private final AnnotatedTypeMirror overridingReturnType;

        GlacierOverrideChecker(Tree overriderTree, AnnotatedTypeMirror.AnnotatedExecutableType overrider, AnnotatedTypeMirror overridingType, AnnotatedTypeMirror overridingReturnType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType, AnnotatedTypeMirror overriddenReturnType) {
            this.overriderTree = overriderTree;
            this.overrider = overrider;
            this.overridingType = overridingType;
            this.overridden = overridden;
            this.overriddenType = overriddenType;
            this.overriddenReturnType = overriddenReturnType;
            this.overridingReturnType = overridingReturnType;
            this.overriderMeth = overrider.toString();
            if (overridingType.getKind() == TypeKind.DECLARED) {
                DeclaredType overriderTypeMirror = ((AnnotatedTypeMirror.AnnotatedDeclaredType)overridingType).getUnderlyingType();
                this.overriderTyp = overriderTypeMirror.asElement().toString();
            } else {
                this.overriderTyp = overridingType.toString();
            }
            this.overriddenMeth = overridden.toString();
            this.overriddenTyp = overriddenType.getUnderlyingType().asElement().toString();
            this.methodReference = overriderTree.getKind() == Tree.Kind.MEMBER_REFERENCE;
        }

        public boolean checkOverride() {
            if (GlacierVisitor.this.checker.shouldSkipUses(this.overriddenType.getUnderlyingType().asElement())) {
                return true;
            }
            boolean result = this.checkReturn();
            result &= this.checkParameters();
            result = this.methodReference.booleanValue() ? (result &= this.checkMemberReferenceReceivers()) : (result &= this.checkReceiverOverride());
            this.checkPreAndPostConditions();
            this.checkPurity();
            return result;
        }

        private void checkPurity() {
            String msgKey = this.methodReference != false ? "purity.invalid.methodref" : "purity.invalid.overriding";
            HashSet superPurity = new HashSet(PurityUtils.getPurityKinds((AnnotationProvider)GlacierVisitor.this.atypeFactory, (Element)this.overridden.getElement()));
            HashSet subPurity = new HashSet(PurityUtils.getPurityKinds((AnnotationProvider)GlacierVisitor.this.atypeFactory, (Element)this.overrider.getElement()));
            if (!subPurity.containsAll(superPurity)) {
                GlacierVisitor.this.checker.report(Result.failure((String)msgKey, (Object[])new Object[]{this.overriderMeth, this.overriderTyp, this.overriddenMeth, this.overriddenTyp, subPurity, superPurity}), (Object)this.overriderTree);
            }
        }

        private void checkPreAndPostConditions() {
            String msgKey;
            String string = msgKey = this.methodReference != false ? "methodref" : "override";
            if (this.methodReference.booleanValue()) {
                return;
            }
            ContractsUtils contracts = ContractsUtils.getInstance((GenericAnnotatedTypeFactory)GlacierVisitor.this.atypeFactory);
            Set superPost = contracts.getPostconditions(this.overridden.getElement());
            Set subPost = contracts.getPostconditions(this.overrider.getElement());
            Set superPost2 = GlacierVisitor.this.resolveContracts(superPost, this.overridden);
            Set subPost2 = GlacierVisitor.this.resolveContracts(subPost, this.overrider);
            String postmsg = "contracts.postcondition." + msgKey + ".invalid";
            GlacierVisitor.this.checkContractsSubset(this.overriderMeth, this.overriderTyp, this.overriddenMeth, this.overriddenTyp, superPost2, subPost2, postmsg);
            Set superPre = contracts.getPreconditions((Element)this.overridden.getElement());
            Set subPre = contracts.getPreconditions((Element)this.overrider.getElement());
            Set superPre2 = GlacierVisitor.this.resolveContracts(superPre, this.overridden);
            Set subPre2 = GlacierVisitor.this.resolveContracts(subPre, this.overrider);
            String premsg = "contracts.precondition." + msgKey + ".invalid";
            GlacierVisitor.this.checkContractsSubset(this.overriderMeth, this.overriderTyp, this.overriddenMeth, this.overriddenTyp, subPre2, superPre2, premsg);
            Set superCPost = contracts.getConditionalPostconditions(this.overridden.getElement());
            Set subCPost = contracts.getConditionalPostconditions(this.overrider.getElement());
            Set superCPostTrue = GlacierVisitor.this.filterConditionalPostconditions(superCPost, true);
            Set subCPostTrue = GlacierVisitor.this.filterConditionalPostconditions(subCPost, true);
            Set superCPostTrue2 = GlacierVisitor.this.resolveContracts(superCPostTrue, this.overridden);
            Set subCPostTrue2 = GlacierVisitor.this.resolveContracts(subCPostTrue, this.overrider);
            String posttruemsg = "contracts.conditional.postcondition.true." + msgKey + ".invalid";
            GlacierVisitor.this.checkContractsSubset(this.overriderMeth, this.overriderTyp, this.overriddenMeth, this.overriddenTyp, superCPostTrue2, subCPostTrue2, posttruemsg);
            Set superCPostFalse = GlacierVisitor.this.filterConditionalPostconditions(superCPost, false);
            Set subCPostFalse = GlacierVisitor.this.filterConditionalPostconditions(subCPost, false);
            Set superCPostFalse2 = GlacierVisitor.this.resolveContracts(superCPostFalse, this.overridden);
            Set subCPostFalse2 = GlacierVisitor.this.resolveContracts(subCPostFalse, this.overrider);
            String postfalsemsg = "contracts.conditional.postcondition.false." + msgKey + ".invalid";
            GlacierVisitor.this.checkContractsSubset(this.overriderMeth, this.overriderTyp, this.overriddenMeth, this.overriddenTyp, superCPostFalse2, subCPostFalse2, postfalsemsg);
        }

        private boolean checkMemberReferenceReceivers() {
            AnnotatedTypeMirror receiverArg;
            AnnotatedTypeMirror.AnnotatedDeclaredType receiverDecl;
            JCTree.JCMemberReference memberTree = (JCTree.JCMemberReference)this.overriderTree;
            if (this.overridingType.getKind() == TypeKind.ARRAY) {
                return true;
            }
            if (memberTree.kind == JCTree.JCMemberReference.ReferenceKind.UNBOUND) {
                AnnotatedTypeMirror.AnnotatedDeclaredType overriderReceiver = this.overrider.getReceiverType();
                AnnotatedTypeMirror overriddenReceiver = (AnnotatedTypeMirror)this.overridden.getParameterTypes().get(0);
                boolean success = ((GlacierAnnotatedTypeFactory)GlacierVisitor.this.atypeFactory).getTypeHierarchy().isSubtype(overriddenReceiver, (AnnotatedTypeMirror)overriderReceiver);
                if (!success) {
                    GlacierVisitor.this.checker.report(Result.failure((String)"methodref.receiver.invalid", (Object[])new Object[]{this.overriderMeth, this.overriderTyp, this.overriddenMeth, this.overriddenTyp, overriderReceiver, overriddenReceiver}), (Object)this.overriderTree);
                }
                return success;
            }
            switch (memberTree.kind) {
                case UNBOUND: {
                    ErrorReporter.errorAbort((String)"Case UNBOUND should already be handled.");
                    return true;
                }
                case SUPER: {
                    receiverDecl = this.overrider.getReceiverType();
                    receiverArg = ((GlacierAnnotatedTypeFactory)GlacierVisitor.this.atypeFactory).getAnnotatedType(memberTree.getQualifierExpression());
                    AnnotatedTypeMirror.AnnotatedDeclaredType selfType = ((GlacierAnnotatedTypeFactory)GlacierVisitor.this.atypeFactory).getSelfType(memberTree);
                    receiverArg.replaceAnnotations((Iterable)selfType.getAnnotations());
                    break;
                }
                case BOUND: {
                    receiverDecl = this.overrider.getReceiverType();
                    receiverArg = this.overridingType;
                    break;
                }
                case IMPLICIT_INNER: {
                    receiverDecl = this.overrider.getReceiverType();
                    receiverArg = ((GlacierAnnotatedTypeFactory)GlacierVisitor.this.atypeFactory).getSelfType(memberTree);
                    break;
                }
                default: {
                    return true;
                }
            }
            boolean success = ((GlacierAnnotatedTypeFactory)GlacierVisitor.this.atypeFactory).getTypeHierarchy().isSubtype(receiverArg, (AnnotatedTypeMirror)receiverDecl);
            if (!success) {
                GlacierVisitor.this.checker.report(Result.failure((String)"methodref.receiver.bound.invalid", (Object[])new Object[]{receiverArg, this.overriderMeth, this.overriderTyp, receiverArg, receiverDecl}), (Object)this.overriderTree);
            }
            return success;
        }

        private boolean checkReceiverOverride() {
            return true;
        }

        private boolean checkParameters() {
            boolean result = true;
            List overriderParams = this.overrider.getParameterTypes();
            ArrayList<AnnotatedTypeMirror> overriddenParams = this.overridden.getParameterTypes();
            if (this.methodReference.booleanValue() && ((JCTree.JCMemberReference)this.overriderTree).hasKind(JCTree.JCMemberReference.ReferenceKind.UNBOUND)) {
                overriddenParams = new ArrayList<AnnotatedTypeMirror>(overriddenParams);
                overriddenParams.remove(0);
            }
            for (int i = 0; i < overriderParams.size(); ++i) {
                boolean success = ((GlacierAnnotatedTypeFactory)GlacierVisitor.this.atypeFactory).getTypeHierarchy().isSubtype((AnnotatedTypeMirror)overriddenParams.get(i), (AnnotatedTypeMirror)overriderParams.get(i));
                if (!success) {
                    success = GlacierVisitor.this.testTypevarContainment((AnnotatedTypeMirror)overriddenParams.get(i), (AnnotatedTypeMirror)overriderParams.get(i));
                }
                this.checkParametersMsg(success, i, overriderParams, overriddenParams);
                result &= success;
            }
            return result;
        }

        private void checkParametersMsg(boolean success, int index, List<AnnotatedTypeMirror> overriderParams, List<AnnotatedTypeMirror> overriddenParams) {
            Tree posTree;
            String msgKey = this.methodReference != false ? "methodref.param.invalid" : "override.param.invalid";
            long valuePos = this.overriderTree instanceof MethodTree ? GlacierVisitor.this.positions.getStartPosition(GlacierVisitor.this.root, ((MethodTree)this.overriderTree).getParameters().get(index)) : GlacierVisitor.this.positions.getStartPosition(GlacierVisitor.this.root, this.overriderTree);
            Tree tree = posTree = this.overriderTree instanceof MethodTree ? (Tree)((MethodTree)this.overriderTree).getParameters().get(index) : this.overriderTree;
            if (GlacierVisitor.this.checker.hasOption("showchecks")) {
                System.out.printf(" %s (line %3d):%n     overrider: %s %s (parameter %d type %s)%n   overridden: %s %s (parameter %d type %s)%n", success ? "success: overridden parameter type is subtype of overriding" : "FAILURE: overridden parameter type is not subtype of overriding", GlacierVisitor.this.root.getLineMap() != null ? GlacierVisitor.this.root.getLineMap().getLineNumber(valuePos) : -1L, this.overriderMeth, this.overriderTyp, index, overriderParams.get(index).toString(), this.overriddenMeth, this.overriddenTyp, index, overriddenParams.get(index).toString());
            }
            if (!success) {
                GlacierVisitor.this.checker.report(Result.failure((String)msgKey, (Object[])new Object[]{this.overriderMeth, this.overriderTyp, this.overriddenMeth, this.overriddenTyp, overriderParams.get(index).toString(), overriddenParams.get(index).toString()}), (Object)posTree);
            }
        }

        private boolean checkReturn() {
            boolean success = true;
            if (this.overridingReturnType.getKind() != TypeKind.VOID) {
                TypeHierarchy typeHierarchy = ((GlacierAnnotatedTypeFactory)GlacierVisitor.this.atypeFactory).getTypeHierarchy();
                success = typeHierarchy.isSubtype(this.overridingReturnType, this.overriddenReturnType);
                if (!success && !(success = GlacierVisitor.this.testTypevarContainment(this.overridingReturnType, this.overriddenReturnType)) && this.methodReference.booleanValue()) {
                    boolean isCaptureConverted;
                    boolean bl = isCaptureConverted = this.overriddenReturnType.getKind() == TypeKind.TYPEVAR && InternalUtils.isCaptured((TypeVariable)((TypeVariable)this.overriddenReturnType.getUnderlyingType()));
                    if (this.methodReference.booleanValue() && isCaptureConverted) {
                        boolean isFunctionApply;
                        ExecutableElement overridenMethod = this.overridden.getElement();
                        boolean bl2 = isFunctionApply = overridenMethod.getSimpleName().toString().equals("apply") && overridenMethod.getEnclosingElement().toString().equals("java.util.function.Function");
                        if (isFunctionApply) {
                            AnnotatedTypeMirror overridingUpperBound = ((AnnotatedTypeMirror.AnnotatedTypeVariable)this.overriddenReturnType).getUpperBound();
                            success = typeHierarchy.isSubtype(this.overridingReturnType, overridingUpperBound);
                        }
                    }
                }
                this.checkReturnMsg(success);
            }
            return success;
        }

        private void checkReturnMsg(boolean success) {
            Tree posTree;
            String msgKey = this.methodReference != false ? "methodref.return.invalid" : "override.return.invalid";
            long valuePos = this.overriderTree instanceof MethodTree ? GlacierVisitor.this.positions.getStartPosition(GlacierVisitor.this.root, ((MethodTree)this.overriderTree).getReturnType()) : GlacierVisitor.this.positions.getStartPosition(GlacierVisitor.this.root, this.overriderTree);
            Tree tree = posTree = this.overriderTree instanceof MethodTree ? ((MethodTree)this.overriderTree).getReturnType() : this.overriderTree;
            if (posTree == null) {
                posTree = this.overriderTree;
            }
            if (GlacierVisitor.this.checker.hasOption("showchecks")) {
                System.out.printf(" %s (line %3d):%n     overrider: %s %s (return type %s)%n   overridden: %s %s (return type %s)%n", success ? "success: overriding return type is subtype of overridden" : "FAILURE: overriding return type is not subtype of overridden", GlacierVisitor.this.root.getLineMap() != null ? GlacierVisitor.this.root.getLineMap().getLineNumber(valuePos) : -1L, this.overriderMeth, this.overriderTyp, this.overrider.getReturnType().toString(), this.overriddenMeth, this.overriddenTyp, this.overridden.getReturnType().toString());
            }
            if (!success) {
                GlacierVisitor.this.checker.report(Result.failure((String)msgKey, (Object[])new Object[]{this.overriderMeth, this.overriderTyp, this.overriddenMeth, this.overriddenTyp, this.overridingReturnType, this.overriddenReturnType}), (Object)posTree);
            }
        }
    }
}

