/*
 * Decompiled with CFR 0.152.
 */
package afu.de.regnis.q.sequence.core;

import afu.de.regnis.q.sequence.core.QSequenceAssert;
import afu.de.regnis.q.sequence.core.QSequenceException;
import afu.de.regnis.q.sequence.core.QSequenceMedia;
import afu.de.regnis.q.sequence.core.QSequenceMiddleSnakeFinder;
import afu.de.regnis.q.sequence.core.QSequenceRestrictedMedia;
import afu.de.regnis.q.sequence.core.QSequenceSnakeRegister;

public class QSequenceAlgorithm {
    public static final boolean ASSERTIONS = true;
    private final QSequenceMedia mainMedia;
    private final QSequenceSnakeRegister snakeRegister;
    private final QSequenceMiddleSnakeFinder finder;

    public QSequenceAlgorithm(QSequenceMedia media, QSequenceSnakeRegister snakeRegister, int maximumSearchDepth) {
        QSequenceAssert.assertTrue(maximumSearchDepth >= 2);
        this.mainMedia = media;
        this.snakeRegister = snakeRegister;
        this.finder = new QSequenceMiddleSnakeFinder(media.getLeftLength(), media.getRightLength(), maximumSearchDepth);
    }

    public void produceSnakesInOrder() throws QSequenceException {
        QSequenceRestrictedMedia media = new QSequenceRestrictedMedia(this.mainMedia);
        this.produceSnakesInOrder(media);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void produceSnakesInOrder(QSequenceRestrictedMedia media) throws QSequenceException {
        int leftLength = media.getLeftLength();
        int rightLength = media.getRightLength();
        if (leftLength < 1 || rightLength < 1) {
            return;
        }
        int dee = this.finder.determineMiddleSnake(media);
        if (dee <= 0) {
            this.registerSnake(media, 1, leftLength, 1, rightLength);
            return;
        }
        int leftFrom = this.finder.getResult().getLeftFrom();
        int rightFrom = this.finder.getResult().getRightFrom();
        int leftTo = this.finder.getResult().getLeftTo();
        int rightTo = this.finder.getResult().getRightTo();
        if (dee == 1) {
            if (rightLength == leftLength + 1) {
                this.registerSnake(media, 1, leftFrom, 1, rightFrom - 1);
                this.registerSnake(media, leftFrom + 1, leftTo, rightFrom + 1, rightTo);
            } else if (leftLength == rightLength + 1) {
                this.registerSnake(media, 1, leftFrom - 1, 1, rightFrom);
                this.registerSnake(media, leftFrom + 1, leftTo, rightFrom + 1, rightTo);
            } else {
                QSequenceAssert.assertTrue(false);
            }
            return;
        }
        int leftMin = media.getLeftMin();
        int rightMin = media.getRightMin();
        int leftMax = media.getLeftMax();
        int rightMax = media.getRightMax();
        try {
            media.restrictTo(leftMin, leftMin + leftFrom - 1, rightMin, rightMin + rightFrom - 1);
            this.produceSnakesInOrder(media);
            media.restrictTo(leftMin, leftMax, rightMin, rightMax);
            this.registerSnake(media, leftFrom + 1, leftTo, rightFrom + 1, rightTo);
            media.restrictTo(leftMin + leftTo - 1 + 1, leftMax, rightMin + rightTo - 1 + 1, rightMax);
            this.produceSnakesInOrder(media);
        }
        finally {
            media.restrictTo(leftMin, leftMax, rightMin, rightMax);
        }
    }

    private void registerSnake(QSequenceRestrictedMedia media, int leftFrom, int leftTo, int rightFrom, int rightTo) throws QSequenceException {
        QSequenceAssert.assertTrue(leftTo - leftFrom == rightTo - rightFrom);
        if (leftFrom > leftTo || rightFrom > rightTo) {
            return;
        }
        for (int index = 0; index < leftTo - leftFrom; ++index) {
            QSequenceAssert.assertTrue(media.equals(leftFrom + index, rightFrom + index));
        }
        leftFrom = media.getLeftMin() + leftFrom - 1;
        leftTo = media.getLeftMin() + leftTo - 1;
        rightFrom = media.getRightMin() + rightFrom - 1;
        rightTo = media.getRightMin() + rightTo - 1;
        this.snakeRegister.registerSnake(leftFrom - 1, leftTo - 1, rightFrom - 1, rightTo - 1);
    }
}

