/*
 * Decompiled with CFR 0.152.
 */
package afu.de.regnis.q.sequence.line;

import afu.de.regnis.q.sequence.core.QSequenceAssert;
import afu.de.regnis.q.sequence.line.QSequenceLineFileSystemCacheSegment;
import afu.de.regnis.q.sequence.line.QSequenceLineRandomAccessFileFactory;
import afu.de.regnis.q.sequence.line.QSequenceLineTempDirectoryFactory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

class QSequenceLineFileSystemCacheSegments {
    private final QSequenceLineTempDirectoryFactory tempDirectoryFactory;
    private final int maximumEntriesPerSegment;
    private final int maximumSegmentsInMemory;
    private final List segments;
    private final List memorySegments;
    private File filePath;
    private RandomAccessFile file;

    public QSequenceLineFileSystemCacheSegments(QSequenceLineTempDirectoryFactory tempDirectoryFactory, int maximumBytesInMemory, int segmentBytesSize) {
        QSequenceAssert.assertTrue(segmentBytesSize >= 16);
        QSequenceAssert.assertTrue(maximumBytesInMemory >= segmentBytesSize);
        this.tempDirectoryFactory = tempDirectoryFactory;
        this.maximumEntriesPerSegment = segmentBytesSize / 16;
        this.maximumSegmentsInMemory = maximumBytesInMemory / (this.maximumEntriesPerSegment * 16);
        this.segments = new ArrayList();
        this.memorySegments = new LinkedList();
        QSequenceLineFileSystemCacheSegment segment = new QSequenceLineFileSystemCacheSegment(0L, this.maximumEntriesPerSegment);
        this.segments.add(segment);
        this.memorySegments.add(segment);
    }

    public long getFrom(int index) throws IOException {
        int segmentIndex = index / this.maximumEntriesPerSegment;
        int relativeIndex = index % this.maximumEntriesPerSegment;
        return this.getSegment(segmentIndex).getFrom(relativeIndex);
    }

    public int getLength(int index) throws IOException {
        int segmentIndex = index / this.maximumEntriesPerSegment;
        int relativeIndex = index % this.maximumEntriesPerSegment;
        return this.getSegment(segmentIndex).getLength(relativeIndex);
    }

    public int getHash(int index) throws IOException {
        int segmentIndex = index / this.maximumEntriesPerSegment;
        int relativeIndex = index % this.maximumEntriesPerSegment;
        return this.getSegment(segmentIndex).getHash(relativeIndex);
    }

    public void setFromLengthHash(int index, long from, int length, int hash) throws IOException {
        int segmentIndex = index / this.maximumEntriesPerSegment;
        int relativeIndex = index % this.maximumEntriesPerSegment;
        QSequenceLineFileSystemCacheSegment segment = this.getSegment(segmentIndex);
        segment.setFromLengthHash(relativeIndex, from, length, hash);
    }

    public void close() throws IOException {
        if (this.file == null) {
            return;
        }
        this.file.close();
        this.filePath.delete();
        this.tempDirectoryFactory.close();
    }

    private QSequenceLineFileSystemCacheSegment getSegment(int segmentIndex) throws IOException {
        if (segmentIndex >= this.segments.size()) {
            QSequenceLineFileSystemCacheSegment segment = new QSequenceLineFileSystemCacheSegment(segmentIndex, this.maximumEntriesPerSegment);
            this.segments.add(segment);
            this.memorySegments.add(0, segment);
            this.maybeUnloadSegments();
            return segment;
        }
        QSequenceLineFileSystemCacheSegment segment = (QSequenceLineFileSystemCacheSegment)this.segments.get(segmentIndex);
        if (!segment.isLoaded()) {
            segment.load(this.getFile());
            this.memorySegments.add(0, segment);
            this.maybeUnloadSegments();
        }
        return segment;
    }

    private void maybeUnloadSegments() throws IOException {
        while (this.memorySegments.size() > this.maximumSegmentsInMemory) {
            QSequenceLineFileSystemCacheSegment segment = (QSequenceLineFileSystemCacheSegment)this.memorySegments.remove(this.memorySegments.size() - 1);
            segment.unload(this.getFile());
        }
    }

    private RandomAccessFile getFile() throws IOException {
        if (this.file == null) {
            File tempDirectory = this.tempDirectoryFactory.getTempDirectory();
            if (!tempDirectory.isDirectory()) {
                tempDirectory.mkdirs();
            }
            this.filePath = File.createTempFile("sequence", null, tempDirectory);
            this.file = QSequenceLineRandomAccessFileFactory.createRandomAccessFile(this.filePath, "rw");
        }
        return this.file;
    }
}

