/*
 * Decompiled with CFR 0.152.
 */
package afu.de.regnis.q.sequence.line.diff;

import afu.de.regnis.q.sequence.QSequenceDifferenceBlock;
import afu.de.regnis.q.sequence.core.QSequenceException;
import afu.de.regnis.q.sequence.line.QSequenceLine;
import afu.de.regnis.q.sequence.line.QSequenceLineCache;
import afu.de.regnis.q.sequence.line.QSequenceLineMedia;
import afu.de.regnis.q.sequence.line.QSequenceLineRAByteData;
import afu.de.regnis.q.sequence.line.QSequenceLineRAData;
import afu.de.regnis.q.sequence.line.QSequenceLineRAFileData;
import afu.de.regnis.q.sequence.line.QSequenceLineResult;
import afu.de.regnis.q.sequence.line.diff.QDiffGenerator;
import afu.de.regnis.q.sequence.line.simplifier.QSequenceLineDummySimplifier;
import afu.de.regnis.q.sequence.line.simplifier.QSequenceLineEOLUnifyingSimplifier;
import afu.de.regnis.q.sequence.line.simplifier.QSequenceLineSimplifier;
import afu.de.regnis.q.sequence.line.simplifier.QSequenceLineTeeSimplifier;
import afu.de.regnis.q.sequence.line.simplifier.QSequenceLineWhiteSpaceReducingSimplifier;
import afu.de.regnis.q.sequence.line.simplifier.QSequenceLineWhiteSpaceSkippingSimplifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class QDiffSequenceGenerator
implements QDiffGenerator {
    private final String header;
    private Map myProperties;

    protected abstract void processBlock(QSequenceDifferenceBlock[] var1, QSequenceLineCache var2, QSequenceLineCache var3, String var4, Writer var5) throws IOException;

    protected abstract void processBlock(QSequenceDifferenceBlock[] var1, QSequenceLineCache var2, QSequenceLineCache var3, OutputStream var4) throws IOException;

    protected QDiffSequenceGenerator(Map properties, String header) {
        this.header = header;
        this.myProperties = properties == null ? Collections.EMPTY_MAP : properties;
        this.myProperties = Collections.unmodifiableMap(this.myProperties);
    }

    public void generateBinaryDiff(InputStream left, InputStream right, String encoding, Writer output) throws IOException {
        this.println("Binary files are different", output);
    }

    public void generateTextDiff(InputStream left, InputStream right, String encoding, Writer output) throws IOException {
        this.generateTextDiff(QSequenceLineRAByteData.create(left), QSequenceLineRAByteData.create(right), encoding, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateTextDiff(QSequenceLineRAData left, QSequenceLineRAData right, String encoding, Writer output) throws IOException {
        QSequenceLineResult result;
        try {
            result = QSequenceLineMedia.createBlocks(left, right, this.getSimplifier());
        }
        catch (QSequenceException ex) {
            throw new IOException(ex.getMessage());
        }
        try {
            List combinedBlocks = QDiffSequenceGenerator.combineBlocks(result.getBlocks(), this.getGutter());
            boolean headerWritten = false;
            Iterator it = combinedBlocks.iterator();
            while (it.hasNext()) {
                List segment = (List)it.next();
                if (segment.isEmpty()) continue;
                if (!headerWritten && this.header != null) {
                    headerWritten = true;
                    output.write(this.header);
                }
                QSequenceDifferenceBlock[] segmentBlocks = segment.toArray(new QSequenceDifferenceBlock[segment.size()]);
                this.processBlock(segmentBlocks, result.getLeftCache(), result.getRightCache(), encoding, output);
            }
        }
        finally {
            result.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateTextDiff(QSequenceLineRAData left, QSequenceLineRAData right, OutputStream output) throws IOException {
        QSequenceLineResult result;
        try {
            result = QSequenceLineMedia.createBlocks(left, right, this.getSimplifier());
        }
        catch (QSequenceException ex) {
            throw new IOException(ex.getMessage());
        }
        try {
            List combinedBlocks = QDiffSequenceGenerator.combineBlocks(result.getBlocks(), this.getGutter());
            boolean headerWritten = false;
            Iterator it = combinedBlocks.iterator();
            while (it.hasNext()) {
                List segment = (List)it.next();
                if (segment.isEmpty()) continue;
                if (!headerWritten && this.header != null) {
                    headerWritten = true;
                    output.write(this.header.getBytes("UTF-8"));
                }
                QSequenceDifferenceBlock[] segmentBlocks = segment.toArray(new QSequenceDifferenceBlock[segment.size()]);
                this.processBlock(segmentBlocks, result.getLeftCache(), result.getRightCache(), output);
            }
        }
        finally {
            result.close();
        }
    }

    public void generateTextDiff(RandomAccessFile left, RandomAccessFile right, String encoding, Writer output) throws IOException {
        QSequenceLineRAData leftData = null;
        QSequenceLineRAData rightData = null;
        leftData = left == null ? new QSequenceLineRAByteData(new byte[0]) : new QSequenceLineRAFileData(left);
        rightData = right == null ? new QSequenceLineRAByteData(new byte[0]) : new QSequenceLineRAFileData(right);
        this.generateTextDiff(leftData, rightData, encoding, output);
    }

    public void generateTextDiff(RandomAccessFile left, RandomAccessFile right, OutputStream output) throws IOException {
        QSequenceLineRAData leftData = null;
        QSequenceLineRAData rightData = null;
        leftData = left == null ? new QSequenceLineRAByteData(new byte[0]) : new QSequenceLineRAFileData(left);
        rightData = right == null ? new QSequenceLineRAByteData(new byte[0]) : new QSequenceLineRAFileData(right);
        this.generateTextDiff(leftData, rightData, output);
    }

    protected Map getProperties() {
        return this.myProperties;
    }

    protected String getHunkDelimiter() {
        Object hunkDelimiter = this.getProperties().get("hunk-delimiter");
        if (hunkDelimiter != null && hunkDelimiter instanceof String) {
            return (String)hunkDelimiter;
        }
        return "@@";
    }

    protected String getEOL() {
        if (this.getProperties().get("eol") instanceof String) {
            return (String)this.getProperties().get("eol");
        }
        return System.getProperty("line.separator", "\n");
    }

    protected QSequenceLineSimplifier getSimplifier() {
        Object ignore = this.getProperties().get("ignore-space");
        QSequenceLineSimplifier baseSimplifier = "all-space".equals(ignore) ? new QSequenceLineWhiteSpaceSkippingSimplifier() : ("space-change".equals(ignore) ? new QSequenceLineWhiteSpaceReducingSimplifier() : new QSequenceLineDummySimplifier());
        if (this.getProperties().containsKey("ignore-eol-style")) {
            return new QSequenceLineTeeSimplifier(baseSimplifier, new QSequenceLineEOLUnifyingSimplifier());
        }
        return baseSimplifier;
    }

    protected int getGutter() {
        Object gutterStr = this.getProperties().get("gutter");
        if (gutterStr == null) {
            return 0;
        }
        try {
            return Integer.parseInt(gutterStr.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    protected String printLine(QSequenceLine line, String encoding) throws IOException {
        String str = new String(line.getContentBytes(), encoding);
        return str;
    }

    protected void println(Writer output) throws IOException {
        output.write(this.getEOL());
    }

    protected void println(OutputStream output) throws IOException {
        output.write(this.getEOL().getBytes("UTF-8"));
    }

    protected void println(String str, Writer output) throws IOException {
        if (str != null) {
            output.write(str);
        }
        output.write(this.getEOL());
    }

    protected void println(String str, OutputStream output) throws IOException {
        if (str != null) {
            output.write(str.getBytes("UTF-8"));
        }
        output.write(this.getEOL().getBytes("UTF-8"));
    }

    protected void print(String str, Writer output) throws IOException {
        if (str != null) {
            output.write(str);
        }
    }

    protected void print(String str, OutputStream output) throws IOException {
        if (str != null) {
            output.write(str.getBytes("UTF-8"));
        }
    }

    private static List combineBlocks(List blocksList, int gutter) {
        LinkedList combinedBlocks = new LinkedList();
        LinkedList<QSequenceDifferenceBlock> currentList = new LinkedList<QSequenceDifferenceBlock>();
        QSequenceDifferenceBlock lastBlock = null;
        Iterator blocks = blocksList.iterator();
        while (blocks.hasNext()) {
            QSequenceDifferenceBlock currentBlock = (QSequenceDifferenceBlock)blocks.next();
            if (lastBlock != null) {
                int leftDifference = currentBlock.getLeftFrom() - 1 - lastBlock.getLeftTo();
                int rightDifference = currentBlock.getRightFrom() - 1 - lastBlock.getRightTo();
                if (leftDifference > 2 * gutter && rightDifference > 2 * gutter) {
                    combinedBlocks.add(currentList);
                    currentList = new LinkedList();
                }
            }
            currentList.add(currentBlock);
            lastBlock = currentBlock;
        }
        if (!combinedBlocks.contains(currentList)) {
            combinedBlocks.add(currentList);
        }
        return combinedBlocks;
    }
}

