/*
 * Decompiled with CFR 0.152.
 */
package afu.net.fortuna.ical4j.model;

import afu.net.fortuna.ical4j.model.Parameter;
import afu.net.fortuna.ical4j.model.Property;
import afu.net.fortuna.ical4j.model.PropertyList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IndexedPropertyList {
    private static final PropertyList EMPTY_LIST = new PropertyList();
    private Map index;

    public IndexedPropertyList(PropertyList list, String parameterName) {
        HashMap<String, PropertyList> indexedProperties = new HashMap<String, PropertyList>();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Property property = (Property)i.next();
            Iterator j = property.getParameters(parameterName).iterator();
            while (j.hasNext()) {
                Parameter parameter = (Parameter)j.next();
                PropertyList properties = (PropertyList)indexedProperties.get(parameter.getValue());
                if (properties == null) {
                    properties = new PropertyList();
                    indexedProperties.put(parameter.getValue(), properties);
                }
                properties.add(property);
            }
        }
        this.index = Collections.unmodifiableMap(indexedProperties);
    }

    public PropertyList getProperties(String paramValue) {
        PropertyList properties = (PropertyList)this.index.get(paramValue);
        if (properties == null) {
            properties = EMPTY_LIST;
        }
        return properties;
    }

    public Property getProperty(String paramValue) {
        PropertyList properties = this.getProperties(paramValue);
        if (!properties.isEmpty()) {
            return (Property)properties.iterator().next();
        }
        return null;
    }
}

