/*
 * Decompiled with CFR 0.152.
 */
package afu.net.fortuna.ical4j.model.property;

import afu.net.fortuna.ical4j.model.ParameterList;
import afu.net.fortuna.ical4j.model.Property;
import afu.net.fortuna.ical4j.model.PropertyFactoryImpl;
import afu.net.fortuna.ical4j.model.ValidationException;
import afu.net.fortuna.ical4j.util.ParameterValidator;
import java.util.StringTokenizer;

public class RequestStatus
extends Property {
    private static final long serialVersionUID = -3273944031884755345L;
    public static final String PRELIM_SUCCESS = "1";
    public static final String SUCCESS = "2";
    public static final String CLIENT_ERROR = "3";
    public static final String SCHEDULING_ERROR = "4";
    private String statusCode;
    private String description;
    private String exData;

    public RequestStatus() {
        super("REQUEST-STATUS", PropertyFactoryImpl.getInstance());
    }

    public RequestStatus(ParameterList aList, String aValue) {
        super("REQUEST-STATUS", aList, PropertyFactoryImpl.getInstance());
        this.setValue(aValue);
    }

    public RequestStatus(String aStatusCode, String aDescription, String data) {
        super("REQUEST-STATUS", PropertyFactoryImpl.getInstance());
        this.statusCode = aStatusCode;
        this.description = aDescription;
        this.exData = data;
    }

    public RequestStatus(ParameterList aList, String aStatusCode, String aDescription, String data) {
        super("REQUEST-STATUS", aList, PropertyFactoryImpl.getInstance());
        this.statusCode = aStatusCode;
        this.description = aDescription;
        this.exData = data;
    }

    public final void validate() throws ValidationException {
        ParameterValidator.getInstance().assertOneOrLess("LANGUAGE", this.getParameters());
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getExData() {
        return this.exData;
    }

    public final String getStatusCode() {
        return this.statusCode;
    }

    public final void setValue(String aValue) {
        StringTokenizer t = new StringTokenizer(aValue, ";");
        if (t.hasMoreTokens()) {
            this.statusCode = t.nextToken();
        }
        if (t.hasMoreTokens()) {
            this.description = t.nextToken();
        }
        if (t.hasMoreTokens()) {
            this.exData = t.nextToken();
        }
    }

    public final String getValue() {
        StringBuffer b = new StringBuffer();
        if (this.getStatusCode() != null) {
            b.append(this.getStatusCode());
        }
        if (this.getDescription() != null) {
            b.append(';');
            b.append(this.getDescription());
        }
        if (this.getExData() != null) {
            b.append(';');
            b.append(this.getExData());
        }
        return b.toString();
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final void setExData(String exData) {
        this.exData = exData;
    }

    public final void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }
}

