/*
 * Decompiled with CFR 0.152.
 */
package afu.nu.xom;

import afu.nu.xom.Document;
import afu.nu.xom.NodeFactory;
import afu.nu.xom.NonVerifyingHandler;
import afu.nu.xom.ParsingException;
import afu.nu.xom.URIUtil;
import afu.nu.xom.ValidityException;
import afu.nu.xom.XML1_0Parser;
import afu.nu.xom.XMLException;
import afu.nu.xom.XOMHandler;
import afu.org.apache.xerces.impl.Version;
import afu.org.xml.sax.ContentHandler;
import afu.org.xml.sax.DTDHandler;
import afu.org.xml.sax.ErrorHandler;
import afu.org.xml.sax.InputSource;
import afu.org.xml.sax.SAXException;
import afu.org.xml.sax.SAXNotRecognizedException;
import afu.org.xml.sax.SAXNotSupportedException;
import afu.org.xml.sax.SAXParseException;
import afu.org.xml.sax.XMLFilter;
import afu.org.xml.sax.XMLReader;
import afu.org.xml.sax.helpers.XMLReaderFactory;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UTFDataFormatException;
import java.net.MalformedURLException;
import java.net.URL;

public class Builder {
    private XMLReader parser;
    private NodeFactory factory;
    private static double xercesVersion;
    private static String[] parsers;
    private static String fileURLPrefix;

    public Builder() {
        this(false);
    }

    public Builder(boolean bl) {
        this(Builder.findParser(bl), bl, null);
    }

    public Builder(boolean bl, NodeFactory nodeFactory) {
        this(Builder.findParser(bl), bl, nodeFactory);
    }

    static XMLReader findParser(boolean bl) {
        try {
            XML1_0Parser xML1_0Parser = new XML1_0Parser();
            Builder.setupParser((XMLReader)xML1_0Parser, bl);
            return xML1_0Parser;
        }
        catch (SAXException sAXException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        try {
            XMLReader xMLReader = (XMLReader)Class.forName("afu.nu.xom.JDK15XML1_0Parser").newInstance();
            Builder.setupParser(xMLReader, bl);
            return xMLReader;
        }
        catch (SAXException sAXException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        for (int i = 2; i < parsers.length; ++i) {
            try {
                XMLReader xMLReader = XMLReaderFactory.createXMLReader((String)parsers[i]);
                Builder.setupParser(xMLReader, bl);
                return xMLReader;
            }
            catch (SAXException sAXException) {
                continue;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            Builder.setupParser(xMLReader, bl);
            return xMLReader;
        }
        catch (SAXException sAXException) {
            throw new XMLException("Could not find a suitable SAX2 parser", sAXException);
        }
    }

    private static void setupParser(XMLReader xMLReader, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        Object object;
        xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
        XMLReader xMLReader2 = xMLReader;
        while (xMLReader2 instanceof XMLFilter && (object = ((XMLFilter)xMLReader2).getParent()) != null) {
            xMLReader2 = object;
        }
        object = xMLReader2.getClass().getName();
        if (!bl) {
            if (((String)object).equals("afu.org.apache.crimson.parser.XMLReaderImpl")) {
                xMLReader.setErrorHandler((ErrorHandler)new NamespaceWellformednessRequired());
            } else {
                xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", true);
                xMLReader.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
            }
        } else {
            xMLReader.setFeature("http://xml.org/sax/features/validation", true);
            xMLReader.setErrorHandler((ErrorHandler)new ValidityRequired());
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/string-interning", true);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        if (((String)object).equals("afu.nu.xom.XML1_0Parser") || ((String)object).equals("afu.nu.xom.JDK15XML1_0Parser") || ((String)object).equals("afu.org.apache.xerces.parsers.SAXParser") || ((String)object).equals("afu.com.sun.org.apache.xerces.internal.parsers.SAXParser") || ((String)object).equals("afu.org.apache.xerces.jaxp.SAXParserImpl$JAXPSAXParser") || ((String)object).equals("afu.com.sun.org.apache.xerces.internal.jaxp.SAXParserImpl$JAXPSAXParser")) {
            try {
                xMLReader.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            try {
                xMLReader.setFeature("http://apache.org/xml/features/standard-uri-conformant", true);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    public Builder(XMLReader xMLReader) {
        this(xMLReader, false);
    }

    public Builder(NodeFactory nodeFactory) {
        this(Builder.findParser(false), false, nodeFactory);
    }

    public Builder(XMLReader xMLReader, boolean bl) {
        this(xMLReader, bl, null);
    }

    public Builder(XMLReader xMLReader, boolean bl, NodeFactory nodeFactory) {
        try {
            Builder.setupParser(xMLReader, bl);
        }
        catch (SAXException sAXException) {
            if (bl) {
                throw new XMLException(xMLReader.getClass().getName() + " does not support validation.", sAXException);
            }
            throw new XMLException(xMLReader.getClass().getName() + " does not support the entity resolution" + " features XOM requires.", sAXException);
        }
        this.parser = xMLReader;
        this.factory = nodeFactory;
        this.setHandlers();
    }

    private static boolean knownGoodParser(XMLReader xMLReader) {
        String string = xMLReader.getClass().getName();
        if (string.equals("afu.org.apache.xml.resolver.tools.ResolvingXMLFilter")) {
            XMLFilter xMLFilter = (XMLFilter)xMLReader;
            string = xMLFilter.getParent().getClass().getName();
        }
        if (string.equals("gnu.xml.aelfred2.XmlReader")) {
            return false;
        }
        if (string.equals("afu.net.sf.saxon.aelfred.SAXDriver")) {
            return false;
        }
        if (string.equals("afu.com.icl.saxon.aelfred.SAXDriver")) {
            return false;
        }
        if (string.equals("afu.org.apache.xerces.parsers.SAXParser") && xercesVersion >= 2.4) {
            return false;
        }
        for (int i = 0; i < parsers.length; ++i) {
            if (!string.equals(parsers[i])) continue;
            return true;
        }
        return false;
    }

    private void setHandlers() {
        XOMHandler xOMHandler;
        if ((this.factory == null || this.factory.getClass().getName().equals("afu.nu.xom.NodeFactory")) && Builder.knownGoodParser(this.parser)) {
            NodeFactory nodeFactory = this.factory;
            if (nodeFactory == null) {
                nodeFactory = new NodeFactory();
            }
            xOMHandler = new NonVerifyingHandler(nodeFactory);
        } else {
            if (this.factory == null) {
                this.factory = new NodeFactory();
            }
            xOMHandler = new XOMHandler(this.factory);
        }
        this.parser.setContentHandler((ContentHandler)xOMHandler);
        this.parser.setDTDHandler((DTDHandler)xOMHandler);
        try {
            this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", (Object)xOMHandler);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            this.parser.setProperty("http://xml.org/sax/properties/declaration-handler", (Object)xOMHandler);
            if (this.parser.getClass().getName().equals("afu.org.apache.crimson.parser.XMLReaderImpl")) {
                xOMHandler.usingCrimson = true;
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public Document build(String string) throws ParsingException, ValidityException, IOException {
        string = this.canonicalizeURL(string);
        InputSource inputSource = new InputSource(string);
        return this.build(inputSource);
    }

    public Document build(InputStream inputStream) throws ParsingException, ValidityException, IOException {
        if (inputStream == null) {
            throw new NullPointerException("Null InputStream");
        }
        InputSource inputSource = new InputSource(inputStream);
        return this.build(inputSource);
    }

    public Document build(InputStream inputStream, String string) throws ParsingException, ValidityException, IOException {
        InputSource inputSource = new InputSource(inputStream);
        if (string != null) {
            string = this.canonicalizeURL(string);
            inputSource.setSystemId(string);
        }
        return this.build(inputSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document build(File file) throws ParsingException, ValidityException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        String string = file.getAbsolutePath();
        StringBuffer stringBuffer = new StringBuffer(fileURLPrefix);
        int n = string.length();
        char c = File.separatorChar;
        block102: for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                stringBuffer.append('/');
                continue;
            }
            switch (c2) {
                case ' ': {
                    stringBuffer.append("%20");
                    continue block102;
                }
                case '!': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '\"': {
                    stringBuffer.append("%22");
                    continue block102;
                }
                case '#': {
                    stringBuffer.append("%23");
                    continue block102;
                }
                case '$': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '%': {
                    stringBuffer.append("%25");
                    continue block102;
                }
                case '&': {
                    stringBuffer.append('&');
                    continue block102;
                }
                case '\'': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '(': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case ')': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '*': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '+': {
                    stringBuffer.append("%2B");
                    continue block102;
                }
                case ',': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '-': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '.': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '/': {
                    stringBuffer.append("%2F");
                    continue block102;
                }
                case '0': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '1': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '2': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '3': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '4': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '5': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '6': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '7': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '8': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '9': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case ':': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case ';': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '<': {
                    stringBuffer.append("%3C");
                    continue block102;
                }
                case '=': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '>': {
                    stringBuffer.append("%3E");
                    continue block102;
                }
                case '?': {
                    stringBuffer.append("%3F");
                    continue block102;
                }
                case '@': {
                    stringBuffer.append("%40");
                    continue block102;
                }
                case 'A': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'B': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'C': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'D': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'E': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'F': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'G': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'H': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'I': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'J': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'K': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'L': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'M': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'N': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'O': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'P': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'Q': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'R': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'S': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'T': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'U': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'V': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'W': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'X': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'Y': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'Z': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '[': {
                    stringBuffer.append("%5B");
                    continue block102;
                }
                case '\\': {
                    stringBuffer.append("%5C");
                    continue block102;
                }
                case ']': {
                    stringBuffer.append("%5D");
                    continue block102;
                }
                case '^': {
                    stringBuffer.append("%5E");
                    continue block102;
                }
                case '_': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '`': {
                    stringBuffer.append("%60");
                    continue block102;
                }
                case 'a': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'b': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'c': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'd': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'e': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'f': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'g': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'h': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'i': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'j': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'k': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'l': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'm': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'n': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'o': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'p': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'q': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'r': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 's': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 't': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'u': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'v': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'w': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'x': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'y': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case 'z': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                case '{': {
                    stringBuffer.append("%7B");
                    continue block102;
                }
                case '|': {
                    stringBuffer.append("%7C");
                    continue block102;
                }
                case '}': {
                    stringBuffer.append("%7D");
                    continue block102;
                }
                case '~': {
                    stringBuffer.append(c2);
                    continue block102;
                }
                default: {
                    if (c2 < '\ud800' || c2 > '\udfff') {
                        stringBuffer.append(URIUtil.percentEscape(c2));
                        continue block102;
                    }
                    if (c2 <= '\udbff') {
                        ++i;
                        try {
                            char c3 = string.charAt(i);
                            String string2 = String.valueOf(c2) + c3;
                            byte[] byArray = string2.getBytes("UTF8");
                            for (int j = 0; j < 4; ++j) {
                                stringBuffer.append('%');
                                String string3 = Integer.toHexString(byArray[j]).toUpperCase();
                                stringBuffer.append(string3.substring(string3.length() - 2));
                            }
                            continue block102;
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            stringBuffer = new StringBuffer(0);
                            continue block102;
                        }
                    }
                    stringBuffer = new StringBuffer(0);
                }
            }
        }
        String string4 = stringBuffer.toString();
        try {
            Document document;
            Document document2 = document = this.build(fileInputStream, string4);
            return document2;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public Document build(Reader reader) throws ParsingException, ValidityException, IOException {
        if (reader == null) {
            throw new NullPointerException("Attempted to build from null reader");
        }
        InputSource inputSource = new InputSource(reader);
        return this.build(inputSource);
    }

    public Document build(Reader reader, String string) throws ParsingException, ValidityException, IOException {
        InputSource inputSource = new InputSource(reader);
        if (string != null) {
            string = this.canonicalizeURL(string);
            inputSource.setSystemId(string);
        }
        return this.build(inputSource);
    }

    public Document build(String string, String string2) throws ParsingException, ValidityException, IOException {
        StringReader stringReader = new StringReader(string);
        return this.build(stringReader, string2);
    }

    private String canonicalizeURL(String string) {
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getPath();
            String string3 = uRL.getProtocol();
            String string4 = uRL.getHost();
            String string5 = uRL.getQuery();
            int n = uRL.getPort();
            if (string2 == null || string2.length() == 0) {
                string2 = "/";
            }
            string2 = URIUtil.removeDotSegments(string2);
            StringBuffer stringBuffer = new StringBuffer(string.length());
            stringBuffer.append(string3);
            stringBuffer.append("://");
            if (string4 != null) {
                stringBuffer.append(string4);
            }
            if (n >= 0) {
                stringBuffer.append(":" + n);
            }
            stringBuffer.append(string2);
            if (string5 != null) {
                stringBuffer.append("?" + string5);
            }
            return stringBuffer.toString();
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
    }

    private Document build(InputSource inputSource) throws ParsingException, ValidityException, IOException {
        ValidityRequired validityRequired;
        ErrorHandler errorHandler;
        XOMHandler xOMHandler = (XOMHandler)this.parser.getContentHandler();
        Document document = null;
        try {
            this.parser.parse(inputSource);
            document = xOMHandler.getDocument();
        }
        catch (SAXParseException sAXParseException) {
            ParsingException parsingException = new ParsingException(sAXParseException.getMessage(), sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException);
            throw parsingException;
        }
        catch (SAXException sAXException) {
            ParsingException parsingException = new ParsingException(sAXException.getMessage(), inputSource.getSystemId(), sAXException);
            throw parsingException;
        }
        catch (XMLException xMLException) {
            throw new ParsingException(xMLException.getMessage(), xMLException);
        }
        catch (RuntimeException runtimeException) {
            ParsingException parsingException = new ParsingException(runtimeException.getMessage(), inputSource.getSystemId(), runtimeException);
            throw parsingException;
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            ParsingException parsingException = new ParsingException(uTFDataFormatException.getMessage(), inputSource.getSystemId(), uTFDataFormatException);
            throw parsingException;
        }
        catch (CharConversionException charConversionException) {
            ParsingException parsingException = new ParsingException(charConversionException.getMessage(), inputSource.getSystemId(), charConversionException);
            throw parsingException;
        }
        catch (IOException iOException) {
            if (iOException.getClass().getName().equals("afu.org.apache.xerces.util.URI$MalformedURIException")) {
                throw new ParsingException(iOException.getMessage(), inputSource.getSystemId(), iOException);
            }
            throw iOException;
        }
        finally {
            xOMHandler.freeMemory();
        }
        if (document == null) {
            ParsingException parsingException = new ParsingException("Parser did not build document", inputSource.getSystemId(), -1, -1);
            throw parsingException;
        }
        if ("".equals(document.getBaseURI())) {
            document.setBaseURI(inputSource.getSystemId());
        }
        if ((errorHandler = this.parser.getErrorHandler()) instanceof ValidityRequired && !(validityRequired = (ValidityRequired)errorHandler).isValid()) {
            ValidityException validityException = validityRequired.vexception;
            validityException.setDocument(document);
            validityRequired.reset();
            throw validityException;
        }
        return document;
    }

    public NodeFactory getNodeFactory() {
        return this.factory;
    }

    static {
        String string;
        xercesVersion = 2.6;
        try {
            string = Version.getVersion();
            String string2 = string.substring(9);
            int n = string2.indexOf(".");
            int n2 = string2.lastIndexOf(".");
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1, n2);
            if (Integer.parseInt(string4) < 10 && Integer.parseInt(string3) < 3) {
                xercesVersion = Double.parseDouble(string.substring(9, 12));
            }
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        parsers = new String[]{"afu.nu.xom.XML1_0Parser", "afu.nu.xom.JDK15XML1_0Parser", "afu.org.apache.xerces.parsers.SAXParser", "afu.org.apache.xerces.jaxp.SAXParserImpl$JAXPSAXParser", "afu.com.sun.org.apache.xerces.internal.jaxp.SAXParserImpl$JAXPSAXParser", "afu.com.sun.org.apache.xerces.internal.parsers.SAXParser", "gnu.xml.aelfred2.XmlReader", "afu.org.apache.crimson.parser.XMLReaderImpl", "afu.com.bluecast.xml.Piccolo", "oracle.xml.parser.v2.SAXParser", "afu.com.jclark.xml.sax.SAX2Driver", "afu.net.sf.saxon.aelfred.SAXDriver", "afu.com.icl.saxon.aelfred.SAXDriver", "afu.org.dom4j.io.aelfred2.SAXDriver", "afu.org.dom4j.io.aelfred.SAXDriver", "afu.org.xmlpull.v1.sax2.Driver"};
        fileURLPrefix = "file://";
        string = System.getProperty("os.name", "Unix");
        if (string.indexOf("Windows") >= 0) {
            fileURLPrefix = "file:/";
        }
    }

    private static class NamespaceWellformednessRequired
    implements ErrorHandler {
        private NamespaceWellformednessRequired() {
        }

        public void warning(SAXParseException sAXParseException) {
        }

        public void error(SAXParseException sAXParseException) throws SAXParseException {
            if (sAXParseException.getMessage().equals("Illegal Namespace prefix: \"xml\".")) {
                return;
            }
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            throw sAXParseException;
        }
    }

    private static class ValidityRequired
    implements ErrorHandler {
        ValidityException vexception = null;

        private ValidityRequired() {
        }

        void reset() {
            this.vexception = null;
        }

        public void warning(SAXParseException sAXParseException) {
        }

        public void error(SAXParseException sAXParseException) {
            if (this.vexception == null) {
                this.vexception = new ValidityException(sAXParseException.getMessage(), sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), (Throwable)sAXParseException);
            }
            this.vexception.addError(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            throw sAXParseException;
        }

        boolean isValid() {
            return this.vexception == null;
        }
    }
}

