/*
 * Decompiled with CFR 0.152.
 */
package afu.nu.xom.xslt;

import afu.nu.xom.Document;
import afu.nu.xom.Element;
import afu.nu.xom.NodeFactory;
import afu.nu.xom.Nodes;
import afu.nu.xom.XMLException;
import afu.nu.xom.xslt.XOMResult;
import afu.nu.xom.xslt.XOMSource;
import afu.nu.xom.xslt.XSLException;
import afu.org.xml.sax.SAXParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;

public final class XSLTransform {
    private Templates templates;
    private NodeFactory factory;
    private Map parameters = new HashMap();
    private static ErrorListener errorsAreFatal = new FatalListener();

    private XSLTransform(Source source) throws XSLException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setErrorListener(errorsAreFatal);
            this.templates = transformerFactory.newTemplates(source);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            throw new XSLException("Could not locate a TrAX TransformerFactory", transformerFactoryConfigurationError);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XSLException("Syntax error in stylesheet", transformerConfigurationException);
        }
    }

    public XSLTransform(Document document) throws XSLException {
        this(document, new NodeFactory());
    }

    public XSLTransform(Document document, NodeFactory nodeFactory) throws XSLException {
        this(new XOMSource(document));
        this.factory = nodeFactory == null ? new NodeFactory() : nodeFactory;
    }

    public Nodes transform(Document document) throws XSLException {
        return this.transform(new XOMSource(document));
    }

    public void setParameter(String string, Object object) {
        this.setParameter(string, null, object);
    }

    public void setParameter(String string, String string2, Object object) {
        if (string2 == null || "".equals(string2)) {
            this._setParameter(string, object);
        } else {
            this._setParameter("{" + string2 + "}" + string, object);
        }
    }

    private void _setParameter(String string, Object object) {
        if (object == null) {
            this.parameters.remove(string);
        } else {
            this.parameters.put(string, object);
        }
    }

    public Nodes transform(Nodes nodes) throws XSLException {
        if (nodes.size() == 0) {
            return new Nodes();
        }
        XOMSource xOMSource = new XOMSource(nodes);
        return this.transform(xOMSource);
    }

    private Nodes transform(Source source) throws XSLException {
        try {
            XOMResult xOMResult = new XOMResult(this.factory);
            Transformer transformer = this.templates.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setErrorListener(errorsAreFatal);
            Iterator iterator = this.parameters.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = this.parameters.get(string);
                transformer.setParameter(string, v);
            }
            transformer.transform(source, xOMResult);
            return xOMResult.getResult();
        }
        catch (Exception exception) {
            TransformerException transformerException;
            Throwable throwable;
            Throwable throwable2 = exception;
            if (throwable2 instanceof TransformerException && (throwable = (transformerException = (TransformerException)throwable2).getException()) != null && (throwable2 = throwable) instanceof SAXParseException && (throwable = ((SAXParseException)throwable2).getException()) != null) {
                throwable2 = throwable;
            }
            throw new XSLException(exception.getMessage(), throwable2);
        }
    }

    public static Document toDocument(Nodes nodes) {
        int n;
        Element element = null;
        int n2 = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            if (!(nodes.get(i) instanceof Element)) continue;
            n2 = i;
            element = (Element)nodes.get(i);
            break;
        }
        if (element == null) {
            throw new XMLException("No root element");
        }
        Document document = new Document(element);
        for (n = 0; n < n2; ++n) {
            document.insertChild(nodes.get(n), n);
        }
        for (n = n2 + 1; n < nodes.size(); ++n) {
            document.appendChild(nodes.get(n));
        }
        return document;
    }

    public String toString() {
        return "[" + this.getClass().getName() + ": " + this.templates + "]";
    }

    private static class FatalListener
    implements ErrorListener {
        private FatalListener() {
        }

        public void warning(TransformerException transformerException) {
        }

        public void error(TransformerException transformerException) throws TransformerException {
            throw transformerException;
        }

        public void fatalError(TransformerException transformerException) throws TransformerException {
            throw transformerException;
        }
    }
}

