/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.Const;
import afu.org.apache.commons.bcel6.classfile.ClassFormatException;
import afu.org.apache.commons.bcel6.classfile.ConstantClass;
import afu.org.apache.commons.bcel6.classfile.ConstantDouble;
import afu.org.apache.commons.bcel6.classfile.ConstantFieldref;
import afu.org.apache.commons.bcel6.classfile.ConstantFloat;
import afu.org.apache.commons.bcel6.classfile.ConstantInteger;
import afu.org.apache.commons.bcel6.classfile.ConstantInterfaceMethodref;
import afu.org.apache.commons.bcel6.classfile.ConstantInvokeDynamic;
import afu.org.apache.commons.bcel6.classfile.ConstantLong;
import afu.org.apache.commons.bcel6.classfile.ConstantMethodHandle;
import afu.org.apache.commons.bcel6.classfile.ConstantMethodType;
import afu.org.apache.commons.bcel6.classfile.ConstantMethodref;
import afu.org.apache.commons.bcel6.classfile.ConstantNameAndType;
import afu.org.apache.commons.bcel6.classfile.ConstantString;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.Node;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.apache.commons.bcel6.util.BCELComparator;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.Pure;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Constant
implements Cloneable,
Node {
    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BCELComparator _cmp = new BCELComparator(){

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object o1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object o2) {
            Constant THIS = (Constant)o1;
            Constant THAT = (Constant)o2;
            return THIS.toString().equals(THAT.toString());
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int hashCode(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object o) {
            Constant THIS = (Constant)o;
            return THIS.toString().hashCode();
        }
    };
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte tag;

    Constant(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte tag) {
        this.tag = tag;
    }

    @Override
    public abstract void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor var1);

    public abstract void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream var1) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException;

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte getTag() {
        return this.tag;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        return Const.getConstantName(this.tag) + "[" + this.tag + "]";
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Constant copy() {
        try {
            return (Constant)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Constant readConstant(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput input) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassFormatException {
        byte b = input.readByte();
        switch (b) {
            case 7: {
                return new ConstantClass(input);
            }
            case 9: {
                return new ConstantFieldref(input);
            }
            case 10: {
                return new ConstantMethodref(input);
            }
            case 11: {
                return new ConstantInterfaceMethodref(input);
            }
            case 8: {
                return new ConstantString(input);
            }
            case 3: {
                return new ConstantInteger(input);
            }
            case 4: {
                return new ConstantFloat(input);
            }
            case 5: {
                return new ConstantLong(input);
            }
            case 6: {
                return new ConstantDouble(input);
            }
            case 12: {
                return new ConstantNameAndType(input);
            }
            case 1: {
                return ConstantUtf8.getInstance(input);
            }
            case 15: {
                return new ConstantMethodHandle(input);
            }
            case 16: {
                return new ConstantMethodType(input);
            }
            case 18: {
                return new ConstantInvokeDynamic(input);
            }
        }
        throw new ClassFormatException("Invalid byte tag in constant pool: " + b);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BCELComparator getComparator() {
        return _cmp;
    }

    public static void setComparator(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BCELComparator comparator) {
        _cmp = comparator;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object obj) {
        return _cmp.equals(this, obj);
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int hashCode() {
        return _cmp.hashCode(this);
    }
}

