/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.AccessFlags;
import afu.org.apache.commons.bcel6.classfile.AnnotationEntry;
import afu.org.apache.commons.bcel6.classfile.Attribute;
import afu.org.apache.commons.bcel6.classfile.ClassFormatException;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.Node;
import afu.org.apache.commons.bcel6.classfile.Signature;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class FieldOrMethod
extends AccessFlags
implements Cloneable,
Node {
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index;
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int signature_index;
    @Deprecated
    protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] attributes;
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int attributes_count;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] annotationEntries;
    @Deprecated
    protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String signatureAttributeString = null;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean searchedForSignatureAttribute = false;

    FieldOrMethod() {
    }

    protected FieldOrMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FieldOrMethod c) {
        this(c.getAccessFlags(), c.getNameIndex(), c.getSignatureIndex(), c.getAttributes(), c.getConstantPool());
    }

    protected FieldOrMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInputStream file, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassFormatException {
        this((DataInput)file, constant_pool);
    }

    protected FieldOrMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput file, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassFormatException {
        this(file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), null, constant_pool);
        int attributes_count = file.readUnsignedShort();
        this.attributes = new Attribute[attributes_count];
        for (int i = 0; i < attributes_count; ++i) {
            this.attributes[i] = Attribute.readAttribute(file, constant_pool);
        }
        this.attributes_count = attributes_count;
    }

    protected FieldOrMethod(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int access_flags, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int signature_index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] attributes, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        super(access_flags);
        this.name_index = name_index;
        this.signature_index = signature_index;
        this.constant_pool = constant_pool;
        this.setAttributes(attributes);
    }

    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        file.writeShort(super.getAccessFlags());
        file.writeShort(this.name_index);
        file.writeShort(this.signature_index);
        file.writeShort(this.attributes.length);
        for (Attribute attribute : this.attributes) {
            attribute.dump(file);
        }
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] attributes) {
        this.attributes = attributes;
        this.attributes_count = attributes != null ? attributes.length : 0;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final void setConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getNameIndex() {
        return this.name_index;
    }

    public final void setNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index) {
        this.name_index = name_index;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getSignatureIndex() {
        return this.signature_index;
    }

    public final void setSignatureIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int signature_index) {
        this.signature_index = signature_index;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getName() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        return c.getBytes();
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getSignature() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        return c.getBytes();
    }

    protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FieldOrMethod copy_(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool _constant_pool) {
        FieldOrMethod c = null;
        try {
            c = (FieldOrMethod)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        c.constant_pool = this.constant_pool;
        c.attributes = new Attribute[this.attributes.length];
        c.attributes_count = this.attributes_count;
        for (int i = 0; i < this.attributes.length; ++i) {
            c.attributes[i] = this.attributes[i].copy(this.constant_pool);
        }
        return c;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getAnnotationEntries() {
        if (this.annotationEntries == null) {
            this.annotationEntries = AnnotationEntry.createAnnotationEntries(this.getAttributes());
        }
        return this.annotationEntries;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getGenericSignature() {
        if (!this.searchedForSignatureAttribute) {
            boolean found = false;
            for (int i = 0; !found && i < this.attributes.length; ++i) {
                if (!(this.attributes[i] instanceof Signature)) continue;
                this.signatureAttributeString = ((Signature)this.attributes[i]).getSignature();
                found = true;
            }
            this.searchedForSignatureAttribute = true;
        }
        return this.signatureAttributeString;
    }
}

