/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.Node;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class LineNumber
implements Cloneable,
Node {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short start_pc;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short line_number;

    public LineNumber(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LineNumber c) {
        this(c.getStartPC(), c.getLineNumber());
    }

    LineNumber(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort());
    }

    public LineNumber(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int start_pc, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int line_number) {
        this.start_pc = (short)start_pc;
        this.line_number = (short)line_number;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitLineNumber(this);
    }

    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        file.writeShort(this.start_pc);
        file.writeShort(this.line_number);
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getLineNumber() {
        return 0xFFFF & this.line_number;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getStartPC() {
        return 0xFFFF & this.start_pc;
    }

    public final void setLineNumber(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int line_number) {
        this.line_number = (short)line_number;
    }

    public final void setStartPC(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int start_pc) {
        this.start_pc = (short)start_pc;
    }

    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        return "LineNumber(" + this.start_pc + ", " + this.line_number + ")";
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LineNumber copy() {
        try {
            return (LineNumber)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

