/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.Attribute;
import afu.org.apache.commons.bcel6.classfile.ClassFormatException;
import afu.org.apache.commons.bcel6.classfile.Code;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.ExceptionTable;
import afu.org.apache.commons.bcel6.classfile.FieldOrMethod;
import afu.org.apache.commons.bcel6.classfile.LineNumberTable;
import afu.org.apache.commons.bcel6.classfile.LocalVariableTable;
import afu.org.apache.commons.bcel6.classfile.ParameterAnnotationEntry;
import afu.org.apache.commons.bcel6.classfile.Utility;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.apache.commons.bcel6.util.BCELComparator;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.Nullable;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.Pure;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import afu.org.checkerframework.framework.qual.AnnotatedFor;
import java.io.DataInput;
import java.io.IOException;

@AnnotatedFor(value={"nullness"})
public final class Method
extends FieldOrMethod {
    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BCELComparator _cmp = new BCELComparator(){

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object o1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object o2) {
            Method THIS = (Method)o1;
            Method THAT = (Method)o2;
            return THIS.getName().equals(THAT.getName()) && THIS.getSignature().equals(THAT.getSignature());
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int hashCode(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object o) {
            Method THIS = (Method)o;
            return THIS.getSignature().hashCode() ^ THIS.getName().hashCode();
        }
    };
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ParameterAnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] parameterAnnotationEntries;

    public Method() {
    }

    public Method(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Method c) {
        super(c);
    }

    Method(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput file, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassFormatException {
        super(file, constant_pool);
    }

    public Method(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int access_flags, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int signature_index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] attributes, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        super(access_flags, name_index, signature_index, attributes, constant_pool);
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitMethod(this);
    }

    public final @Nullable @UnknownInterned @UnknownKeyFor @Initialized @UnannotatedString Code getCode() {
        for (Attribute attribute : super.getAttributes()) {
            if (!(attribute instanceof Code)) continue;
            return (Code)attribute;
        }
        return null;
    }

    public final @Nullable @UnknownInterned @UnknownKeyFor @Initialized @UnannotatedString ExceptionTable getExceptionTable() {
        for (Attribute attribute : super.getAttributes()) {
            if (!(attribute instanceof ExceptionTable)) continue;
            return (ExceptionTable)attribute;
        }
        return null;
    }

    public final @Nullable @UnknownInterned @UnknownKeyFor @Initialized @UnannotatedString LocalVariableTable getLocalVariableTable() {
        Code code = this.getCode();
        if (code == null) {
            return null;
        }
        return code.getLocalVariableTable();
    }

    public final @Nullable @UnknownInterned @UnknownKeyFor @Initialized @UnannotatedString LineNumberTable getLineNumberTable() {
        Code code = this.getCode();
        if (code == null) {
            return null;
        }
        return code.getLineNumberTable();
    }

    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        String str;
        String access = Utility.accessToString(super.getAccessFlags());
        ConstantUtf8 c = (ConstantUtf8)super.getConstantPool().getConstant(super.getSignatureIndex(), (byte)1);
        String signature = c.getBytes();
        c = (ConstantUtf8)super.getConstantPool().getConstant(super.getNameIndex(), (byte)1);
        String name = c.getBytes();
        signature = Utility.methodSignatureToString(signature, name, access, true, this.getLocalVariableTable());
        StringBuilder buf = new StringBuilder(signature);
        for (Attribute attribute : super.getAttributes()) {
            if (attribute instanceof Code || attribute instanceof ExceptionTable) continue;
            buf.append(" [").append(attribute).append("]");
        }
        ExceptionTable e = this.getExceptionTable();
        if (e != null && !(str = e.toString()).equals("")) {
            buf.append("\n\t\tthrows ").append(str);
        }
        return buf.toString();
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Method copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool _constant_pool) {
        return (Method)this.copy_(_constant_pool);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type getReturnType() {
        return Type.getReturnType(this.getSignature());
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getArgumentTypes() {
        return Type.getArgumentTypes(this.getSignature());
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BCELComparator getComparator() {
        return _cmp;
    }

    public static void setComparator(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BCELComparator comparator) {
        _cmp = comparator;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean equals(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @UnannotatedString Object obj) {
        return _cmp.equals(this, obj);
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int hashCode() {
        return _cmp.hashCode(this);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ParameterAnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getParameterAnnotationEntries() {
        if (this.parameterAnnotationEntries == null) {
            this.parameterAnnotationEntries = ParameterAnnotationEntry.createParameterAnnotationEntries(this.getAttributes());
        }
        return this.parameterAnnotationEntries;
    }
}

