/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.classfile.ConstantCP;
import afu.org.apache.commons.bcel6.classfile.ConstantNameAndType;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.generic.ArrayType;
import afu.org.apache.commons.bcel6.generic.CPInstruction;
import afu.org.apache.commons.bcel6.generic.ClassGenException;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.LoadClass;
import afu.org.apache.commons.bcel6.generic.ObjectType;
import afu.org.apache.commons.bcel6.generic.ReferenceType;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.BinaryNameForNonArray;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.framework.qual.AnnotatedFor;

@AnnotatedFor(value={"signature"})
public abstract class FieldOrMethod
extends CPInstruction
implements LoadClass {
    FieldOrMethod() {
    }

    protected FieldOrMethod(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short opcode, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index) {
        super(opcode, index);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getSignature(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg) {
        ConstantPool cp = cpg.getConstantPool();
        ConstantCP cmr = (ConstantCP)cp.getConstant(super.getIndex());
        ConstantNameAndType cnat = (ConstantNameAndType)cp.getConstant(cmr.getNameAndTypeIndex());
        return ((ConstantUtf8)cp.getConstant(cnat.getSignatureIndex())).getBytes();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg) {
        ConstantPool cp = cpg.getConstantPool();
        ConstantCP cmr = (ConstantCP)cp.getConstant(super.getIndex());
        ConstantNameAndType cnat = (ConstantNameAndType)cp.getConstant(cmr.getNameAndTypeIndex());
        return ((ConstantUtf8)cp.getConstant(cnat.getNameIndex())).getBytes();
    }

    @Deprecated
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @BinaryNameForNonArray String getClassName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg) {
        ConstantCP cmr;
        ConstantPool cp = cpg.getConstantPool();
        String className = cp.getConstantString((cmr = (ConstantCP)cp.getConstant(super.getIndex())).getClassIndex(), (byte)7);
        if (className.startsWith("[")) {
            return "java.lang.Object";
        }
        return className.replace('/', '.');
    }

    @Deprecated
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ObjectType getClassType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg) {
        return ObjectType.getInstance(this.getClassName(cpg));
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ReferenceType getReferenceType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg) {
        ConstantCP cmr;
        ConstantPool cp = cpg.getConstantPool();
        String className = cp.getConstantString((cmr = (ConstantCP)cp.getConstant(super.getIndex())).getClassIndex(), (byte)7);
        if (className.startsWith("[")) {
            return (ArrayType)Type.getType(className);
        }
        className = className.replace('/', '.');
        return ObjectType.getInstance(className);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ObjectType getLoadClassType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg) {
        ReferenceType rt = this.getReferenceType(cpg);
        if (rt instanceof ObjectType) {
            return (ObjectType)rt;
        }
        throw new ClassGenException(rt.getSignature() + " does not represent an ObjectType");
    }
}

