/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.generic.BIPUSH;
import afu.org.apache.commons.bcel6.generic.ClassGenException;
import afu.org.apache.commons.bcel6.generic.CompoundInstruction;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.Instruction;
import afu.org.apache.commons.bcel6.generic.InstructionConst;
import afu.org.apache.commons.bcel6.generic.InstructionList;
import afu.org.apache.commons.bcel6.generic.LDC;
import afu.org.apache.commons.bcel6.generic.LDC2_W;
import afu.org.apache.commons.bcel6.generic.ObjectType;
import afu.org.apache.commons.bcel6.generic.SIPUSH;
import afu.org.apache.commons.bcel6.generic.VariableLengthInstruction;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;

public final class PUSH
implements CompoundInstruction,
VariableLengthInstruction {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction instruction;

    public PUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cp, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int value) {
        this.instruction = value >= -1 && value <= 5 ? InstructionConst.getInstruction(3 + value) : (Instruction.isValidByte(value) ? new BIPUSH((byte)value) : (Instruction.isValidShort(value) ? new SIPUSH((short)value) : new LDC(cp.addInteger(value))));
    }

    public PUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cp, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean value) {
        this.instruction = InstructionConst.getInstruction(3 + (value ? 1 : 0));
    }

    public PUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cp, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString float value) {
        this.instruction = (double)value == 0.0 ? InstructionConst.FCONST_0 : ((double)value == 1.0 ? InstructionConst.FCONST_1 : ((double)value == 2.0 ? InstructionConst.FCONST_2 : new LDC(cp.addFloat(value))));
    }

    public PUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cp, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString long value) {
        this.instruction = value == 0L ? InstructionConst.LCONST_0 : (value == 1L ? InstructionConst.LCONST_1 : new LDC2_W(cp.addLong(value)));
    }

    public PUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cp, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString double value) {
        this.instruction = value == 0.0 ? InstructionConst.DCONST_0 : (value == 1.0 ? InstructionConst.DCONST_1 : new LDC2_W(cp.addDouble(value)));
    }

    public PUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cp, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String value) {
        this.instruction = value == null ? InstructionConst.ACONST_NULL : new LDC(cp.addString(value));
    }

    public PUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cp, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ObjectType value) {
        this.instruction = value == null ? InstructionConst.ACONST_NULL : new LDC(cp.addClass(value));
    }

    public PUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cp, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Number value) {
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            this.instruction = new PUSH((ConstantPoolGen)cp, (int)value.intValue()).instruction;
        } else if (value instanceof Double) {
            this.instruction = new PUSH((ConstantPoolGen)cp, (double)value.doubleValue()).instruction;
        } else if (value instanceof Float) {
            this.instruction = new PUSH((ConstantPoolGen)cp, (float)value.floatValue()).instruction;
        } else if (value instanceof Long) {
            this.instruction = new PUSH((ConstantPoolGen)cp, (long)value.longValue()).instruction;
        } else {
            throw new ClassGenException("What's this: " + value);
        }
    }

    public PUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cp, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Character value) {
        this(cp, (int)value.charValue());
    }

    public PUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cp, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Boolean value) {
        this(cp, (boolean)value);
    }

    @Override
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionList getInstructionList() {
        return new InstructionList(this.instruction);
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction getInstruction() {
        return this.instruction;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        return this.instruction + " (PUSH)";
    }
}

