/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.generic.ClassGenException;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.IndexedInstruction;
import afu.org.apache.commons.bcel6.generic.Instruction;
import afu.org.apache.commons.bcel6.generic.ReturnaddressType;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.apache.commons.bcel6.generic.TypedInstruction;
import afu.org.apache.commons.bcel6.generic.Visitor;
import afu.org.apache.commons.bcel6.util.ByteSequence;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.io.DataOutputStream;
import java.io.IOException;

public class RET
extends Instruction
implements IndexedInstruction,
TypedInstruction {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean wide;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index;

    RET() {
    }

    public RET(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index) {
        super((short)169, (short)2);
        this.setIndex(index);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream out) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        if (this.wide) {
            out.writeByte(196);
        }
        out.writeByte(super.getOpcode());
        if (this.wide) {
            out.writeShort(this.index);
        } else {
            out.writeByte(this.index);
        }
    }

    private void setWide() {
        boolean bl = this.wide = this.index > 255;
        if (this.wide) {
            super.setLength(4);
        } else {
            super.setLength(2);
        }
    }

    @Override
    protected void initFromFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ByteSequence bytes, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean wide) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this.wide = wide;
        if (wide) {
            this.index = bytes.readUnsignedShort();
            super.setLength(4);
        } else {
            this.index = bytes.readUnsignedByte();
            super.setLength(2);
        }
    }

    @Override
    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getIndex() {
        return this.index;
    }

    @Override
    public final void setIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int n) {
        if (n < 0) {
            throw new ClassGenException("Negative index value: " + n);
        }
        this.index = n;
        this.setWide();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean verbose) {
        return super.toString(verbose) + " " + this.index;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type getType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cp) {
        return ReturnaddressType.NO_TARGET;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitRET(this);
    }
}

