/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.util;

import afu.org.apache.commons.bcel6.classfile.ClassParser;
import afu.org.apache.commons.bcel6.classfile.JavaClass;
import afu.org.apache.commons.bcel6.util.ClassPath;
import afu.org.apache.commons.bcel6.util.Repository;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.KeyForBottom;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.Nullable;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.SignatureBottom;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class SyntheticRepository
implements Repository {
    private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassPath, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString SyntheticRepository> _instances = new HashMap<ClassPath, SyntheticRepository>();
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassPath _path = null;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString SoftReference<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass>> _loadedClasses = new HashMap<String, SoftReference<JavaClass>>();

    private SyntheticRepository(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassPath path) {
        this._path = path;
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString SyntheticRepository getInstance() {
        return SyntheticRepository.getInstance(ClassPath.SYSTEM_CLASS_PATH);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString SyntheticRepository getInstance(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassPath classPath) {
        SyntheticRepository rep = _instances.get(classPath);
        if (rep == null) {
            rep = new SyntheticRepository(classPath);
            _instances.put(classPath, rep);
        }
        return rep;
    }

    @Override
    public void storeClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass clazz) {
        this._loadedClasses.put(clazz.getClassName(), new SoftReference<JavaClass>(clazz));
        clazz.setRepository(this);
    }

    @Override
    public void removeClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass clazz) {
        this._loadedClasses.remove(clazz.getClassName());
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass findClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String className) {
        SoftReference<JavaClass> ref = this._loadedClasses.get(className);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass loadClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String className) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassNotFoundException {
        if (className == null || className.equals("")) {
            throw new IllegalArgumentException("Invalid class name " + className);
        }
        JavaClass clazz = this.findClass(className = className.replace('/', '.'));
        if (clazz != null) {
            return clazz;
        }
        try {
            return this.loadClass(this._path.getInputStream(className), className);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass loadClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Class<@UnknownInterned @Interned @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized @UnannotatedString @SignatureBottom ?> clazz) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassNotFoundException {
        InputStream clsStream = null;
        try {
            String className = clazz.getName();
            JavaClass repositoryClass = this.findClass(className);
            if (repositoryClass != null) {
                JavaClass javaClass = repositoryClass;
                return javaClass;
            }
            String name = className;
            int i = name.lastIndexOf(46);
            if (i > 0) {
                name = name.substring(i + 1);
            }
            clsStream = clazz.getResourceAsStream(name + ".class");
            JavaClass javaClass = this.loadClass(clsStream, className);
            return javaClass;
        }
        finally {
            try {
                if (clsStream != null) {
                    clsStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass loadClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InputStream is, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String className) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassNotFoundException {
        try {
            if (is != null) {
                ClassParser parser = new ClassParser(is, className);
                JavaClass clazz = parser.parse();
                this.storeClass(clazz);
                JavaClass javaClass = clazz;
                return javaClass;
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new ClassNotFoundException("SyntheticRepository could not load " + className);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassPath getClassPath() {
        return this._path;
    }

    @Override
    public void clear() {
        this._loadedClasses.clear();
    }
}

