/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.verifier.statics;

import afu.org.apache.commons.bcel6.Repository;
import afu.org.apache.commons.bcel6.classfile.ClassFormatException;
import afu.org.apache.commons.bcel6.classfile.JavaClass;
import afu.org.apache.commons.bcel6.verifier.PassVerifier;
import afu.org.apache.commons.bcel6.verifier.VerificationResult;
import afu.org.apache.commons.bcel6.verifier.Verifier;
import afu.org.apache.commons.bcel6.verifier.exc.LoadingException;
import afu.org.apache.commons.bcel6.verifier.exc.Utility;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;

public final class Pass1Verifier
extends PassVerifier {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass jc;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Verifier myOwner;

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass getJavaClass() {
        if (this.jc == null) {
            try {
                this.jc = Repository.lookupClass(this.myOwner.getClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.jc;
    }

    public Pass1Verifier(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Verifier owner) {
        this.myOwner = owner;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString VerificationResult do_verify() {
        JavaClass jc;
        try {
            jc = this.getJavaClass();
            if (jc != null && !this.myOwner.getClassName().equals(jc.getClassName())) {
                throw new LoadingException("Wrong name: the internal name of the .class file '" + jc.getClassName() + "' does not match the file's name '" + this.myOwner.getClassName() + "'.");
            }
        }
        catch (LoadingException e) {
            return new VerificationResult(2, e.getMessage());
        }
        catch (ClassFormatException e) {
            return new VerificationResult(2, e.getMessage());
        }
        catch (RuntimeException e) {
            return new VerificationResult(2, "Parsing via BCEL did not succeed. " + e.getClass().getName() + " occured:\n" + Utility.getStackTrace(e));
        }
        if (jc != null) {
            return VerificationResult.VR_OK;
        }
        return new VerificationResult(2, "Repository.lookup() failed. FILE NOT FOUND?");
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getMessages() {
        return super.getMessages();
    }
}

