/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tigris.subversion.javahl;

import afu.org.tigris.subversion.javahl.ChangePath;
import afu.org.tigris.subversion.javahl.Revision;
import java.io.Serializable;
import java.util.Date;

public class LogMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String message;
    private long timeMicros;
    private Date date;
    private long revision;
    private String author;
    private ChangePath[] changedPaths;

    LogMessage(ChangePath[] cp, long r, String a, Date d, String m3) {
        this.changedPaths = cp;
        this.revision = r;
        this.author = a;
        this.timeMicros = 1000L * d.getTime();
        this.date = d;
        this.message = m3;
    }

    LogMessage(ChangePath[] cp, long r, String a, long t, String m3) {
        this.changedPaths = cp;
        this.revision = r;
        this.author = a;
        this.timeMicros = t;
        this.date = null;
        this.message = m3;
    }

    public String getMessage() {
        return this.message;
    }

    public long getTimeMicros() {
        return this.timeMicros;
    }

    public long getTimeMillis() {
        return this.timeMicros / 1000L;
    }

    public Date getDate() {
        if (this.date == null) {
            this.date = new Date(this.timeMicros / 1000L);
        }
        return this.date;
    }

    public Revision.Number getRevision() {
        return Revision.createNumber(this.revision);
    }

    public long getRevisionNumber() {
        return this.revision;
    }

    public String getAuthor() {
        return this.author;
    }

    public ChangePath[] getChangedPaths() {
        return this.changedPaths;
    }
}

