/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tigris.subversion.javahl;

import afu.org.tigris.subversion.javahl.RevisionRange;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mergeinfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, List<RevisionRange>> mergeSources = new HashMap<String, List<RevisionRange>>();

    public Mergeinfo() {
    }

    public Mergeinfo(String mergeinfo) {
        this();
        this.loadFromMergeinfoProperty(mergeinfo);
    }

    public Mergeinfo(afu.org.apache.subversion.javahl.types.Mergeinfo aMergeinfo) {
        this();
        Set<String> srcPaths = aMergeinfo.getPaths();
        for (String srcPath : srcPaths) {
            List<afu.org.apache.subversion.javahl.types.RevisionRange> aRanges = aMergeinfo.getRevisionRange(srcPath);
            ArrayList<RevisionRange> list = new ArrayList<RevisionRange>();
            for (afu.org.apache.subversion.javahl.types.RevisionRange range : aRanges) {
                list.add(new RevisionRange(range));
            }
            this.mergeSources.put(srcPath, list);
        }
    }

    public void addRevisions(String mergeSrc, RevisionRange[] ranges) {
        for (int i = 0; i < ranges.length; ++i) {
            this.addRevisionRange(mergeSrc, ranges[i]);
        }
    }

    public void addRevisionRange(String mergeSrc, RevisionRange range) {
        List<RevisionRange> revisions = this.getRevisions(mergeSrc);
        if (revisions == null) {
            revisions = new ArrayList<RevisionRange>();
        }
        revisions.add(range);
        this.setRevisionList(mergeSrc, revisions);
    }

    public String[] getPaths() {
        Set<String> pathSet = this.mergeSources.keySet();
        if (pathSet == null) {
            return null;
        }
        return pathSet.toArray(new String[pathSet.size()]);
    }

    public List<RevisionRange> getRevisions(String mergeSrc) {
        if (mergeSrc == null) {
            return null;
        }
        return this.mergeSources.get(mergeSrc);
    }

    public RevisionRange[] getRevisionRange(String mergeSrc) {
        List<RevisionRange> revisions = this.getRevisions(mergeSrc);
        if (revisions == null) {
            return null;
        }
        return revisions.toArray(new RevisionRange[revisions.size()]);
    }

    public void loadFromMergeinfoProperty(String mergeinfo) {
        if (mergeinfo == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(mergeinfo, "\n");
        while (st.hasMoreTokens()) {
            this.parseMergeinfoLine(st.nextToken());
        }
    }

    private void parseMergeinfoLine(String line) {
        int colon = line.indexOf(58);
        if (colon > 0) {
            String pathElement = line.substring(0, colon);
            String revisions = line.substring(colon + 1);
            this.parseRevisions(pathElement, revisions);
        }
    }

    private void parseRevisions(String path, String revisions) {
        List<RevisionRange> rangeList = this.getRevisions(path);
        StringTokenizer st = new StringTokenizer(revisions, ",");
        while (st.hasMoreTokens()) {
            String revisionElement = st.nextToken();
            RevisionRange range = new RevisionRange(revisionElement);
            if (rangeList == null) {
                rangeList = new ArrayList<RevisionRange>();
            }
            rangeList.add(range);
        }
        if (rangeList != null) {
            this.setRevisionList(path, rangeList);
        }
    }

    private void setRevisionList(String mergeSrc, List<RevisionRange> range) {
        this.mergeSources.put(mergeSrc, range);
    }
}

