/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.sqljet.core.internal.map;

import afu.org.tmatesoft.sqljet.core.SqlJetException;
import afu.org.tmatesoft.sqljet.core.internal.ISqlJetBtree;
import afu.org.tmatesoft.sqljet.core.internal.map.SqlJetMapCursor;
import afu.org.tmatesoft.sqljet.core.internal.map.SqlJetMapDef;
import afu.org.tmatesoft.sqljet.core.internal.map.SqlJetMapIndex;
import afu.org.tmatesoft.sqljet.core.internal.map.SqlJetMapTable;
import afu.org.tmatesoft.sqljet.core.map.ISqlJetMap;
import afu.org.tmatesoft.sqljet.core.map.ISqlJetMapCursor;
import afu.org.tmatesoft.sqljet.core.map.ISqlJetMapIndex;
import afu.org.tmatesoft.sqljet.core.map.ISqlJetMapTable;
import afu.org.tmatesoft.sqljet.core.map.ISqlJetMapTransaction;
import afu.org.tmatesoft.sqljet.core.map.SqlJetMapDb;
import afu.org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import afu.org.tmatesoft.sqljet.core.table.engine.ISqlJetEngineSynchronized;
import afu.org.tmatesoft.sqljet.core.table.engine.SqlJetEngine;

public class SqlJetMap
implements ISqlJetMap {
    private final SqlJetMapDb mapDb;
    private final ISqlJetBtree btree;
    private final SqlJetMapDef mapDef;
    private boolean writable;
    private ISqlJetMapTable mapTable;
    private ISqlJetMapIndex mapIndex;

    public SqlJetMap(SqlJetMapDb mapDb, ISqlJetBtree btree, SqlJetMapDef mapDef, boolean writable) {
        this.mapDb = mapDb;
        this.btree = btree;
        this.mapDef = mapDef;
        this.writable = writable;
    }

    public ISqlJetMapCursor getCursor() throws SqlJetException {
        return (ISqlJetMapCursor)this.mapDb.runSynchronized(new ISqlJetEngineSynchronized(){

            public Object runSynchronized(SqlJetEngine engine) throws SqlJetException {
                return new SqlJetMapCursor(SqlJetMap.this.mapDb, SqlJetMap.this.btree, SqlJetMap.this.mapDef, SqlJetMap.this.writable);
            }
        });
    }

    public void put(final Object[] key, final Object[] value) throws SqlJetException {
        this.mapDb.runWriteTransaction(new ISqlJetMapTransaction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run(SqlJetMapDb mapDb) throws SqlJetException {
                Object var3_3;
                ISqlJetMapCursor cursor = SqlJetMap.this.getCursor();
                try {
                    cursor.put(key, value);
                    var3_3 = null;
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    cursor.close();
                    throw throwable;
                }
                cursor.close();
                return var3_3;
            }
        });
    }

    public Object[] get(final Object[] key) throws SqlJetException {
        return (Object[])this.mapDb.runReadTransaction(new ISqlJetMapTransaction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run(SqlJetMapDb mapDb) throws SqlJetException {
                ISqlJetMapCursor cursor;
                block3: {
                    Object[] objectArray;
                    cursor = SqlJetMap.this.getCursor();
                    try {
                        if (!cursor.goToKey(key)) break block3;
                        objectArray = cursor.getValue();
                        Object var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        cursor.close();
                        throw throwable;
                    }
                    cursor.close();
                    return objectArray;
                }
                Object var3_4 = null;
                Object var5_6 = null;
                cursor.close();
                return var3_4;
            }
        });
    }

    public synchronized ISqlJetMapTable getMapTable() throws SqlJetException {
        if (this.mapTable == null) {
            this.mapTable = new SqlJetMapTable(this.mapDb, this.btree, this.mapDef, this.writable);
        }
        return this.mapTable;
    }

    public synchronized ISqlJetMapIndex getMapIndex() throws SqlJetException {
        if (this.mapIndex == null) {
            ISqlJetIndexDef indexDef = this.mapDef.getIndexDef();
            this.mapIndex = new SqlJetMapIndex(this.mapDb, this.btree, indexDef, this.writable);
        }
        return this.mapIndex;
    }
}

